/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import java.lang.ref.SoftReference;
import java.util.function.Supplier;

public abstract class Lazy<E> {
    private SoftReference<E> implOrNullCache = null;
    private E implOrNull = null;

    void simulateGC() {
        if (this.implOrNullCache != null) {
            this.implOrNullCache.clear();
        }
    }

    public synchronized E get() {
        E orNull = this.getIfDefined();
        if (orNull == null) {
            orNull = this.compute();
            if (this.isCache()) {
                this.implOrNullCache = new SoftReference<E>(orNull);
            } else {
                this.implOrNull = orNull;
            }
        }
        assert (orNull != null);
        return orNull;
    }

    protected abstract E compute();

    public abstract boolean isCache();

    public E getIfDefined() {
        if (this.implOrNullCache != null) {
            assert (this.implOrNull == null);
            return this.implOrNullCache.get();
        }
        return this.implOrNull;
    }

    public boolean isGarbageCollected() {
        return this.isCache() && (this.implOrNullCache == null || this.implOrNullCache.get() == null);
    }

    public static <E> Lazy<E> from(final E definedElement) {
        Lazy rtn = new Lazy<E>(){

            @Override
            protected E compute() {
                return definedElement;
            }

            @Override
            public boolean isCache() {
                return false;
            }
        };
        rtn.implOrNull = definedElement;
        return rtn;
    }

    public static <E> Lazy<E> of(final Supplier<E> fn) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return fn.get();
            }

            @Override
            public boolean isCache() {
                return false;
            }
        };
    }

    public static <E> Lazy<E> cache(final Supplier<E> fn) {
        return new Lazy<E>(){

            @Override
            protected E compute() {
                return fn.get();
            }

            @Override
            public boolean isCache() {
                return true;
            }
        };
    }
}

