/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.logging;

import edu.stanford.nlp.util.logging.LogRecordHandler;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;

public class RepeatedRecordHandler
extends LogRecordHandler {
    private final Stack<RepeatedRecordInfo> stack = new Stack();
    RepeatedRecordInfo current = new RepeatedRecordInfo();
    private final RepeatSemantics repeatSemantics;
    public static final ApproximateRepeatSemantics APPROXIMATE = new ApproximateRepeatSemantics();
    public static final ExactRepeatSemantics EXACT = new ExactRepeatSemantics();

    public RepeatedRecordHandler(RepeatSemantics repeatSemantics) {
        this.repeatSemantics = repeatSemantics;
    }

    private void flush(RepeatedRecordInfo info, List<Redwood.Record> willReturn) {
        if (info.suppressRecord) {
            return;
        }
        int repeatedRecordCount = info.timesSeen - info.timesPrinted;
        if (repeatedRecordCount > 0) {
            Object[] newTags = new Object[info.lastRecord.channels().length + 1];
            System.arraycopy(info.lastRecord.channels(), 0, newTags, 1, info.lastRecord.channels().length);
            newTags[0] = Redwood.FORCE;
            Redwood.Record newRecord = new Redwood.Record(this.repeatSemantics.message(repeatedRecordCount), newTags, ((RepeatedRecordInfo)info).lastRecord.depth, ((RepeatedRecordInfo)info).lastRecord.timesstamp);
            willReturn.add(newRecord);
            info.timesSeen = 0;
            info.timesPrinted = 0;
        }
    }

    private void flushParents(List<Redwood.Record> willReturn) {
        Stack<RepeatedRecordInfo> reverseStack = new Stack<RepeatedRecordInfo>();
        while (!this.stack.isEmpty()) {
            reverseStack.push(this.stack.pop());
        }
        while (!reverseStack.isEmpty()) {
            RepeatedRecordInfo info;
            RepeatedRecordInfo repeatedRecordInfo = info = (RepeatedRecordInfo)reverseStack.pop();
            repeatedRecordInfo.timesSeen = repeatedRecordInfo.timesSeen - 1;
            this.flush(info, willReturn);
            this.stack.push(info);
        }
    }

    private boolean recordVerdict(Redwood.Record r, boolean isRepeat, boolean shouldPrint, List<Redwood.Record> willReturn) {
        RepeatedRecordInfo repeatedRecordInfo;
        if (r.force()) {
            this.flushParents(willReturn);
            if (isRepeat) {
                this.flush(this.current, willReturn);
            }
            shouldPrint = true;
        }
        if (!isRepeat) {
            this.flush(this.current, willReturn);
            this.current.lastRecord = r;
        }
        if (shouldPrint) {
            this.current.timeOfLastPrintedRecord = r.timesstamp;
            repeatedRecordInfo = this.current;
            repeatedRecordInfo.timesPrinted = repeatedRecordInfo.timesPrinted + 1;
        }
        repeatedRecordInfo = this.current;
        repeatedRecordInfo.timesSeen = repeatedRecordInfo.timesSeen + 1;
        this.current.somethingPrinted = true;
        return shouldPrint;
    }

    private boolean internalHandle(Redwood.Record record, List<Redwood.Record> willReturn) {
        if (this.current.suppressRecord) {
            return this.recordVerdict(record, false, false, willReturn);
        }
        if (this.current.lastRecord == null) {
            return this.recordVerdict(record, false, true, willReturn);
        }
        if (this.repeatSemantics.equals(this.current.lastRecord, record)) {
            long currentTime = record.timesstamp;
            if (currentTime - this.current.timeOfLastPrintedRecord > this.repeatSemantics.maxWaitTimeInMillis()) {
                return this.recordVerdict(record, true, true, willReturn);
            }
            if (this.current.timesSeen < this.repeatSemantics.numToForcePrint()) {
                return this.recordVerdict(record, true, true, willReturn);
            }
            return this.recordVerdict(record, true, false, willReturn);
        }
        return this.recordVerdict(record, false, true, willReturn);
    }

    @Override
    public List<Redwood.Record> handle(Redwood.Record record) {
        ArrayList<Redwood.Record> willReturn = new ArrayList<Redwood.Record>();
        if (this.internalHandle(record, willReturn)) {
            willReturn.add(record);
        }
        return willReturn;
    }

    @Override
    public List<Redwood.Record> signalStartTrack(Redwood.Record signal) {
        ArrayList<Redwood.Record> willReturn = new ArrayList<Redwood.Record>();
        boolean isPrinting = this.internalHandle(signal, willReturn);
        if (!signal.force()) {
            RepeatedRecordInfo repeatedRecordInfo;
            if (isPrinting) {
                this.current.trackCountPending = PendingType.PRINTING;
                repeatedRecordInfo = this.current;
                repeatedRecordInfo.timesPrinted = repeatedRecordInfo.timesPrinted - 1;
            } else {
                this.current.trackCountPending = PendingType.SEEN;
            }
            repeatedRecordInfo = this.current;
            repeatedRecordInfo.timesSeen = repeatedRecordInfo.timesSeen - 1;
        }
        this.stack.push(this.current);
        this.current = new RepeatedRecordInfo();
        if (!isPrinting) {
            this.current.suppressRecord = true;
        }
        return willReturn;
    }

    @Override
    public List<Redwood.Record> signalEndTrack(int newDepth, long timeEnded) {
        ArrayList<Redwood.Record> willReturn = new ArrayList<Redwood.Record>();
        boolean trackWasNonempty = this.current.somethingPrinted;
        this.flush(this.current, willReturn);
        this.current = this.stack.pop();
        if (trackWasNonempty) {
            RepeatedRecordInfo repeatedRecordInfo;
            if (this.current.trackCountPending == PendingType.PRINTING) {
                repeatedRecordInfo = this.current;
                repeatedRecordInfo.timesPrinted = repeatedRecordInfo.timesPrinted + 1;
            }
            if (this.current.trackCountPending != PendingType.NONE) {
                repeatedRecordInfo = this.current;
                repeatedRecordInfo.timesSeen = repeatedRecordInfo.timesSeen + 1;
            }
            this.current.somethingPrinted = true;
        }
        this.current.trackCountPending = PendingType.NONE;
        return willReturn;
    }

    @Override
    public List<Redwood.Record> signalShutdown() {
        ArrayList<Redwood.Record> willReturn = new ArrayList<Redwood.Record>();
        this.flush(this.current, willReturn);
        return willReturn;
    }

    public static class ExactRepeatSemantics
    implements RepeatSemantics {
        @Override
        public boolean equals(Redwood.Record lastRecord, Redwood.Record record) {
            return Arrays.equals(record.channels(), lastRecord.channels()) && (record.content == null && lastRecord.content == null || record.content != null && record.content.equals(lastRecord.content));
        }

        @Override
        public long maxWaitTimeInMillis() {
            return Long.MAX_VALUE;
        }

        @Override
        public int numToForcePrint() {
            return 1;
        }

        @Override
        public String message(int linesOmitted) {
            return "(last message repeated " + linesOmitted + " times)";
        }
    }

    public static class ApproximateRepeatSemantics
    implements RepeatSemantics {
        private static boolean sameMessage(String last, String current) {
            String lastNoNumbers = last.replaceAll("[0-9\\.\\-]+", "#");
            String currentNoNumbers = current.replaceAll("[0-9\\.\\-]+", "#");
            return lastNoNumbers.startsWith(currentNoNumbers.substring(0, Math.min(7, currentNoNumbers.length())));
        }

        @Override
        public boolean equals(Redwood.Record lastRecord, Redwood.Record record) {
            return Arrays.equals(record.channels(), lastRecord.channels()) && ApproximateRepeatSemantics.sameMessage(lastRecord.content == null ? "null" : lastRecord.content.toString(), record.content == null ? "null" : record.content.toString());
        }

        @Override
        public long maxWaitTimeInMillis() {
            return 1000L;
        }

        @Override
        public int numToForcePrint() {
            return 3;
        }

        @Override
        public String message(int linesOmitted) {
            return "... " + linesOmitted + " similar messages";
        }
    }

    public static interface RepeatSemantics {
        public boolean equals(Redwood.Record var1, Redwood.Record var2);

        public long maxWaitTimeInMillis();

        public int numToForcePrint();

        public String message(int var1);
    }

    private static class RepeatedRecordInfo {
        private Redwood.Record lastRecord = null;
        private int timesSeen = 0;
        private int timesPrinted = 0;
        private long timeOfLastPrintedRecord = 0L;
        private boolean suppressRecord = false;
        private boolean somethingPrinted = false;
        private PendingType trackCountPending = PendingType.NONE;

        private RepeatedRecordInfo() {
        }
    }

    private static enum PendingType {
        NONE,
        PRINTING,
        SEEN;

    }
}

