/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.function.FunctionArgument;
import io.burt.jmespath.node.ExpressionReferenceNode;
import io.burt.jmespath.node.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FunctionCallNode<T>
extends Node<T> {
    private final Function implementation;
    private final List<Expression<T>> args;

    public FunctionCallNode(Adapter<T> runtime, Function implementation, List<? extends Expression<T>> args) {
        super(runtime);
        this.implementation = implementation;
        this.args = new ArrayList<Expression<T>>(args);
    }

    @Override
    public T search(T input) {
        ArrayList arguments = new ArrayList(this.args.size());
        for (Expression<T> arg : this.args) {
            if (arg instanceof ExpressionReferenceNode) {
                arguments.add(FunctionArgument.of(arg));
                continue;
            }
            arguments.add(FunctionArgument.of(arg.search(input)));
        }
        return this.implementation.call(this.runtime, arguments);
    }

    @Override
    protected String internalToString() {
        StringBuilder str = new StringBuilder();
        if (this.implementation != null) {
            str.append(this.implementation.name());
        }
        str.append(", [");
        Iterator<Expression<T>> argIterator = this.args.iterator();
        while (argIterator.hasNext()) {
            Expression<T> arg = argIterator.next();
            str.append(arg);
            if (!argIterator.hasNext()) continue;
            str.append(", ");
        }
        str.append(']');
        return str.toString();
    }

    @Override
    protected boolean internalEquals(Object o) {
        FunctionCallNode other = (FunctionCallNode)o;
        return this.implementation.name().equals(other.implementation.name()) && this.args.equals(other.args);
    }

    @Override
    protected int internalHashCode() {
        int h = 1;
        h = h * 31 + this.implementation.name().hashCode();
        for (Expression<T> node : this.args) {
            h = h * 31 + node.hashCode();
        }
        return h;
    }
}

