/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.exception;

import cn.hutool.core.util.ObjectUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.jeecg.common.api.dto.LogDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.enums.ClientTerminalTypeEnum;
import org.jeecg.common.enums.SentinelErrorInfoEnum;
import org.jeecg.common.exception.JeecgBoot401Exception;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.exception.JeecgCloudException;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.BrowserUtils;
import org.jeecg.common.util.IpUtils;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.file.FileWrite;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.base.service.BaseCommonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.data.redis.connection.PoolException;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class JeecgBootExceptionHandler {
    private static final Logger core_f_UA = LoggerFactory.getLogger(JeecgBootExceptionHandler.class);
    @Resource
    BaseCommonService core_f_BB;

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public Result<?> httpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException httpRequestMethodNotSupportedException) {
        void a;
        JeecgBootExceptionHandler jeecgBootExceptionHandler = this;
        StringBuffer a2 = new StringBuffer();
        a2.append(JeecgBootException.core_m_F("\u4e4f\u6564\u6343"));
        a2.append(a.getMethod());
        a2.append(FileWrite.core_m_F("\u8bb9\u6c78\u65f7\u6cef\uff42"));
        a2.append(JeecgBootException.core_m_F("\u6564\u6343\u4eae\u4e49"));
        String[] stringArray = a.getSupportedMethods();
        if (stringArray != null) {
            int n;
            int n2 = stringArray.length;
            int n3 = n = 0;
            while (n3 < n2) {
                String string = stringArray[n];
                a2.append(string);
                a2.append(FileWrite.core_m_F("\u304f"));
                n3 = ++n;
            }
        }
        core_f_UA.error(a2.toString(), (Throwable)a);
        jeecgBootExceptionHandler.core_m_aC((Throwable)a);
        return Result.error(405, a2.toString());
    }

    @ExceptionHandler(value={JeecgBootException.class})
    public Result<?> handleJeecgBootException(JeecgBootException jeecgBootException) {
        JeecgBootException a = jeecgBootException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)a);
        Object object = a;
        a2.core_m_aC((Throwable)object);
        return Result.error(((JeecgBootException)object).getErrCode(), a.getMessage());
    }

    @ExceptionHandler(value={PoolException.class})
    public Result<?> handlePoolException(PoolException poolException) {
        JeecgBootExceptionHandler a = poolException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)((Object)a));
        a2.core_m_aC((Throwable)((Object)a));
        return Result.error(JeecgBootException.core_m_F("\u0010.&\"1k\u8f9c\u63ee\u5f40\u5e73c"));
    }

    @ExceptionHandler(value={JeecgBoot401Exception.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Result<?> handleJeecgBoot401Exception(JeecgBoot401Exception jeecgBoot401Exception) {
        JeecgBoot401Exception a = jeecgBoot401Exception;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)a);
        a2.core_m_aC(a);
        return new Result(401, a.getMessage());
    }

    public JeecgBootExceptionHandler() {
        JeecgBootExceptionHandler a;
    }

    @ExceptionHandler(value={JeecgCloudException.class})
    public Result<?> handleJeecgCloudException(JeecgCloudException jeecgCloudException) {
        JeecgBootExceptionHandler a = jeecgCloudException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)((Object)a));
        JeecgBootExceptionHandler jeecgBootExceptionHandler = a;
        a2.core_m_aC((Throwable)((Object)jeecgBootExceptionHandler));
        return Result.error(jeecgBootExceptionHandler.getMessage());
    }

    @ExceptionHandler(value={JeecgBootBizTipException.class})
    public Result<?> handleJeecgBootBizTipException(JeecgBootBizTipException jeecgBootBizTipException) {
        JeecgBootBizTipException a = jeecgBootBizTipException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage());
        return Result.error(a.getErrCode(), a.getMessage());
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public Result<?> handlerNoFoundException(Exception exception) {
        Exception a = exception;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)a);
        a2.core_m_aC(a);
        return Result.error(404, FileWrite.core_m_F("\u8da1\u5fbe\u4e43\u5b62\u5766\uff36\u8bb9\u68fa\u67ab\u8dd5\u5fca\u6615\u5468\u6b59\u7820"));
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> handleException(Exception exception) {
        Exception a = exception;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)a);
        SentinelErrorInfoEnum sentinelErrorInfoEnum = SentinelErrorInfoEnum.getErrorByException((Throwable)a.getCause());
        if (ObjectUtil.isNotEmpty((Object)sentinelErrorInfoEnum)) {
            return Result.error(sentinelErrorInfoEnum.getError());
        }
        a2.core_m_aC(a);
        return Result.error("\u64cd\u4f5c\u5931\u8d25\uff0c" + a.getMessage());
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public Result<?> handleDataIntegrityViolationException(DataIntegrityViolationException dataIntegrityViolationException) {
        JeecgBootExceptionHandler a = dataIntegrityViolationException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)((Object)a));
        a2.core_m_aC((Throwable)((Object)a));
        return Result.error(FileWrite.core_m_F("\u625d\u8802\u654a\u6320\u5ea9\u5f4c\u5e02b\u8fe7\u5383\u4ebc\u5bc2\u654e\u6069\u4fb1\u59cc\uff20\u8f93\u53f7\u6091\u4e3a\u7ee8\u6765\u304f\u8fe7\u5383\u9764\u7a34\u966a\u5278\u303b\u5b19\u6b8f\u51cb\u5b83\u8dcb\u51c0\u9531\u5e9c\u7b07"));
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result<?> handleMaxUploadSizeExceededException(MaxUploadSizeExceededException maxUploadSizeExceededException) {
        JeecgBootExceptionHandler a = maxUploadSizeExceededException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)((Object)a));
        a2.core_m_aC((Throwable)((Object)a));
        return Result.error(JeecgBootException.core_m_F("\u65cc\u4eb4\u596c\u5c4d\u8dce\u51b8zr\u0006\u0000\u961b\u5274gb\u8bbc\u53c9\u7f62\u6254\u9606\u4f0c\u65cc\u4eb4\u8d63\u918djb"));
    }

    /*
     * WARNING - void declaration
     */
    @ExceptionHandler(value={JeecgSqlInjectionException.class})
    public Result<?> handleSQLException(Exception exception) {
        boolean bl;
        void a;
        JeecgBootExceptionHandler jeecgBootExceptionHandler = this;
        String a2 = a.getMessage().toLowerCase();
        FileWrite.core_m_F("_6N<[-N8[\"O+");
        JeecgBootException.core_m_F("7;&*6.:&.");
        boolean bl2 = bl = a2.indexOf(FileWrite.core_m_F("_6N<[-N8[\"O+")) >= 0 || a2.indexOf(JeecgBootException.core_m_F("7;&*6.:&.")) >= 0;
        if (a2 != null && bl) {
            core_f_UA.error(FileWrite.core_m_F("\u686f\u9ab6\u597f\u8d1f\uff42\u5b62\u5766i\u001fv\u6ca6\u515f\u9880\u9653\uff4fA3"), (Object)a2);
            return Result.error(JeecgBootException.core_m_F("\u6863\u9ac7\u5973\u8d6e\uff4e\u5b13\u576a\u0018\u0013\u0007\u6caa\u512e\u988c\u9622\uff43"));
        }
        jeecgBootExceptionHandler.core_m_aC((Throwable)a);
        return Result.error("\u6821\u9a8c\u5931\u8d25\uff0c\u5b58\u5728SQL\u6ce8\u5165\u98ce\u9669\uff01" + (String)a2);
    }

    @ExceptionHandler(value={UnauthorizedException.class, AuthorizationException.class})
    public Result<?> handleAuthorizationException(AuthorizationException authorizationException) {
        JeecgBootExceptionHandler a = authorizationException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)((Object)a));
        return Result.noauth(FileWrite.core_m_F("\u6c9b\u6747\u6779\u961e\uff36\u8bb9\u806e\u7cb5\u7b9b\u7448\u5462\u5248\u9177\u670d\u966a\uff4f"));
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result<?> handleDuplicateKeyException(DuplicateKeyException duplicateKeyException) {
        JeecgBootExceptionHandler a = duplicateKeyException;
        JeecgBootExceptionHandler a2 = this;
        core_f_UA.error(a.getMessage(), (Throwable)((Object)a));
        a2.core_m_aC((Throwable)((Object)a));
        return Result.error(JeecgBootException.core_m_F("\u653b\u632c\u5ed8\u4e6f\u5db9\u5b1a\u5763\u8ba7\u8bfb\u5f17"));
    }

    private /* synthetic */ void core_m_aC(Throwable throwable) {
        Object object;
        LogDTO logDTO;
        Object a = throwable;
        JeecgBootExceptionHandler a2 = this;
        LogDTO logDTO2 = logDTO = new LogDTO();
        logDTO2.setLogType(4);
        logDTO2.setLogContent(a.getClass().getName() + ":" + ((Throwable)a).getMessage());
        logDTO.setRequestParam(ExceptionUtils.getStackTrace((Throwable)a));
        a = null;
        try {
            a = SpringContextUtils.getHttpServletRequest();
        }
        catch (NullPointerException | BeansException throwable2) {
            // empty catch block
        }
        if (null != a) {
            object = a.getParameterMap();
            if (!CollectionUtils.isEmpty((Map)object)) {
                logDTO.setMethod(oConvertUtils.mapToString(a.getParameterMap()));
            }
            LogDTO logDTO3 = logDTO;
            Object object2 = a;
            logDTO3.setRequestUrl(object2.getRequestURI());
            logDTO3.setIp(IpUtils.getIpAddr((HttpServletRequest)object2));
            if (BrowserUtils.isDesktop((HttpServletRequest)a)) {
                logDTO.setClientType(ClientTerminalTypeEnum.PC.getKey());
            } else {
                logDTO.setClientType(ClientTerminalTypeEnum.APP.getKey());
            }
        }
        if ((object = (LoginUser)SecurityUtils.getSubject().getPrincipal()) != null) {
            LogDTO logDTO4 = logDTO;
            logDTO4.setUserid(((LoginUser)object).getUsername());
            logDTO4.setUsername(((LoginUser)object).getRealname());
        }
        a2.core_f_BB.addLog(logDTO);
    }
}

