/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.sqlparse.vo;

import java.util.HashSet;
import java.util.Set;
import net.sf.jsqlparser.statement.select.SelectBody;

public class SelectSqlInfo {
    private String fromTableName;
    private String fromTableAliasName;
    private SelectSqlInfo fromSubSelect;
    private Set<String> selectFields;
    private Set<String> realSelectFields;
    private boolean selectAll;
    private final String parsedSql;

    public SelectSqlInfo(String parsedSql) {
        this.parsedSql = parsedSql;
    }

    public SelectSqlInfo(SelectBody selectBody) {
        this.parsedSql = selectBody.toString();
    }

    public void addSelectField(String selectField, String realSelectField) {
        if (this.selectFields == null) {
            this.selectFields = new HashSet<String>();
        }
        if (this.realSelectFields == null) {
            this.realSelectFields = new HashSet<String>();
        }
        this.selectFields.add(selectField);
        this.realSelectFields.add(realSelectField);
    }

    public Set<String> getAllRealSelectFields() {
        HashSet<String> fields = new HashSet<String>();
        this.recursiveGetAllFields(this, fields);
        return fields;
    }

    private void recursiveGetAllFields(SelectSqlInfo sqlInfo, Set<String> fields) {
        if (!sqlInfo.isSelectAll() && sqlInfo.getRealSelectFields() != null) {
            fields.addAll(sqlInfo.getRealSelectFields());
        }
        if (sqlInfo.getFromSubSelect() != null) {
            this.recursiveGetAllFields(sqlInfo.getFromSubSelect(), fields);
        }
    }

    public String toString() {
        return "SelectSqlInfo{fromTableName='" + this.fromTableName + "', fromSubSelect=" + this.fromSubSelect + ", aliasName='" + this.fromTableAliasName + "', selectFields=" + this.selectFields + ", realSelectFields=" + this.realSelectFields + ", selectAll=" + this.selectAll + "}";
    }

    public String getFromTableName() {
        return this.fromTableName;
    }

    public String getFromTableAliasName() {
        return this.fromTableAliasName;
    }

    public SelectSqlInfo getFromSubSelect() {
        return this.fromSubSelect;
    }

    public Set<String> getSelectFields() {
        return this.selectFields;
    }

    public Set<String> getRealSelectFields() {
        return this.realSelectFields;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public String getParsedSql() {
        return this.parsedSql;
    }

    public void setFromTableName(String fromTableName) {
        this.fromTableName = fromTableName;
    }

    public void setFromTableAliasName(String fromTableAliasName) {
        this.fromTableAliasName = fromTableAliasName;
    }

    public void setFromSubSelect(SelectSqlInfo fromSubSelect) {
        this.fromSubSelect = fromSubSelect;
    }

    public void setSelectFields(Set<String> selectFields) {
        this.selectFields = selectFields;
    }

    public void setRealSelectFields(Set<String> realSelectFields) {
        this.realSelectFields = realSelectFields;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SelectSqlInfo)) {
            return false;
        }
        SelectSqlInfo other = (SelectSqlInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSelectAll() != other.isSelectAll()) {
            return false;
        }
        String this$fromTableName = this.getFromTableName();
        String other$fromTableName = other.getFromTableName();
        if (this$fromTableName == null ? other$fromTableName != null : !this$fromTableName.equals(other$fromTableName)) {
            return false;
        }
        String this$fromTableAliasName = this.getFromTableAliasName();
        String other$fromTableAliasName = other.getFromTableAliasName();
        if (this$fromTableAliasName == null ? other$fromTableAliasName != null : !this$fromTableAliasName.equals(other$fromTableAliasName)) {
            return false;
        }
        SelectSqlInfo this$fromSubSelect = this.getFromSubSelect();
        SelectSqlInfo other$fromSubSelect = other.getFromSubSelect();
        if (this$fromSubSelect == null ? other$fromSubSelect != null : !((Object)this$fromSubSelect).equals(other$fromSubSelect)) {
            return false;
        }
        Set<String> this$selectFields = this.getSelectFields();
        Set<String> other$selectFields = other.getSelectFields();
        if (this$selectFields == null ? other$selectFields != null : !((Object)this$selectFields).equals(other$selectFields)) {
            return false;
        }
        Set<String> this$realSelectFields = this.getRealSelectFields();
        Set<String> other$realSelectFields = other.getRealSelectFields();
        if (this$realSelectFields == null ? other$realSelectFields != null : !((Object)this$realSelectFields).equals(other$realSelectFields)) {
            return false;
        }
        String this$parsedSql = this.getParsedSql();
        String other$parsedSql = other.getParsedSql();
        return !(this$parsedSql == null ? other$parsedSql != null : !this$parsedSql.equals(other$parsedSql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SelectSqlInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSelectAll() ? 79 : 97);
        String $fromTableName = this.getFromTableName();
        result = result * 59 + ($fromTableName == null ? 43 : $fromTableName.hashCode());
        String $fromTableAliasName = this.getFromTableAliasName();
        result = result * 59 + ($fromTableAliasName == null ? 43 : $fromTableAliasName.hashCode());
        SelectSqlInfo $fromSubSelect = this.getFromSubSelect();
        result = result * 59 + ($fromSubSelect == null ? 43 : ((Object)$fromSubSelect).hashCode());
        Set<String> $selectFields = this.getSelectFields();
        result = result * 59 + ($selectFields == null ? 43 : ((Object)$selectFields).hashCode());
        Set<String> $realSelectFields = this.getRealSelectFields();
        result = result * 59 + ($realSelectFields == null ? 43 : ((Object)$realSelectFields).hashCode());
        String $parsedSql = this.getParsedSql();
        result = result * 59 + ($parsedSql == null ? 43 : $parsedSql.hashCode());
        return result;
    }
}

