/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis.aspect;

import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.config.mybatis.IgnoreTenant;
import org.jeecg.config.mybatis.TenantIgnoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class IgnoreTenantAspect {
    private static final Logger core_f_VA = LoggerFactory.getLogger(IgnoreTenantAspect.class);

    public IgnoreTenantAspect() {
        IgnoreTenantAspect a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Object a = proceedingJoinPoint;
        IgnoreTenantAspect a2 = this;
        try {
            Class<?> clazz = a.getTarget().getClass();
            IgnoreTenant ignoreTenant = clazz.getAnnotation(IgnoreTenant.class);
            IgnoreTenant ignoreTenant2 = ((MethodSignature)a.getSignature()).getMethod().getAnnotation(IgnoreTenant.class);
            boolean bl = AnnotationUtils.isAnnotationDeclaredLocally(IgnoreTenant.class, clazz);
            boolean bl2 = Objects.nonNull(ignoreTenant2);
            if (bl) {
                TenantIgnoreContext.set(ignoreTenant.isIgnore());
            }
            if (bl2) {
                TenantIgnoreContext.set(ignoreTenant2.isIgnore());
            }
            a = a.proceed();
            return a;
        }
        finally {
            TenantIgnoreContext.clear();
        }
    }

    @Pointcut(value="@within(org.jeecg.config.mybatis.IgnoreTenant) ||@annotation(org.jeecg.config.mybatis.IgnoreTenant)")
    public void pointcut() {
    }
}

