/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.sign.interceptor;

import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.SortedMap;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.sign.util.BodyReaderHttpServletRequestWrapper;
import org.jeecg.config.sign.util.HttpUtils;
import org.jeecg.config.sign.util.SignUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class SignAuthInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SignAuthInterceptor.class);
    private static final long MAX_EXPIRE = 300L;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean isSigned;
        log.info("Sign Interceptor request URI = " + request.getRequestURI());
        BodyReaderHttpServletRequestWrapper requestWrapper = new BodyReaderHttpServletRequestWrapper(request);
        SortedMap<String, String> allParams = HttpUtils.getAllParams((HttpServletRequest)requestWrapper);
        String headerSign = request.getHeader("X-Sign");
        String xTimestamp = request.getHeader("X-TIMESTAMP");
        if (oConvertUtils.isEmpty(xTimestamp)) {
            Result result = Result.error("Sign\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff0c\u65f6\u95f4\u6233\u4e3a\u7a7a\uff01");
            log.error("Sign \u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01Header xTimestamp \u4e3a\u7a7a");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            PrintWriter out = response.getWriter();
            out.print(JSON.toJSON(result));
            return false;
        }
        Long clientTimestamp = Long.parseLong(xTimestamp);
        int length = 14;
        int length1000 = 1000;
        if (xTimestamp.length() == length) {
            if (Math.abs(DateUtils.getCurrentTimestamp() - clientTimestamp) > 300L) {
                log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f\uff0c\u6ce8\u610f\u7cfb\u7edf\u65f6\u95f4\u548c\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u6709\u8bef\u5dee\uff01");
                throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
            }
        } else if (Math.abs(System.currentTimeMillis() - clientTimestamp) > 300L * (long)length1000) {
            log.error("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f\uff0c\u6ce8\u610f\u7cfb\u7edf\u65f6\u95f4\u548c\u670d\u52a1\u5668\u65f6\u95f4\u662f\u5426\u6709\u8bef\u5dee\uff01");
            throw new IllegalArgumentException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25:X-TIMESTAMP\u5df2\u8fc7\u671f");
        }
        if (isSigned = SignUtil.verifySign(allParams, headerSign)) {
            log.debug("Sign \u7b7e\u540d\u901a\u8fc7\uff01Header Sign : {}", (Object)headerSign);
            return true;
        }
        log.info("sign allParams: {}", allParams);
        log.error("request URI = " + request.getRequestURI());
        log.error("Sign \u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01Header Sign : {}", (Object)headerSign);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        Result result = Result.error("Sign\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01");
        out.print(JSON.toJSON(result));
        return false;
    }
}

