/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.annotations.aspect;

import cn.hutool.core.util.StrUtil;
import jakarta.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.enhancements.annotations.AddBindingData;
import org.jeecg.enhancements.modules.general.service.ISysGeneralService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Aspect
@Component
public class AddBindingDataAspect {
    @Resource
    private ISysGeneralService sysGeneralService;

    @Transactional
    @Around(value="@annotation(addBindingData)")
    public Object aroundMethodExecution(ProceedingJoinPoint joinPoint, AddBindingData addBindingData) throws Throwable {
        String value = addBindingData.value();
        String configName = addBindingData.configName();
        String entityName = addBindingData.entityName();
        if (configName.isEmpty()) {
            configName = value;
        }
        if (entityName.isEmpty()) {
            entityName = value;
        }
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] parameterNames = methodSignature.getParameterNames();
        int entityNameIndex = -1;
        for (int i = 0; i < parameterNames.length; ++i) {
            if (!parameterNames[i].equals(StrUtil.toCamelCase((CharSequence)entityName))) continue;
            entityNameIndex = i;
            break;
        }
        if (entityNameIndex == -1) {
            throw new JeecgBootException("Method parameter " + entityName + " not found");
        }
        Object[] args = joinPoint.getArgs();
        Object entity = args[entityNameIndex];
        Object returnValue = joinPoint.proceed();
        this.sysGeneralService.setNewBinding(configName, entity);
        return returnValue;
    }
}

