/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.annotations.aspect;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Resource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoDict;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.enhancements.modules.dict.IDictService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DictAspect {
    private static final Logger log = LoggerFactory.getLogger(DictAspect.class);
    @Lazy
    @Autowired
    private CommonAPI commonApi;
    @Autowired
    public RedisTemplate redisTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Resource
    private IDictService dictService;
    private static final String JAVA_UTIL_DATE = "java.util.Date";

    @Pointcut(value="execution(public * org.jeecg.modules..*.*Controller.*(..)) || @annotation(org.jeecg.common.aspect.annotation.AutoDict)")
    public void executeService() {
    }

    @Around(value="executeService()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        AutoDict autoDict = method.getAnnotation(AutoDict.class);
        boolean stringValue = false;
        boolean autoDictFlag = false;
        if (autoDict != null) {
            stringValue = autoDict.stringValue();
            autoDictFlag = true;
        }
        long time1 = System.currentTimeMillis();
        Object result = pjp.proceed();
        long time2 = System.currentTimeMillis();
        log.debug("\u83b7\u53d6JSON\u6570\u636e \u8017\u65f6\uff1a" + (time2 - time1) + "ms");
        long start = System.currentTimeMillis();
        result = this.parseDictText(result, stringValue, autoDictFlag);
        long end = System.currentTimeMillis();
        log.debug("\u6ce8\u5165\u5b57\u5178\u5230JSON\u6570\u636e  \u8017\u65f6" + (end - start) + "ms");
        return result;
    }

    private Object parseDictText(Object result, boolean stringValue, boolean autoDictFlag) {
        Object listData;
        if (result instanceof Result) {
            if (((Result)result).getResult() instanceof IPage) {
                this.handleParse((IPage)((Result)result).getResult(), stringValue);
            } else if (((Result)result).getResult() instanceof List) {
                List listRes = (List)((Result)result).getResult();
                boolean isDashboardView = false;
                for (Object obj : listRes) {
                    Map map;
                    Object pageData;
                    if (!(obj instanceof Map) || !((pageData = (map = (Map)obj).get("pageData")) instanceof IPage)) continue;
                    this.handleParse((IPage)pageData, stringValue);
                    Object groupField = map.get("groupField");
                    IPage pageDataReal = (IPage)pageData;
                    List records = pageDataReal.getRecords();
                    if (records != null && records.size() > 0) {
                        JSONObject jsonObject = (JSONObject)records.get(0);
                        map.put("title_dictText", jsonObject.get((Object)(groupField + "_dictText")));
                    }
                    isDashboardView = true;
                    break;
                }
                if (!isDashboardView) {
                    this.handleParse(listRes, stringValue);
                }
            } else if (((Result)result).getResult() instanceof Map) {
                Map map = (Map)((Result)result).getResult();
                Object pageData = map.get("pageData");
                if (pageData instanceof IPage) {
                    this.handleParse((IPage)pageData, stringValue);
                    return result;
                }
                Object listData2 = map.get("listData");
                if (listData2 instanceof List) {
                    this.handleParse((List)listData2, stringValue);
                    return result;
                }
            } else if (autoDictFlag) {
                Object data = ((Result)result).getResult();
                Object translatedData = this.handleParseObj(data, stringValue);
                if (translatedData != null) {
                    ((Result)result).setResult(translatedData);
                }
                return result;
            }
        } else if (result instanceof Map && (listData = ((Map)result).get("data")) instanceof List) {
            this.handleParse((List)listData, stringValue);
            return result;
        }
        return result;
    }

    private void handleParse(IPage result, boolean stringValue) {
        Object firstElement;
        List records = result.getRecords();
        if (oConvertUtils.listIsNotEmpty(records) && !Map.class.isAssignableFrom((firstElement = records.get(0)).getClass())) {
            List<?> filledDataList = this.dictService.fillDataWithDict(records, stringValue);
            result.setRecords(filledDataList);
        }
    }

    private void handleParse(List<?> dataList, boolean stringValue) {
        Object firstElement;
        if (oConvertUtils.listIsNotEmpty(dataList) && !Map.class.isAssignableFrom((firstElement = dataList.get(0)).getClass())) {
            List<?> filledDataList = this.dictService.fillDataWithDict(dataList, stringValue);
            ArrayList newDataList = new ArrayList(filledDataList);
            dataList.clear();
            dataList.addAll(newDataList);
        }
    }

    private <T> T handleParseObj(final T data, boolean stringValue) {
        if (oConvertUtils.isNotEmpty(data)) {
            ArrayList tempDataList = new ArrayList<T>(){
                {
                    this.add(data);
                }
            };
            this.handleParse(tempDataList, stringValue);
            return (T)tempDataList.get(0);
        }
        return data;
    }
}

