/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.annotations.aspect;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import jakarta.annotation.Resource;
import java.util.Map;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.jeecg.common.api.vo.Result;
import org.jeecg.enhancements.annotations.QueryBindingData;
import org.jeecg.enhancements.modules.general.service.ISysGeneralService;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class QueryBindingDataAspect {
    @Resource
    private ISysGeneralService sysGeneralService;

    @Pointcut(value="@annotation(queryBindingData)")
    public void queryBindingDataPointcut(QueryBindingData queryBindingData) {
    }

    @AfterReturning(pointcut="queryBindingDataPointcut(queryBindingData)", returning="result", argNames="queryBindingData,result")
    public Object afterReturning(QueryBindingData queryBindingData, Object result) throws ClassNotFoundException {
        String value = queryBindingData.value();
        String configName = queryBindingData.configName();
        if (StrUtil.isEmpty((CharSequence)configName)) {
            configName = value;
        }
        System.out.println("Original return value: " + result);
        if (result instanceof Result) {
            Result resultVo = (Result)result;
            IPage pageData = (IPage)resultVo.getResult();
            Map<String, Object> joinResultMap = this.sysGeneralService.queryDataList(configName, pageData.getRecords());
            resultVo.setResult(Map.of("pageData", pageData, "joinResultMap", joinResultMap));
        }
        return result;
    }
}

