/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.models.base;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SseEmitterUTF8;
import org.jeecg.common.util.async.AsyncTaskUtil;
import org.jeecg.common.util.file.FileDelete;
import org.jeecg.enhancements.modules.business.service.ISysBusinessExportService;
import org.jeecg.enhancements.modules.business.service.ISysBusinessImportService;
import org.jeecg.enhancements.modules.sys_export_task.dto.ExportCacheDto;
import org.jeecg.enhancements.modules.sys_export_task.sse.ExportSseServer;
import org.jeecg.enhancements.modules.sys_export_task.style.MgDefaultStyler;
import org.jeecg.enhancements.utils.ExportCacheUtils;
import org.jeecg.enhancements.utils.ImageMergeUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.enmus.ExcelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.WebUtils;

public interface IMgBaseControllerExport<T, S extends IService<T>> {
    public static final int maxPayloadLength = 0x200000;
    public static final Logger log = LoggerFactory.getLogger(IMgBaseControllerExport.class);

    public S getService();

    public ExportCacheUtils getExportCacheUtils();

    public ISysBusinessImportService getBusinessImportService();

    public ISysBusinessExportService getBusinessExportService();

    public ExportSseServer getExportSseServer();

    public String getUploadPath();

    public String getUploadType();

    public int getExportPageSize();

    public int[] getProgress();

    public static Map<String, String[]> getParamMap(HttpServletRequest request) {
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        if ("POST".equals(request.getMethod())) {
            String postData = "";
            String exportParam = IMgBaseControllerExport.getRequestPayload(request);
            if (exportParam != null) {
                postData = exportParam.toString();
            }
            if (StringUtils.isNotEmpty((String)postData)) {
                Map map = (Map)JSONUtil.toBean((String)postData, Map.class);
                Set set = map.keySet();
                for (Object item : set) {
                    String[] strings = new String[]{map.get(item) == null ? null : map.get(item).toString()};
                    paramMap.put("" + item, strings);
                }
            }
            if (!paramMap.containsKey("customSettingColumns")) {
                paramMap.put("customSettingColumns", new String[]{request.getParameter("customSettingColumns")});
            }
            if (!paramMap.containsKey("fileName")) {
                paramMap.put("fileName", new String[]{request.getParameter("fileName")});
            }
            if (!paramMap.containsKey("selections")) {
                paramMap.put("selections", new String[]{request.getParameter("selections")});
            }
            if (!paramMap.containsKey("order")) {
                paramMap.put("order", new String[]{request.getParameter("order")});
            }
            if (!paramMap.containsKey("column")) {
                paramMap.put("column", new String[]{request.getParameter("column")});
            }
        } else {
            paramMap.putAll(request.getParameterMap());
        }
        paramMap.put("order", paramMap.getOrDefault("order", new String[]{"desc"}));
        paramMap.put("column", paramMap.getOrDefault("column", new String[]{"update_time"}));
        return paramMap;
    }

    public static <T> QueryWrapper<T> createQueryWrapper(T object, Map<String, Object> body) {
        HashMap<String, String[]> paramsMap = new HashMap<String, String[]>();
        for (String key : body.keySet()) {
            paramsMap.put(key, new String[]{body.get(key).toString()});
        }
        QueryWrapper<T> qw = QueryGenerator.initQueryWrapper(object, paramsMap);
        IMgBaseControllerExport.resetQueryWrapper(qw, body);
        return qw;
    }

    default public ExportCacheDto export(String sign, String type, String module, Map<String, Object> body, Consumer<String> fun) {
        ExportCacheUtils cache = this.getExportCacheUtils();
        if (cache.get(sign) != null) {
            return cache.get(sign);
        }
        if (fun != null) {
            ExportCacheDto dto = cache.create(sign, type, module, body);
            AsyncTaskUtil.asyncTask(() -> {
                try {
                    this.getExportCacheUtils().saveUserStatus(this.getClass().getName(), sign);
                    fun.accept(sign);
                    cache.setProgress(sign, 100.0);
                    cache.del(sign, "\u5df2\u5b8c\u6210");
                    cache.delUserStatus(this.getClass().getName());
                }
                catch (Exception e) {
                    this.getExportCacheUtils().delUserStatus(this.getClass().getName());
                    this.getExportCacheUtils().saveUserError(this.getClass().getName(), e.getMessage());
                    this.getExportSseServer().sendData(sign, "error", e.getMessage());
                    cache.del(sign, "\u5df2\u5931\u8d25");
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            return dto;
        }
        return null;
    }

    default public List<?> loadData(String sign, QueryWrapper<T> queryWrapper) {
        long dataSize = this.getService().count(queryWrapper);
        this.p_initPageSize(sign, dataSize);
        this.getExportCacheUtils().setDataSize(sign, dataSize);
        this.setProgress(sign, 3, true);
        List<?> pageList = new ArrayList();
        int i = 1;
        while ((long)((i - 1) * this.getExportPageSize()) < dataSize) {
            Page page = new Page((long)i, (long)this.getExportPageSize());
            Page pList = (Page)this.getService().page((IPage)page, queryWrapper);
            List<?> data = this.exportDataPageLoaded(pList);
            if (data != null && data.size() > 0) {
                pageList.addAll(data);
            }
            if ((long)this.getExportPageSize() <= dataSize) {
                float nsize = Float.valueOf(i).floatValue() * (float)this.getExportPageSize() / (float)dataSize;
                this.getExportCacheUtils().setProgress(sign, this.getProgress()[3] + Math.round(nsize * (float)(this.getProgress()[5] - this.getProgress()[3])));
            }
            ++i;
        }
        pageList = this.exportDataListLoaded(pageList);
        return pageList;
    }

    default public void exportOut(String sign, List<?> pageList, Class<?> clazz, ExportParams exportParams, String[] exportArr) throws IOException {
        OutputStream out = this.getExportCacheUtils().saveFileGetOut(sign);
        Workbook sheets = ExcelExportUtil.exportExcel((ExportParams)exportParams, clazz, pageList, (String[])exportArr);
        this.p_waitOut(sign, out);
        sheets.write(out);
        this.getExportCacheUtils().saveOver(sign, out);
    }

    public String params2MD5(Map<String, Object> var1);

    public static <T> QueryWrapper<T> resetQueryWrapper(QueryWrapper<T> queryWrapper, Map<String, Object> body) {
        String selections = (String)body.get("selections");
        String column = (String)body.get("column");
        String order = (String)body.get("order");
        if (!ObjectUtils.isEmpty((Object)selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            String[] columnArray = column.split(",");
            List<String> columnList = Arrays.stream(columnArray).map(CharSequenceUtil::toUnderlineCase).toList();
            queryWrapper.clear();
            queryWrapper.orderBy(true, "asc".equals(order), columnList);
            queryWrapper.in((Object)"id", selectionList);
        }
        return queryWrapper;
    }

    public static String getRequestPayload(HttpServletRequest request) {
        String payload = "";
        ContentCachingRequestWrapper wrapper = (ContentCachingRequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, ContentCachingRequestWrapper.class);
        if (wrapper != null) {
            byte[] buf = wrapper.getContentAsByteArray();
            payload = IMgBaseControllerExport.getPayloadFromBuf(buf, "utf-8");
        }
        return payload;
    }

    public static String getPayloadFromBuf(byte[] buf, String characterEncoding) {
        String payload = "";
        if (buf.length > 0) {
            int length = Math.min(buf.length, 0x200000);
            try {
                payload = new String(buf, 0, length, characterEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return payload;
    }

    default public void returnMessage(HttpServletResponse response, Object msg) {
        response.setHeader("fileType", "message");
        response.setHeader("Content-type", "application/json; charset=UTF-8");
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String json = objectMapper.writeValueAsString(msg);
            response.getWriter().write(json);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    default public void p_initPageSize(String sign, long dataSize) {
    }

    default public List<?> exportDataPageLoaded(Page<T> page) {
        return page.getRecords();
    }

    default public List<?> exportDataListLoaded(List<?> allList) {
        return allList;
    }

    default public void p_waitOut(String sign, OutputStream out) {
    }

    private List<?> getImportExportConfigById(String configId, Boolean isImportTemplate) {
        if (isImportTemplate.booleanValue()) {
            return this.getBusinessImportService().getImportConfigByConfigId(configId);
        }
        return this.getBusinessExportService().getExportConfigByConfigId(configId);
    }

    private String[] getExportFieldName(List<?> importExportConfigs, String customSettingColumns, Class<?> clazz) {
        return (String[])importExportConfigs.stream().map(item -> (String)BeanUtil.getProperty((Object)item, (String)"fieldName")).toArray(String[]::new);
    }

    default public ExportParams createExportParams(boolean isInTemplate, String title, String type) {
        ExportParams exportParams = null;
        if (isInTemplate) {
            exportParams = new ExportParams(title, "\u5bfc\u5165\u6a21\u7248", title);
        } else {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            exportParams = new ExportParams(title, "\u5bfc\u51fa\u4eba:" + sysUser.getRealname(), title);
        }
        exportParams.setImageBasePath(this.getUploadPath());
        exportParams.setHeaderColor((short)22);
        exportParams.setColor((short)22);
        exportParams.setStyle(MgDefaultStyler.class);
        if (type != null && "xls".equals(type)) {
            exportParams.setType(ExcelType.HSSF);
        } else {
            exportParams.setType(ExcelType.XSSF);
        }
        return exportParams;
    }

    public Class<?> configClassExcel(Class<?> var1, List<?> var2, boolean var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<String> changeExportImg(List<T> exportList, Class tClass, String[] exportArr, String sign) {
        ArrayList<String> needRemoveurl = new ArrayList<String>();
        try {
            Field[] fields;
            Set collect = Arrays.stream(exportArr).collect(Collectors.toSet());
            ArrayList<String> images = new ArrayList<String>();
            for (Field field : fields = tClass.getDeclaredFields()) {
                String name;
                int type;
                Excel excelAn = field.getAnnotation(Excel.class);
                if (excelAn == null || (type = excelAn.type()) != 2 || !collect.contains(name = field.getName())) continue;
                images.add(name);
            }
            int allSize = images.size() * exportList.size();
            CountDownLatch latch = new CountDownLatch(allSize);
            AtomicInteger i = new AtomicInteger();
            new Thread(() -> {
                try {
                    images.forEach(fieldName -> exportList.forEach(item -> {
                        i.getAndIncrement();
                        Class<?> clazz = item.getClass();
                        try {
                            Field field = clazz.getDeclaredField((String)fieldName);
                            field.setAccessible(true);
                            if (field.get(item) != null) {
                                ImageMergeUtils imageMergeUtils = new ImageMergeUtils();
                                imageMergeUtils.setUploadpath(this.getUploadPath());
                                imageMergeUtils.setUploadType(this.getUploadType());
                                String exportImgUrl = imageMergeUtils.getExportImgUrl(field.get(item).toString(), this.getUploadPath() + File.separator + "exportImag" + File.separator, this.getUploadType());
                                field.set(item, exportImgUrl);
                                if (exportImgUrl.contains("new")) {
                                    needRemoveurl.add(exportImgUrl);
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (StringUtils.isNotEmpty((String)sign)) {
                            float percent = i.floatValue() / (float)allSize;
                            this.getExportCacheUtils().setProgress(sign, (float)this.getProgress()[7] + percent * (float)(this.getProgress()[8] - this.getProgress()[7]));
                        }
                        latch.countDown();
                    }));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, "\u56fe\u7247\u7ebf\u7a0b\u3010" + UUID.randomUUID() + "\u3011").start();
            latch.await();
            ArrayList<String> arrayList = needRemoveurl;
            return arrayList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            return needRemoveurl;
        }
    }

    private void setProgress(String sign, int index, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                int progress = this.getProgress()[index];
                this.getExportCacheUtils().setProgress(sign, progress);
            }, (boolean)false);
        } else {
            int progress = this.getProgress()[index];
            this.getExportCacheUtils().setProgress(sign, progress);
        }
    }

    default public void exportXlsAsync(String sign, Map<String, Object> body, QueryWrapper<T> qw, Class<?> clazz, String title) throws IOException {
        sign = ObjectUtils.isEmpty((Object)sign) ? this.params2MD5(body) : sign;
        String type = body.containsKey("type") ? (String)body.get("type") : "xlsx";
        String fileName = (String)body.get("fileName");
        String customSettingColumns = (String)body.get("customSettingColumns");
        String configId = (String)body.get("configId");
        this.setProgress(sign, 2, true);
        List<?> dataList = this.loadData(sign, qw);
        this.setProgress(sign, 5, true);
        List<?> importExportConfigs = this.getImportExportConfigById(configId, false);
        this.setProgress(sign, 6, true);
        String[] exportArr = this.getExportFieldName(importExportConfigs, customSettingColumns, clazz);
        ExportParams exportParams = this.createExportParams(false, title, type);
        Class<?> clazz2 = this.configClassExcel(clazz, importExportConfigs, false);
        this.setProgress(sign, 7, true);
        List<String> images = this.changeExportImg(dataList, clazz2, exportArr, sign);
        this.setProgress(sign, 8, false);
        this.exportOut(sign, dataList, clazz2, exportParams, exportArr);
        this.setProgress(sign, 9, false);
        FileDelete.delete(images, this.getUploadPath());
    }

    default public void exportXlsTemplate(Map<String, Object> body, QueryWrapper<T> qw, Class<?> clazz, String title, HttpServletResponse response) {
        String configId = (String)body.get("configId");
        List dataList = this.getService().list(qw);
        List<?> importExportConfigs = this.getImportExportConfigById(configId, true);
        String[] exportArr = this.getExportFieldName(importExportConfigs, null, clazz);
        ExportParams exportParams = this.createExportParams(true, title, "xlsx");
        Class<?> clazz2 = this.configClassExcel(clazz, importExportConfigs, true);
        List<String> images = this.changeExportImg(dataList, clazz2, exportArr, null);
        try {
            response.setContentType("application/xlsx;charset=utf-8");
            String codedFileName = new String((title + "\u5bfc\u51fa\u6a21\u677f.xlsx").getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1);
            response.setHeader("content-disposition", "attachment;filename=" + codedFileName);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, clazz2, (Collection)dataList, (String[])exportArr);
            ServletOutputStream out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            FileDelete.delete(images, this.getUploadPath());
        }
    }

    @GetMapping(value={"/exportXls/subscribe"})
    default public SseEmitterUTF8 subscribe(@RequestParam String sign) {
        return this.getExportSseServer().getConnection(sign);
    }
}

