/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.models.base;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.service.IService;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.SseEmitterUTF8;
import org.jeecg.common.util.async.AsyncTaskUtil;
import org.jeecg.enhancements.modules.business.service.ISysBusinessExportService;
import org.jeecg.enhancements.modules.business.service.ISysBusinessImportService;
import org.jeecg.enhancements.modules.business.vo.SysBusinessImportDetailVo;
import org.jeecg.enhancements.modules.sys_import_task.dto.ImportCacheDto;
import org.jeecg.enhancements.modules.sys_import_task.sse.ImportSseServer;
import org.jeecg.enhancements.utils.ImportCacheUtils;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public interface IMgBaseControllerImport<T, S extends IService<T>> {
    public static final Logger log = LoggerFactory.getLogger(IMgBaseControllerImport.class);

    public S getService();

    public ImportCacheUtils getImportCacheUtils();

    public ImportSseServer getImportSseServer();

    public Class<?> configClassExcel(Class<?> var1, List<?> var2, boolean var3);

    public ISysBusinessImportService getBusinessImportService();

    public ISysBusinessExportService getBusinessExportService();

    public int[] getProgress();

    public String getUploadPath();

    public String getUploadType();

    default public List<Integer> presetDataValidate(List<T> dataList, List<SysBusinessImportDetailVo> importDetailConfigs) {
        ArrayList<Integer> errorIndexList = new ArrayList<Integer>();
        Map<String, SysBusinessImportDetailVo> importDetailConfigMap = importDetailConfigs.stream().collect(Collectors.toMap(SysBusinessImportDetailVo::getFieldName, a -> a));
        block2: for (int i = 0; i < dataList.size(); ++i) {
            Field[] fields;
            T dataEntity = dataList.get(i);
            for (Field field : fields = dataEntity.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                SysBusinessImportDetailVo importDetailConfig = importDetailConfigMap.get(fieldName);
                if (importDetailConfig == null || !"1".equals(importDetailConfig.getImporting())) continue;
                String presetValue = importDetailConfig.getPresetValue();
                String nullable = importDetailConfig.getNullable();
                try {
                    Object value = field.get(dataEntity);
                    if (value != null && !"".equals(value) || !"0".equals(nullable)) continue;
                    if (StrUtil.isNotEmpty((CharSequence)presetValue)) {
                        if (field.getType().equals(Integer.class)) {
                            field.set(dataEntity, Integer.valueOf(presetValue));
                            continue;
                        }
                        if (field.getType().equals(Double.class)) {
                            field.set(dataEntity, Double.valueOf(presetValue));
                            continue;
                        }
                        if (field.getType().equals(Float.class)) {
                            field.set(dataEntity, Float.valueOf(presetValue));
                            continue;
                        }
                        if (field.getType().equals(Long.class)) {
                            field.set(dataEntity, Long.valueOf(presetValue));
                            continue;
                        }
                        field.set(dataEntity, presetValue);
                        continue;
                    }
                    errorIndexList.add(i + 4);
                    continue block2;
                }
                catch (IllegalAccessException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return errorIndexList;
    }

    public String params2MD5(Map<String, Object> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Result<?> importExcelSync(HttpServletRequest request, Class<T> clazz, String configId) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        List<SysBusinessImportDetailVo> importDetailConfigs = this.getBusinessImportService().getImportDetailConfigByConfigId(configId);
        Class<SysBusinessImportDetailVo> clazz2 = this.configClassExcel(clazz, importDetailConfigs, true);
        Map fileMap = multipartRequest.getFileMap();
        Iterator iterator = fileMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entity = iterator.next();
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List dataList = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), clazz2, (ImportParams)params);
                if (dataList == null || dataList.isEmpty()) {
                    Result result = Result.error("\u672a\u83b7\u53d6\u5230\u5bfc\u5165\u6570\u636e\uff01");
                    return result;
                }
                List<Integer> errorIndexList = this.presetDataValidate(dataList, importDetailConfigs);
                String errorIndexString = errorIndexList.stream().map(String::valueOf).collect(Collectors.joining(","));
                if (!errorIndexList.isEmpty()) {
                    Result result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:\u7b2c" + errorIndexString + "\u884c\u6570\u636e\u5fc5\u586b\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
                    return result;
                }
                long start = System.currentTimeMillis();
                this.getService().saveBatch((Collection)dataList);
                log.info("\u6d88\u8017\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
                Result<CallSite> result = Result.ok("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01\u6570\u636e\u884c\u6570\uff1a" + dataList.size());
                return result;
            }
            catch (Exception e) {
                Result result;
                String msg = e.getMessage();
                log.error(msg, (Throwable)e);
                if (msg != null && msg.indexOf("Duplicate entry") >= 0) {
                    result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:\u6709\u91cd\u590d\u6570\u636e\uff01");
                    return result;
                }
                result = Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return Result.error("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
    }

    @Transactional
    default public void importExcelAsync(String sign, Map<String, Object> body, Map<String, String> filePathMap, Class<T> clazz) {
        sign = ObjectUtils.isEmpty((Object)sign) ? this.params2MD5(body) : sign;
        String configId = (String)body.get("configId");
        this.setProgress(sign, 1, true);
        List<SysBusinessImportDetailVo> importDetailConfigs = this.getBusinessImportService().getImportDetailConfigByConfigId(configId);
        this.setProgress(sign, 2, true);
        Class<SysBusinessImportDetailVo> clazz2 = this.configClassExcel(clazz, importDetailConfigs, true);
        this.setProgress(sign, 3, true);
        for (Map.Entry<String, String> entity : filePathMap.entrySet()) {
            FileInputStream fis = null;
            try {
                String filePath = entity.getValue();
                String absolutePath = Paths.get(this.getUploadPath(), filePath).toAbsolutePath().toString();
                File file = new File(absolutePath);
                fis = new FileInputStream(file);
                ImportParams params = new ImportParams();
                params.setTitleRows(2);
                params.setHeadRows(1);
                params.setNeedSave(true);
                List<T> dataList = ExcelImportUtil.importExcel((InputStream)fis, clazz2, (ImportParams)params);
                for (Object t : dataList) {
                    body.forEach((key, value) -> {
                        try {
                            if (!key.equals("sign") && !key.equals("configId")) {
                                BeanUtil.setFieldValue((Object)t, (String)key, (Object)value);
                            }
                        }
                        catch (Exception e) {
                            log.warn("\u5bfc\u5165\u5b9e\u4f53\u672a\u627e\u5230\u5b57\u6bb5,\u8df3\u8fc7\u8bbe\u7f6e{}\u5b57\u6bb5\u7684\u9ed8\u8ba4\u503c", key);
                        }
                    });
                }
                if (dataList == null || dataList.isEmpty()) {
                    throw new JeecgBootException("\u672a\u83b7\u53d6\u5230\u5bfc\u5165\u6570\u636e\uff01");
                }
                this.getImportCacheUtils().setDataSize(sign, dataList.size());
                this.setProgress(sign, 4, true);
                List<Integer> errorIndexList = this.presetDataValidate(dataList, importDetailConfigs);
                String errorIndexString = errorIndexList.stream().map(String::valueOf).collect(Collectors.joining(","));
                if (!errorIndexList.isEmpty()) {
                    throw new JeecgBootException("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:\u7b2c" + errorIndexString + "\u884c\u6570\u636e\u5fc5\u586b\u6821\u9a8c\u672a\u901a\u8fc7\uff01");
                }
                this.setProgress(sign, 5, true);
                long start = System.currentTimeMillis();
                dataList = this.importDataListLoaded(dataList);
                this.getService().saveBatch(dataList);
                this.importDataListSaved(dataList);
                log.info("\u6d88\u8017\u65f6\u95f4" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
                this.setProgress(sign, 8, true);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                log.error(msg, (Throwable)e);
                if (msg != null && msg.indexOf("Duplicate entry") >= 0) {
                    throw new JeecgBootException("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:\u6709\u91cd\u590d\u6570\u636e\uff01");
                }
                throw new JeecgBootException("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setProgress(sign, 9, true);
    }

    default public List<T> importDataListLoaded(List<T> oriDataList) {
        return oriDataList;
    }

    default public void importDataListSaved(List<T> oriDataList) {
    }

    private void setProgress(String sign, int index, boolean isAsync) {
        if (isAsync) {
            ThreadUtil.execAsync(() -> {
                int progress = this.getProgress()[index];
                this.getImportCacheUtils().setProgress(sign, progress);
            }, (boolean)false);
        } else {
            int progress = this.getProgress()[index];
            this.getImportCacheUtils().setProgress(sign, progress);
        }
    }

    default public ImportCacheDto getImportDto(String sign, Consumer<String> fun) {
        ImportCacheUtils cache = this.getImportCacheUtils();
        if (fun != null) {
            ImportCacheDto dto = cache.get(sign);
            AsyncTaskUtil.asyncTask(() -> {
                try {
                    this.getImportCacheUtils().saveUserStatus(this.getClass().getName(), sign);
                    fun.accept(sign);
                    cache.setProgress(sign, 100.0);
                    cache.del(sign, "\u5df2\u5b8c\u6210");
                    cache.delUserStatus(this.getClass().getName());
                }
                catch (Exception e) {
                    this.getImportCacheUtils().delUserStatus(this.getClass().getName());
                    this.getImportCacheUtils().saveUserError(this.getClass().getName(), e.getMessage());
                    this.getImportSseServer().sendData(sign, "error", e.getMessage());
                    cache.del(sign, "\u5df2\u5931\u8d25");
                    log.error(e.getMessage(), (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
            return dto;
        }
        return null;
    }

    @GetMapping(value={"/importExcel/subscribe"})
    default public SseEmitterUTF8 importExcelSubscribe(@RequestParam String sign) {
        return this.getImportSseServer().getConnection(sign);
    }
}

