/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.enhancements.models.base;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.enums.MgViewTypeEnum;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.log.Base;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SseEmitterUTF8;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.enhancements.models.base.IMgBaseControllerExport;
import org.jeecg.enhancements.models.base.IMgBaseControllerImport;
import org.jeecg.enhancements.modules.business.service.ISysBusinessExportService;
import org.jeecg.enhancements.modules.business.service.ISysBusinessImportService;
import org.jeecg.enhancements.modules.sys_export_task.dto.ExportCacheDto;
import org.jeecg.enhancements.modules.sys_export_task.entity.SysExportTask;
import org.jeecg.enhancements.modules.sys_export_task.sse.ExportSseServer;
import org.jeecg.enhancements.modules.sys_import_task.dto.ImportCacheDto;
import org.jeecg.enhancements.modules.sys_import_task.entity.SysImportTask;
import org.jeecg.enhancements.modules.sys_import_task.sse.ImportSseServer;
import org.jeecg.enhancements.utils.ExportCacheUtils;
import org.jeecg.enhancements.utils.ImportCacheUtils;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class MgBaseController<T, S extends IService<T>>
extends JeecgController<T, S>
implements IMgBaseControllerExport<T, S>,
IMgBaseControllerImport<T, S> {
    private static final Logger log = LoggerFactory.getLogger(MgBaseController.class);
    private static final String VIEW_TYPE_MG = "viewType_mg";
    private static final String VIEW_TYPE_MAP_MG = "viewTypeMap_mg";
    private static final String CALENDAR_MAX_SUM = "maxSum";
    private static final String DASHBOARD_GROUP_FIELD = "groupField";
    private static final String DASHBOARD_GROUP_FIELD_VALUE = "groupFieldValue";
    @Autowired
    S service;
    @Resource
    ExportCacheUtils exportCacheUtils;
    @Resource
    ImportCacheUtils importCacheUtils;
    @Resource
    private ISysBusinessImportService businessImportService;
    @Resource
    private ISysBusinessExportService businessExportService;
    @Resource
    private ExportSseServer exportSseServer;
    @Resource
    private ImportSseServer importSseServer;
    @Value(value="${jeecg.path.upload}")
    private String uploadPath;
    @Value(value="${jeecg.uploadType}")
    private String uploadType;
    public static final int PAGE_SIZE = 1000;
    public static final int PROGRESS_1 = 5;
    public static final int PROGRESS_2 = 10;
    public static final int PROGRESS_3 = 20;
    public static final int PROGRESS_4 = 50;
    public static final int PROGRESS_5 = 60;
    public static final int PROGRESS_6 = 65;
    public static final int PROGRESS_7 = 70;
    public static final int PROGRESS_8 = 80;
    public static final int PROGRESS_9 = 90;
    public static final int PROGRESS_10 = 100;
    public static final int LOAD_END_PROGRESS = 60;
    private int[] progress = new int[]{0, 5, 10, 20, 50, 60, 65, 70, 80, 90, 100};
    private final Class<T> entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public int getExportPageSize() {
        return 1000;
    }

    @Override
    public String params2MD5(Map<String, Object> paramMap) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        LinkedHashMap sortedMap = new LinkedHashMap();
        paramMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(x -> sortedMap.put((String)x.getKey(), x.getValue()));
        StringBuffer sb = new StringBuffer();
        for (String key : sortedMap.keySet()) {
            sb.append(key).append((String)sortedMap.get(key));
        }
        return MD5.create().digestHex(sysUser.getActiveTenantId() + sysUser.getUsername() + sb.toString());
    }

    static Logger getLogger() {
        return log;
    }

    @Override
    public Class<?> configClassExcel(Class<?> c, List<?> importExportConfigs, boolean isImportTemplate) {
        Field[] fields = c.getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                ExcelCollection excelCollectionAnno;
                Field f = fields[i];
                Excel excelAn = f.getAnnotation(Excel.class);
                if (excelAn != null) {
                    for (Object configItem : importExportConfigs) {
                        String fieldName = (String)BeanUtil.getProperty(configItem, (String)"fieldName");
                        Object configDesc = isImportTemplate ? (String)BeanUtil.getProperty(configItem, (String)"importDesc") : (String)BeanUtil.getProperty(configItem, (String)"exportDesc");
                        configDesc = isImportTemplate && "0".equals((String)BeanUtil.getProperty(configItem, (String)"nullable")) ? "*" + (String)configDesc : ((String)configDesc).replaceAll("\\*", "");
                        String widthOri = isImportTemplate ? "180" : StrUtil.toString((Object)BeanUtil.getProperty(configItem, (String)"exportWidth"));
                        String orderNum = isImportTemplate ? StrUtil.toString((Object)BeanUtil.getProperty(configItem, (String)"importIndex")) : StrUtil.toString((Object)BeanUtil.getProperty(configItem, (String)"exportIndex"));
                        String controlType = StrUtil.toString((Object)BeanUtil.getProperty(configItem, (String)"controlType"));
                        String format = null;
                        switch (controlType) {
                            case "DatePicker": {
                                format = "yyyy-MM-dd";
                                break;
                            }
                            case "DateTimePicker": {
                                format = "yyyy-MM-dd HH:mm:ss";
                                break;
                            }
                            case "MonthPicker": {
                                format = "yyyy-MM";
                                break;
                            }
                            case "YearPicker": {
                                format = "yyyy";
                            }
                        }
                        if (!StrUtil.isNotEmpty((CharSequence)fieldName) || !f.getName().equals(fieldName)) continue;
                        InvocationHandler h = Proxy.getInvocationHandler(excelAn);
                        Field hField = h.getClass().getDeclaredField("memberValues");
                        hField.setAccessible(true);
                        Map memberValues = (Map)hField.get(h);
                        memberValues.put("name", configDesc);
                        BigDecimal widthDecimal = new BigDecimal(widthOri);
                        Double width = widthDecimal.subtract(new BigDecimal(5)).divide(new BigDecimal(7), 2, RoundingMode.HALF_UP).doubleValue();
                        memberValues.put("width", width);
                        memberValues.put("orderNum", orderNum);
                        if (!StrUtil.isNotEmpty((CharSequence)format)) continue;
                        memberValues.put("format", format);
                    }
                }
                if ((excelCollectionAnno = f.getAnnotation(ExcelCollection.class)) == null) continue;
                InvocationHandler h = Proxy.getInvocationHandler(excelCollectionAnno);
                Field hField = h.getClass().getDeclaredField("memberValues");
                hField.setAccessible(true);
                Map memberValues = (Map)hField.get(h);
                memberValues.put("orderNum", "999999");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleExportXls(HttpServletRequest request, Map<String, Object> body, Class<?> clazz, String title, HttpServletResponse response) {
        String sign = null;
        String type = null;
        Consumer<String> c = null;
        SseEmitterUTF8 emitter = null;
        Result<String> result = Result.OK();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!body.containsKey("sign")) {
            this.returnMessage(response, result);
            return;
        }
        sign = (String)body.get("sign");
        if ("init".equals(sign)) {
            sign = this.exportCacheUtils.getUserStatus(this.getClass().getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(SysExportTask::getCreateBy, (Object)sysUser.getUsername())).eq(SysExportTask::getConfigId, (Object)((String)body.get("configId")))).eq(SysExportTask::getDownloadFlag, (Object)"0")).notIn(SysExportTask::getStatus, new Object[]{"\u51c6\u5907\u4e2d", "\u5904\u7406\u4e2d"})).orderByDesc(SysExportTask::getCreateTime)).last("limit 10");
            List<SysExportTask> taskList = this.exportCacheUtils.getExportTaskList((QueryWrapper<SysExportTask>)queryWrapper);
            if (!StringUtils.isNotEmpty((String)sign)) {
                result.setResult(sysUser.getId());
                emitter = this.exportSseServer.connect(sysUser.getId());
                this.exportSseServer.sendData(sysUser.getId(), "init_data", taskList);
                this.exportSseServer.sendData(sysUser.getId(), "complete", 0);
                emitter.complete();
                this.returnMessage(response, result);
                return;
            }
            result.setResult(sign);
            this.exportSseServer.connect(sign);
            this.exportSseServer.sendData(sign, "init_data", taskList);
            ExportCacheDto ed = this.exportCacheUtils.get(sign);
            if (ed != null && ed.getProgress() != 100.0 && new Date().getTime() - ed.getLast() > 300000L) {
                this.exportCacheUtils.del(ed.getSign(), "\u5df2\u8d85\u65f6");
                this.exportCacheUtils.delUserStatus(this.getClass().getName());
                this.exportSseServer.sendData(sign, "error", "\u5df2\u8d85\u65f6");
                this.exportSseServer.complete(sign);
            }
        } else if ("request".equals(sign)) {
            sign = this.params2MD5(body);
            result.setResult(sign);
            this.exportSseServer.connect(sign);
            type = body.get("type") != null ? (String)body.get("type") : "xlsx";
            Object object = BeanUtil.toBean(body, this.entityClass);
            QueryWrapper<Object> qw = IMgBaseControllerExport.createQueryWrapper(object, body);
            String tenantId = TenantContext.getTenant();
            c = s -> {
                TenantContext.setTenant((String)tenantId);
                try {
                    this.exportXlsAsync((String)s, body, qw, clazz, title);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        } else if ("template".equals(sign)) {
            Object object = BeanUtil.toBean(new HashMap(), this.entityClass);
            QueryWrapper<Object> qw = IMgBaseControllerExport.createQueryWrapper(object, new HashMap<String, Object>());
            qw.eq((Object)"ID", (Object)"importExample");
            this.exportXlsTemplate(body, qw, clazz, title, response);
            return;
        }
        ExportCacheDto dto = this.export(sign, type, title, body, c);
        if (dto != null) {
            this.exportSseServer.sendData(sign, "progress_start", dto);
        } else {
            String errorMessage = this.exportCacheUtils.getUserError(this.getClass().getName());
            this.exportSseServer.sendData(sign, "error", errorMessage);
            this.exportSseServer.complete(sign);
            this.exportCacheUtils.delUserError(this.getClass().getName());
        }
        this.returnMessage(response, result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleImportExcelAsync(HttpServletRequest request, Map<String, Object> body, HttpServletResponse response, String title, Class<T> clazz) {
        ImportCacheDto dto;
        String sign = null;
        String type = null;
        Consumer<String> c = null;
        SseEmitterUTF8 emitter = null;
        Result<String> result = Result.OK();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!body.containsKey("sign")) {
            this.returnMessage(response, result);
            return;
        }
        sign = (String)body.get("sign");
        if ("init".equals(sign)) {
            sign = this.importCacheUtils.getUserStatus(this.getClass().getName());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(SysImportTask::getCreateBy, (Object)sysUser.getUsername())).eq(SysImportTask::getConfigId, (Object)((String)body.get("configId")))).eq(SysImportTask::getDownloadFlag, (Object)"0")).notIn(SysImportTask::getStatus, new Object[]{"\u51c6\u5907\u4e2d", "\u5904\u7406\u4e2d"})).orderByDesc(SysImportTask::getCreateTime)).last("limit 10");
            List<SysImportTask> taskList = this.importCacheUtils.getImportTaskList((QueryWrapper<SysImportTask>)queryWrapper);
            if (!StringUtils.isNotEmpty((String)sign)) {
                result.setResult(sysUser.getId());
                emitter = this.importSseServer.connect(sysUser.getId());
                this.importSseServer.sendData(sysUser.getId(), "init_data", taskList);
                this.importSseServer.sendData(sysUser.getId(), "complete", 0);
                emitter.complete();
                this.returnMessage(response, result);
                return;
            }
            result.setResult(sign);
            this.importSseServer.connect(sign);
            this.importSseServer.sendData(sign, "init_data", taskList);
            ImportCacheDto ed = this.importCacheUtils.get(sign);
            if (ed != null && ed.getProgress() != 100.0 && new Date().getTime() - ed.getLast() > 300000L) {
                this.importCacheUtils.del(ed.getSign(), "\u5df2\u8d85\u65f6");
                this.importCacheUtils.delUserStatus(this.getClass().getName());
                this.importSseServer.sendData(sign, "error", "\u5df2\u8d85\u65f6");
                this.importSseServer.complete(sign);
            }
        } else if ("request".equals(sign)) {
            sign = this.params2MD5(body);
            result.setResult(sign);
            this.importSseServer.connect(sign);
            String tenantId = TenantContext.getTenant();
            String finalSign = sign;
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Map fileMap = multipartRequest.getFileMap();
            HashMap<String, String> filePathMap = new HashMap<String, String>();
            for (Map.Entry entity : fileMap.entrySet()) {
                MultipartFile file = (MultipartFile)entity.getValue();
                if (file.isEmpty()) {
                    throw new JeecgBootException("\u6587\u4ef6\u4e3a\u7a7a\uff1a" + (String)entity.getKey());
                }
                try {
                    String fileName;
                    String originalFilename = file.getOriginalFilename();
                    if (StrUtil.isBlank((CharSequence)originalFilename) || !originalFilename.contains(".")) {
                        result.error500("\u6587\u4ef6\u540d\u79f0\u4e3a\u7a7a\u6216\u8005\u9519\u8bef:" + originalFilename);
                        this.returnMessage(response, result);
                        return;
                    }
                    type = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
                    ImportCacheDto importCacheDto = this.importCacheUtils.create(finalSign, type, fileName = originalFilename.substring(0, originalFilename.lastIndexOf(".")), title, body);
                    String importPath = this.importCacheUtils.getSavedFileUrl(finalSign, importCacheDto);
                    String absolutePath = Paths.get(this.uploadPath, importPath).toAbsolutePath().toString();
                    File destFile = new File(absolutePath);
                    File parentDir = destFile.getParentFile();
                    if (!parentDir.exists()) {
                        parentDir.mkdirs();
                    }
                    file.transferTo(destFile);
                    filePathMap.put((String)entity.getKey(), importCacheDto.getFileUrl());
                }
                catch (IOException e) {
                    throw new JeecgBootException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + file.getOriginalFilename() + e);
                }
            }
            c = s -> {
                TenantContext.setTenant((String)tenantId);
                try {
                    this.importExcelAsync(finalSign, body, filePathMap, clazz);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        if ((dto = this.getImportDto(sign, c)) != null) {
            this.importSseServer.sendData(sign, "progress_start", dto);
        } else {
            String errorMessage = this.importCacheUtils.getUserError(this.getClass().getName());
            this.importSseServer.sendData(sign, "error", errorMessage);
            this.importSseServer.complete(sign);
            this.importCacheUtils.delUserError(this.getClass().getName());
        }
        this.returnMessage(response, result);
    }

    protected Result<?> handleImportExcelSync(HttpServletRequest request, HttpServletResponse response, Class<T> clazz) {
        Map parameterMap = request.getParameterMap();
        if (parameterMap.containsKey("configId")) {
            String configId = request.getParameter("configId");
            return this.importExcelSync(request, clazz, configId);
        }
        return super.importExcelSync(request, response, clazz);
    }

    protected Result<?> mgList(T object, Integer pageNo, Integer pageSize, HttpServletRequest req) {
        return this.mgList(object, pageNo, pageSize, req, null, null);
    }

    protected Result<?> mgList(T object, Integer pageNo, Integer pageSize, HttpServletRequest req, QueryWrapper<T> queryWrapper) {
        return this.mgList(object, pageNo, pageSize, req, queryWrapper, null);
    }

    protected Result<?> mgList(T object, Integer pageNo, Integer pageSize, HttpServletRequest req, Map<String, QueryRuleEnum> customeRuleMap) {
        return this.mgList(object, pageNo, pageSize, req, null, customeRuleMap);
    }

    protected Result<?> mgList(T object, Integer pageNo, Integer pageSize, HttpServletRequest req, QueryWrapper<T> queryWrapper, Map<String, QueryRuleEnum> customeRuleMap) {
        Map parameterMap = req.getParameterMap();
        if (queryWrapper == null) {
            queryWrapper = QueryGenerator.initQueryWrapper(object, parameterMap, customeRuleMap);
        }
        String viewType = MgViewTypeEnum.TABLE.getKey();
        if (parameterMap != null && parameterMap.containsKey(VIEW_TYPE_MG)) {
            viewType = ((String[])parameterMap.get(VIEW_TYPE_MG))[0];
        }
        JSONObject viewTypeMap = new JSONObject();
        if (parameterMap != null && parameterMap.containsKey(VIEW_TYPE_MAP_MG)) {
            String viewTypeMapStr = null;
            viewTypeMapStr = URLDecoder.decode(((String[])parameterMap.get(VIEW_TYPE_MAP_MG))[0], StandardCharsets.UTF_8);
            if (StrUtil.isNotBlank((CharSequence)viewTypeMapStr)) {
                viewTypeMap = JSONUtil.parseObj((String)viewTypeMapStr);
            }
        }
        if (MgViewTypeEnum.TABLE.getKey().equals(viewType) || MgViewTypeEnum.PICTURE.getKey().equals(viewType) || MgViewTypeEnum.INSTRUMENT.getKey().equals(viewType)) {
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            Page resultPage = (Page)this.service.page((IPage)page, queryWrapper);
            this.changePageList((IPage<T>)resultPage);
            return Result.OK(resultPage);
        }
        if (MgViewTypeEnum.CALENDAR.getKey().equals(viewType)) {
            Integer maxSum = viewTypeMap.getInt((Object)CALENDAR_MAX_SUM, Integer.valueOf(20));
            Page page = new Page((long)pageNo.intValue(), (long)maxSum.intValue());
            return Result.OK((Page)this.service.page((IPage)page, queryWrapper));
        }
        if (MgViewTypeEnum.DASHBOARD.getKey().equals(viewType)) {
            String groupField = viewTypeMap.getStr((Object)DASHBOARD_GROUP_FIELD);
            if (StrUtil.isEmpty((CharSequence)groupField)) {
                throw new JeecgBootException("\u770b\u677f\u5206\u7ec4\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String groupFieldValue = viewTypeMap.getStr((Object)DASHBOARD_GROUP_FIELD_VALUE);
            if (StrUtil.isEmpty((CharSequence)groupFieldValue)) {
                QueryWrapper groupQuery = (QueryWrapper)queryWrapper.clone();
                ((QueryWrapper)groupQuery.select((Object[])new String[]{"DISTINCT " + groupField})).orderByAsc((Object)groupField);
                List groups = this.service.listMaps((Wrapper)groupQuery);
                ArrayList resultList = new ArrayList();
                for (Map group : groups) {
                    QueryWrapper groupDataQuery = (QueryWrapper)queryWrapper.clone();
                    if (oConvertUtils.isEmpty(group)) {
                        groupDataQuery.and(i -> ((QueryWrapper)((QueryWrapper)i.isNull((Object)groupField)).or()).eq((Object)groupField, (Object)""));
                    } else {
                        groupDataQuery.eq((Object)groupField, group.get(groupField));
                    }
                    Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
                    IPage pageList = this.service.page((IPage)page, (Wrapper)groupDataQuery);
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("pageData", pageList);
                    resultMap.put(DASHBOARD_GROUP_FIELD, groupField);
                    resultMap.put("title", oConvertUtils.isNotEmpty(group) ? group.get(groupField) : "\u672a\u5206\u7ec4");
                    resultMap.put("value", oConvertUtils.isNotEmpty(group) ? group.get(groupField) : "");
                    resultList.add(resultMap);
                }
                return Result.OK(resultList);
            }
            if (StrUtil.isBlank((CharSequence)groupFieldValue)) {
                ArrayList resultList = new ArrayList();
                QueryWrapper groupDataQuery = (QueryWrapper)queryWrapper.clone();
                groupDataQuery.and(i -> ((QueryWrapper)((QueryWrapper)i.isNull((Object)groupField)).or()).eq((Object)groupField, (Object)""));
                Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
                IPage pageList = this.service.page((IPage)page, (Wrapper)groupDataQuery);
                HashMap<String, Object> resultMap = new HashMap<String, Object>();
                resultMap.put("pageData", pageList);
                resultMap.put(DASHBOARD_GROUP_FIELD, groupField);
                resultMap.put("title", "\u672a\u5206\u7ec4");
                resultMap.put("value", "");
                resultList.add(resultMap);
                return Result.OK(resultList);
            }
            ArrayList resultList = new ArrayList();
            QueryWrapper groupDataQuery = (QueryWrapper)queryWrapper.clone();
            groupDataQuery.eq((Object)groupField, (Object)groupFieldValue);
            Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
            IPage pageList = this.service.page((IPage)page, (Wrapper)groupDataQuery);
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("pageData", pageList);
            resultMap.put(DASHBOARD_GROUP_FIELD, groupField);
            resultMap.put("title", groupFieldValue);
            resultMap.put("value", groupFieldValue);
            resultList.add(resultMap);
            return Result.OK(resultList);
        }
        throw new JeecgBootException("\u4e0d\u652f\u6301\u7684\u89c6\u56fe\u7c7b\u578b");
    }

    protected Result<?> batchEdit(Map<String, Object> body) {
        Field[] fields;
        List updateIds = (List)body.get("updateIds");
        Object updateFormData = BeanUtil.toBean((Object)body.get("updateFormData"), this.entityClass);
        if (updateIds == null || updateIds.isEmpty()) {
            return Result.error("\u672a\u9009\u62e9\u6570\u636e");
        }
        if (updateFormData == null) {
            return Result.error("\u672a\u586b\u5199\u4fee\u6539\u5185\u5bb9");
        }
        for (Field field : fields = updateFormData.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                String value;
                if (!(field.get(updateFormData) instanceof String) || !StrUtil.isBlank((CharSequence)(value = (String)field.get(updateFormData)))) continue;
                field.set(updateFormData, null);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        for (String updateId : updateIds) {
            this.addOperationHistory((Base)updateFormData, (Serializable)((Object)updateId), "\u66f4\u65b0");
        }
        updateWrapper.in((Object)"id", (Collection)updateIds);
        this.service.update(updateFormData, (Wrapper)updateWrapper);
        return Result.OK("\u7f16\u8f91\u5b8c\u6210");
    }

    protected void changePageList(IPage<T> page) {
    }

    @Override
    public S getService() {
        return this.service;
    }

    @Override
    public ExportCacheUtils getExportCacheUtils() {
        return this.exportCacheUtils;
    }

    @Override
    public ImportCacheUtils getImportCacheUtils() {
        return this.importCacheUtils;
    }

    @Override
    public ISysBusinessImportService getBusinessImportService() {
        return this.businessImportService;
    }

    @Override
    public ISysBusinessExportService getBusinessExportService() {
        return this.businessExportService;
    }

    @Override
    public ExportSseServer getExportSseServer() {
        return this.exportSseServer;
    }

    @Override
    public ImportSseServer getImportSseServer() {
        return this.importSseServer;
    }

    @Override
    public String getUploadPath() {
        return this.uploadPath;
    }

    @Override
    public String getUploadType() {
        return this.uploadType;
    }

    @Override
    public int[] getProgress() {
        return this.progress;
    }
}

