/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.socket.transport;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.security.InvalidParameterException;
import java.util.Map;
import java.util.function.Supplier;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.StateMachineEnum;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.buffer.VirtualBuffer;
import org.smartboot.socket.enhance.EnhanceAsynchronousChannelProvider;
import org.smartboot.socket.transport.AioSession;
import org.smartboot.socket.transport.IOUtil;
import org.smartboot.socket.transport.IoServerConfig;
import org.smartboot.socket.transport.TcpAioSession;

public final class AioQuickServer {
    private AsynchronousServerSocketChannel serverSocketChannel = null;
    private AsynchronousChannelGroup asynchronousChannelGroup;
    private boolean lowMemory = true;
    private final IoServerConfig config = new IoServerConfig();
    private static long threadSeqNumber;
    private BufferPagePool writeBufferPool = null;
    private BufferPagePool readBufferPool = null;

    public <T> AioQuickServer(int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this.config.setPort(port);
        this.config.setProtocol(protocol);
        this.config.setProcessor(messageProcessor);
        this.config.setThreadNum(Runtime.getRuntime().availableProcessors());
    }

    public <T> AioQuickServer(String host, int port, Protocol<T> protocol, MessageProcessor<T> messageProcessor) {
        this(port, protocol, messageProcessor);
        this.config.setHost(host);
    }

    public void start() throws IOException {
        this.asynchronousChannelGroup = new EnhanceAsynchronousChannelProvider(this.lowMemory).openAsynchronousChannelGroup(this.config.getThreadNum(), r -> new Thread(r, "smart-socket:Thread-" + threadSeqNumber++));
        this.start(this.asynchronousChannelGroup);
    }

    public void start(AsynchronousChannelGroup asynchronousChannelGroup) throws IOException {
        if (this.config.isBannerEnabled()) {
            System.out.println("\n                               _                           _             _   \n                              ( )_                        ( )           ( )_ \n  ___   ___ ___     _ _  _ __ | ,_)     ___    _      ___ | |/')    __  | ,_)\n/',__)/' _ ` _ `\\ /'_` )( '__)| |     /',__) /'_`\\  /'___)| , <   /'__`\\| |  \n\\__, \\| ( ) ( ) |( (_| || |   | |_    \\__, \\( (_) )( (___ | |\\`\\ (  ___/| |_ \n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (____/`\\___/'`\\____)(_) (_)`\\____)`\\__)\r\n :: smart-socket ::\t(v1.5.55) [port: " + this.config.getPort() + ", threadNum:" + this.config.getThreadNum() + "]");
            System.out.println("Technical Support:");
            System.out.println(" - Document: https://smartboot.tech]");
            System.out.println(" - Gitee: https://gitee.com/smartboot/smart-socket");
            System.out.println(" - Github: https://github.com/smartboot/smart-socket");
        }
        try {
            if (this.writeBufferPool == null) {
                this.writeBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
            }
            if (this.readBufferPool == null) {
                this.readBufferPool = BufferPagePool.DEFAULT_BUFFER_PAGE_POOL;
            }
            this.serverSocketChannel = AsynchronousServerSocketChannel.open(asynchronousChannelGroup);
            if (this.config.getSocketOptions() != null) {
                for (Map.Entry<SocketOption<Object>, Object> entry : this.config.getSocketOptions().entrySet()) {
                    this.serverSocketChannel.setOption((SocketOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.config.getHost() != null) {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getHost(), this.config.getPort()), this.config.getBacklog());
            } else {
                this.serverSocketChannel.bind(new InetSocketAddress(this.config.getPort()), this.config.getBacklog());
            }
            this.startAcceptThread();
        }
        catch (IOException e) {
            this.shutdown();
            throw e;
        }
    }

    private void startAcceptThread() {
        final Supplier<VirtualBuffer> readBufferSupplier = () -> this.readBufferPool.allocateBufferPage().allocate(this.config.getReadBufferSize());
        this.serverSocketChannel.accept(null, new CompletionHandler<AsynchronousSocketChannel, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(AsynchronousSocketChannel channel, Void attachment) {
                try {
                    AioQuickServer.this.serverSocketChannel.accept(attachment, this);
                }
                catch (Throwable throwable) {
                    AioQuickServer.this.config.getProcessor().stateEvent(null, StateMachineEnum.ACCEPT_EXCEPTION, throwable);
                    this.failed(throwable, attachment);
                    AioQuickServer.this.serverSocketChannel.accept(attachment, this);
                }
                finally {
                    AioQuickServer.this.createSession(channel, readBufferSupplier);
                }
            }

            @Override
            public void failed(Throwable exc, Void attachment) {
                exc.printStackTrace();
            }
        });
    }

    private void createSession(AsynchronousSocketChannel channel, Supplier<VirtualBuffer> readBufferSupplier) {
        AioSession session = null;
        AsynchronousSocketChannel acceptChannel = channel;
        try {
            if (this.config.getMonitor() != null) {
                acceptChannel = this.config.getMonitor().shouldAccept(channel);
            }
            if (acceptChannel != null) {
                acceptChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                session = new TcpAioSession(acceptChannel, this.config, this.writeBufferPool.allocateBufferPage(), readBufferSupplier);
            } else {
                this.config.getProcessor().stateEvent(null, StateMachineEnum.REJECT_ACCEPT, null);
                IOUtil.close(channel);
            }
        }
        catch (Exception e) {
            if (session == null) {
                IOUtil.close(channel);
            } else {
                session.close();
            }
            this.config.getProcessor().stateEvent(null, StateMachineEnum.INTERNAL_EXCEPTION, e);
        }
    }

    public void shutdown() {
        try {
            if (this.serverSocketChannel != null) {
                this.serverSocketChannel.close();
                this.serverSocketChannel = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.asynchronousChannelGroup != null) {
            this.asynchronousChannelGroup.shutdown();
        }
    }

    public AioQuickServer setReadBufferSize(int size) {
        this.config.setReadBufferSize(size);
        return this;
    }

    public final AioQuickServer setBannerEnabled(boolean bannerEnabled) {
        this.config.setBannerEnabled(bannerEnabled);
        return this;
    }

    public final <V> AioQuickServer setOption(SocketOption<V> socketOption, V value) {
        this.config.setOption(socketOption, value);
        return this;
    }

    public final AioQuickServer setThreadNum(int threadNum) {
        if (threadNum <= 1) {
            throw new InvalidParameterException("threadNum must >= 2");
        }
        this.config.setThreadNum(threadNum);
        return this;
    }

    public AioQuickServer setWriteBuffer(int bufferSize, int bufferCapacity) {
        this.config.setWriteBufferSize(bufferSize);
        this.config.setWriteBufferCapacity(bufferCapacity);
        return this;
    }

    public final AioQuickServer setBacklog(int backlog) {
        this.config.setBacklog(backlog);
        return this;
    }

    public AioQuickServer setBufferPagePool(BufferPagePool bufferPool) {
        return this.setBufferPagePool(bufferPool, bufferPool);
    }

    public AioQuickServer setBufferPagePool(BufferPagePool readBufferPool, BufferPagePool writeBufferPool) {
        this.writeBufferPool = writeBufferPool;
        this.readBufferPool = readBufferPool;
        return this;
    }

    public AioQuickServer disableLowMemory() {
        this.lowMemory = false;
        return this;
    }
}

