/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.sender;

import io.growing.sdk.java.constants.APIConstants;
import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.process.ProcessClient;
import io.growing.sdk.java.sender.MessageSender;
import io.growing.sdk.java.sender.net.HttpUrlProvider;
import io.growing.sdk.java.sender.net.NetProviderAbstract;
import io.growing.sdk.java.thread.GioThreadNamedFactory;
import io.growing.sdk.java.utils.ConfigUtils;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FixThreadPoolSender
implements MessageSender {
    private static ExecutorService sendThread = Executors.newFixedThreadPool(ConfigUtils.getIntValue("send.msg.thread", 3), new GioThreadNamedFactory("gio-sender"));
    private static final String projectId = ConfigUtils.getStringValue("project.id", "");
    private static final NetProviderAbstract netProvider = new HttpUrlProvider();
    private String uploadEventApi = APIConstants.buildUploadEventAPI(projectId);

    @Override
    public void sendMsg(List<GIOMessage> msg) {
        this.doSend(msg);
    }

    private String addStmQueryParams(String url) {
        return url + "?stm=" + System.currentTimeMillis();
    }

    public static NetProviderAbstract getNetProvider() {
        return netProvider;
    }

    public void doSend(final List<GIOMessage> msg) {
        if (null != msg) {
            sendThread.execute(new Runnable(){

                @Override
                public void run() {
                    FixThreadPoolSender.getNetProvider().toSend(FixThreadPoolSender.this.addStmQueryParams(FixThreadPoolSender.this.uploadEventApi), ProcessClient.process(msg));
                }
            });
        }
    }

    public static String getProjectId() {
        return projectId;
    }
}

