/*
 * Decompiled with CFR 0.152.
 */
package io.growing.sdk.java.store.impl;

import io.growing.sdk.java.dto.GIOMessage;
import io.growing.sdk.java.logger.GioLogger;
import io.growing.sdk.java.sender.FixThreadPoolSender;
import io.growing.sdk.java.sender.MessageSender;
import io.growing.sdk.java.store.StoreStrategyAbstract;
import io.growing.sdk.java.thread.GioThreadNamedFactory;
import io.growing.sdk.java.utils.ConfigUtils;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultStoreStrategy
extends StoreStrategyAbstract {
    private static final int limit = ConfigUtils.getIntValue("msg.store.queue.size", 500);
    private static final ArrayBlockingQueue<GIOMessage> queue = new ArrayBlockingQueue(limit);
    private static final ScheduledExecutorService sendMsgSchedule = Executors.newScheduledThreadPool(1, new GioThreadNamedFactory("gio-send-msg-schedule"));
    private static final int sendInterval = ConfigUtils.getIntValue("send.msg.interval", 100);
    private static final MessageSender sender = new FixThreadPoolSender();
    private static final int sendMsgBatchSize = 100;
    private static AtomicInteger offered = new AtomicInteger(0);

    @Override
    public void doPush(GIOMessage msg) {
        if (!queue.offer(msg)) {
            GioLogger.error("msg queue is full, suggest greater size for [msg.store.queue.size] or shorten the interval of [send.msg.interval]");
        }
    }

    static {
        sendMsgSchedule.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ArrayList<GIOMessage> msg = new ArrayList<GIOMessage>(100);
                while (!queue.isEmpty() && msg.size() < 100) {
                    GIOMessage gioMessage = (GIOMessage)queue.poll();
                    if (gioMessage == null) continue;
                    msg.add(gioMessage);
                }
                if (!msg.isEmpty()) {
                    sender.sendMsg(msg);
                }
            }
        }, sendInterval, sendInterval, TimeUnit.MILLISECONDS);
    }
}

