/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.ApiConstants;
import io.nats.client.support.JsonSerializable;
import io.nats.client.support.JsonUtils;
import io.nats.client.support.Validator;
import java.util.Arrays;
import java.util.List;

public class Placement
implements JsonSerializable {
    private final String cluster;
    private final List<String> tags;

    static Placement optionalInstance(String fullJson) {
        String objJson = JsonUtils.getJsonObject("placement", fullJson, null);
        return objJson == null ? null : new Placement(objJson);
    }

    Placement(String json) {
        this.cluster = JsonUtils.readString(json, ApiConstants.CLUSTER_RE);
        this.tags = JsonUtils.getStringList("tags", json);
    }

    public Placement(String cluster, List<String> tags) {
        this.cluster = cluster;
        this.tags = tags == null || tags.size() == 0 ? null : tags;
    }

    public String getCluster() {
        return this.cluster;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String toString() {
        return "Placement{cluster='" + this.cluster + '\'' + ", tags=" + this.tags + '}';
    }

    @Override
    public String toJson() {
        StringBuilder sb = JsonUtils.beginJson();
        JsonUtils.addField(sb, "cluster", this.cluster);
        JsonUtils.addStrings(sb, "tags", this.tags);
        return JsonUtils.endJson(sb).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String cluster;
        private List<String> tags;

        public Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public Builder tags(String ... tags) {
            this.tags = Arrays.asList(tags);
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public Placement build() {
            Validator.required(this.cluster, "Cluster");
            return new Placement(this.cluster, this.tags);
        }
    }
}

