/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.api;

import io.nats.client.support.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Subject
implements Comparable<Subject> {
    private final String name;
    private final long count;

    static List<Subject> optionalListOf(String json) {
        ArrayList<Subject> list = new ArrayList<Subject>();
        if (json != null) {
            Map<String, Long> map = JsonUtils.getMapOfLongs(json);
            for (String subject : map.keySet()) {
                list.add(new Subject(subject, map.get(subject)));
            }
            Collections.sort(list);
        }
        return list.isEmpty() ? null : list;
    }

    private Subject(String name, long count) {
        this.name = name;
        this.count = count;
    }

    public String getName() {
        return this.name;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        return "Subject{name='" + this.name + '\'' + ", count=" + this.count + '}';
    }

    @Override
    public int compareTo(Subject o) {
        return this.name.compareTo(o.name);
    }
}

