/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp;

import io.spring.nohttp.HttpMatcher;
import io.spring.nohttp.HttpReplacer;
import io.spring.nohttp.RegexHttpMatcher;
import java.util.regex.Pattern;

public abstract class GradleHttpDsl {
    public static HttpReplacer createReplacer() {
        return GradleHttpDsl.createGradleDslMatcher();
    }

    public static HttpMatcher createMatcher() {
        return GradleHttpDsl.createGradleDslMatcher();
    }

    private static RegexHttpMatcher createGradleDslMatcher() {
        RegexHttpMatcher matcher = new RegexHttpMatcher(h -> false);
        matcher.setPattern(Pattern.compile("(mavenCentral\\(\\)|jcenter\\(\\))"));
        matcher.setHttpReplacer(http -> {
            if (http.equals("mavenCentral()")) {
                return "maven { url 'https://repo.maven.apache.org/maven2/' }";
            }
            if (http.equals("jcenter()")) {
                return "maven { url 'https://jcenter.bintray.com/' }";
            }
            throw new IllegalArgumentException("Expected either mavenCentral() or jcenter() but got '" + http + "'");
        });
        return matcher;
    }

    private GradleHttpDsl() {
    }
}

