/*
 * Decompiled with CFR 0.152.
 */
package io.spring.nohttp.file;

import io.spring.nohttp.HttpMatchResult;
import io.spring.nohttp.HttpReplaceResult;
import io.spring.nohttp.HttpReplacer;
import io.spring.nohttp.file.FileUtils;
import io.spring.nohttp.file.HttpProcessor;
import java.io.File;
import java.util.List;

public class HttpReplacerProcessor
extends HttpProcessor {
    private final HttpReplacer replacer;

    public HttpReplacerProcessor(HttpReplacer replacer) {
        if (replacer == null) {
            throw new IllegalArgumentException("replacer cannot be null");
        }
        this.replacer = replacer;
    }

    @Override
    List<HttpMatchResult> processHttpInFile(File file) {
        String originalText = FileUtils.readTextFrom(file);
        HttpReplaceResult result = this.replacer.replaceHttp(originalText);
        if (result.isReplacement()) {
            FileUtils.writeTextTo(result.getResult(), file);
        }
        return result.getMatches();
    }
}

