/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.datasource;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.Preconditions;
import com.alibaba.nacos.config.server.service.datasource.DataSourcePoolProperties;
import com.zaxxer.hikari.HikariDataSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class ExternalDataSourceProperties {
    private static final String JDBC_DRIVER_NAME = "com.mysql.cj.jdbc.Driver";
    private static final String TEST_QUERY = "SELECT 1";
    private Integer num;
    private List<String> url = new ArrayList<String>();
    private List<String> user = new ArrayList<String>();
    private List<String> password = new ArrayList<String>();

    public void setNum(Integer num) {
        this.num = num;
    }

    public void setUrl(List<String> url) {
        this.url = url;
    }

    public void setUser(List<String> user) {
        this.user = user;
    }

    public void setPassword(List<String> password) {
        this.password = password;
    }

    List<HikariDataSource> build(Environment environment, Callback<HikariDataSource> callback) {
        ArrayList<HikariDataSource> dataSources = new ArrayList<HikariDataSource>();
        Binder.get((Environment)environment).bind("db", Bindable.ofInstance((Object)this));
        Preconditions.checkArgument((boolean)Objects.nonNull(this.num), (Object)"db.num is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.user), (Object)"db.user or db.user.[index] is null");
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(this.password), (Object)"db.password or db.password.[index] is null");
        for (int index = 0; index < this.num; ++index) {
            int currentSize = index + 1;
            Preconditions.checkArgument((this.url.size() >= currentSize ? 1 : 0) != 0, (String)"db.url.%s is null", (Object[])new Object[]{index});
            DataSourcePoolProperties poolProperties = DataSourcePoolProperties.build(environment);
            poolProperties.setDriverClassName(JDBC_DRIVER_NAME);
            poolProperties.setJdbcUrl(this.url.get(index).trim());
            poolProperties.setUsername(((String)CollectionUtils.getOrDefault(this.user, (int)index, (Object)this.user.get(0))).trim());
            poolProperties.setPassword(((String)CollectionUtils.getOrDefault(this.password, (int)index, (Object)this.password.get(0))).trim());
            HikariDataSource ds = poolProperties.getDataSource();
            ds.setConnectionTestQuery(TEST_QUERY);
            ds.setIdleTimeout(TimeUnit.MINUTES.toMillis(10L));
            ds.setConnectionTimeout(TimeUnit.SECONDS.toMillis(3L));
            dataSources.add(ds);
            callback.accept(ds);
        }
        Preconditions.checkArgument((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(dataSources), (Object)"no datasource available");
        return dataSources;
    }

    static interface Callback<D> {
        public void accept(D var1);
    }
}

