/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import com.alibaba.nacos.auth.model.User;
import com.alibaba.nacos.common.utils.StringUtils;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    private static final String X_REAL_IP = "X-Real-IP";
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String X_FORWARDED_FOR_SPLIT_SYMBOL = ",";
    public static final String CLIENT_APPNAME_HEADER = "Client-AppName";
    public static final String NACOS_USER_KEY = "nacosuser";

    public static String getRemoteIp(HttpServletRequest request) {
        String xForwardedFor = request.getHeader(X_FORWARDED_FOR);
        if (!StringUtils.isBlank((CharSequence)xForwardedFor)) {
            return xForwardedFor.split(X_FORWARDED_FOR_SPLIT_SYMBOL)[0].trim();
        }
        String nginxHeader = request.getHeader(X_REAL_IP);
        return StringUtils.isBlank((CharSequence)nginxHeader) ? request.getRemoteAddr() : nginxHeader;
    }

    public static String getAppName(HttpServletRequest request) {
        return request.getHeader(CLIENT_APPNAME_HEADER);
    }

    public static User getUser(HttpServletRequest request) {
        Object userObj = request.getSession().getAttribute(NACOS_USER_KEY);
        if (userObj == null) {
            return null;
        }
        return (User)userObj;
    }

    public static String getSrcUserName(HttpServletRequest request) {
        User user = RequestUtil.getUser(request);
        return user == null ? request.getParameter("username") : user.getUserName();
    }
}

