/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

public class RegexParser {
    private static final char QUESTION_MARK = '?';

    public static String regexFormat(String regex) {
        if (regex == null) {
            throw new NullPointerException("regex string can't be null");
        }
        StringBuilder result = new StringBuilder();
        result.append('^');
        for (int i = 0; i < regex.length(); ++i) {
            char ch = regex.charAt(i);
            if (RegexParser.isAsciiAlphanumeric(ch).booleanValue()) {
                result.append(ch);
                continue;
            }
            if (ch == '*') {
                result.append(".*");
                continue;
            }
            if (ch == '?') {
                int j;
                for (j = 0; j < regex.length() - i && ch == '?'; ++j) {
                    ch = regex.charAt(i + j);
                }
                if (j == regex.length() - i) {
                    result.append(".{" + j + "}");
                    break;
                }
                result.append(".{" + --j + "}");
                i += j - 1;
                continue;
            }
            result.append("\\" + ch);
        }
        result.append('$');
        return result.toString();
    }

    public static boolean containsWildcard(String regex) {
        return regex.contains("?") || regex.contains("*");
    }

    private static Boolean isAsciiAlphanumeric(char ch) {
        return RegexParser.isAsciiAlphaUpper(ch) != false || RegexParser.isAsciiAlphaLower(ch) != false || RegexParser.isAsciiNumeric(ch) != false;
    }

    private static Boolean isAsciiNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static Boolean isAsciiAlphaUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    private static Boolean isAsciiAlphaLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }
}

