/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.event.ServerConfigChangeEvent;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.executor.ThreadPoolManager;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.listener.NacosApplicationListener;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.file.FileChangeEvent;
import com.alibaba.nacos.sys.file.FileWatcher;
import com.alibaba.nacos.sys.file.WatchFileCenter;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class StartingApplicationListener
implements NacosApplicationListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartingApplicationListener.class);
    private static final String MODE_PROPERTY_KEY_STAND_MODE = "nacos.mode";
    private static final String MODE_PROPERTY_KEY_FUNCTION_MODE = "nacos.function.mode";
    private static final String LOCAL_IP_PROPERTY_KEY = "nacos.local.ip";
    private static final String NACOS_APPLICATION_CONF = "nacos_application_conf";
    private static final String NACOS_MODE_STAND_ALONE = "stand alone";
    private static final String NACOS_MODE_CLUSTER = "cluster";
    private static final String DEFAULT_FUNCTION_MODE = "All";
    private static final String DEFAULT_DATABASE = "mysql";
    private static final String DATASOURCE_PLATFORM_PROPERTY = "spring.datasource.platform";
    private static final String DEFAULT_DATASOURCE_PLATFORM = "";
    private static final String DATASOURCE_MODE_EXTERNAL = "external";
    private static final String DATASOURCE_MODE_EMBEDDED = "embedded";
    private static final Map<String, Object> SOURCES = new ConcurrentHashMap<String, Object>();
    private ScheduledExecutorService scheduledExecutorService;
    private volatile boolean starting;

    @Override
    public void starting() {
        this.starting = true;
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        this.makeWorkDir();
        this.injectEnvironment(environment);
        this.loadPreProperties(environment);
        this.initSystemProperty();
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
        this.logClusterConf();
        this.logStarting();
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    @Override
    public void started(ConfigurableApplicationContext context) {
        this.starting = false;
        this.closeExecutor();
        ApplicationUtils.setStarted((boolean)true);
        this.judgeStorageMode(context.getEnvironment());
    }

    @Override
    public void running(ConfigurableApplicationContext context) {
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
        this.starting = false;
        this.makeWorkDir();
        LOGGER.error("Startup errors : ", exception);
        ThreadPoolManager.shutdown();
        WatchFileCenter.shutdown();
        NotifyCenter.shutdown();
        this.closeExecutor();
        context.close();
        LOGGER.error("Nacos failed to start, please see {} for more details.", (Object)Paths.get(EnvUtil.getNacosHome(), "logs/nacos.log"));
    }

    private void injectEnvironment(ConfigurableEnvironment environment) {
        EnvUtil.setEnvironment((ConfigurableEnvironment)environment);
    }

    private void loadPreProperties(ConfigurableEnvironment environment) {
        try {
            SOURCES.putAll(EnvUtil.loadProperties((Resource)EnvUtil.getApplicationConfFileResource()));
            environment.getPropertySources().addLast((PropertySource)new OriginTrackedMapPropertySource(NACOS_APPLICATION_CONF, SOURCES));
            this.registerWatcher();
        }
        catch (Exception e) {
            throw new NacosRuntimeException(500, (Throwable)e);
        }
    }

    private void registerWatcher() throws NacosException {
        WatchFileCenter.registerWatcher((String)EnvUtil.getConfPath(), (FileWatcher)new FileWatcher(){

            public void onChange(FileChangeEvent event) {
                try {
                    Map tmp = EnvUtil.loadProperties((Resource)EnvUtil.getApplicationConfFileResource());
                    SOURCES.putAll(tmp);
                    NotifyCenter.publishEvent((Event)ServerConfigChangeEvent.newEvent());
                }
                catch (IOException ignore) {
                    LOGGER.warn("Failed to monitor file ", (Throwable)ignore);
                }
            }

            public boolean interest(String context) {
                return StringUtils.contains((CharSequence)context, (CharSequence)"application.properties");
            }
        });
    }

    private void initSystemProperty() {
        if (EnvUtil.getStandaloneMode()) {
            System.setProperty(MODE_PROPERTY_KEY_STAND_MODE, NACOS_MODE_STAND_ALONE);
        } else {
            System.setProperty(MODE_PROPERTY_KEY_STAND_MODE, NACOS_MODE_CLUSTER);
        }
        if (EnvUtil.getFunctionMode() == null) {
            System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, DEFAULT_FUNCTION_MODE);
        } else if ("config".equals(EnvUtil.getFunctionMode())) {
            System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, "config");
        } else if ("naming".equals(EnvUtil.getFunctionMode())) {
            System.setProperty(MODE_PROPERTY_KEY_FUNCTION_MODE, "naming");
        }
        System.setProperty(LOCAL_IP_PROPERTY_KEY, InetUtils.getSelfIP());
    }

    private void logClusterConf() {
        if (!EnvUtil.getStandaloneMode()) {
            try {
                List clusterConf = EnvUtil.readClusterConf();
                LOGGER.info("The server IP list of Nacos is {}", (Object)clusterConf);
            }
            catch (IOException e) {
                LOGGER.error("read cluster conf fail", (Throwable)e);
            }
        }
    }

    private void closeExecutor() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    private void makeWorkDir() {
        String[] dirNames;
        for (String dirName : dirNames = new String[]{"logs", "conf", "data"}) {
            LOGGER.info("Nacos Log files: {}", (Object)Paths.get(EnvUtil.getNacosHome(), dirName).toString());
            try {
                DiskUtils.forceMkdir((File)new File(Paths.get(EnvUtil.getNacosHome(), dirName).toUri()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void logStarting() {
        if (!EnvUtil.getStandaloneMode()) {
            this.scheduledExecutorService = ExecutorFactory.newSingleScheduledExecutorService((ThreadFactory)new NameThreadFactory("com.alibaba.nacos.core.nacos-starting"));
            this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
                if (this.starting) {
                    LOGGER.info("Nacos is starting...");
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
    }

    private void judgeStorageMode(ConfigurableEnvironment env) {
        boolean useExternalStorage = DEFAULT_DATABASE.equalsIgnoreCase(env.getProperty(DATASOURCE_PLATFORM_PROPERTY, DEFAULT_DATASOURCE_PLATFORM));
        if (!useExternalStorage) {
            boolean embeddedStorage;
            boolean bl = embeddedStorage = EnvUtil.getStandaloneMode() || Boolean.getBoolean("embeddedStorage");
            if (!embeddedStorage) {
                useExternalStorage = true;
            }
        }
        LOGGER.info("Nacos started successfully in {} mode. use {} storage", (Object)System.getProperty(MODE_PROPERTY_KEY_STAND_MODE), (Object)(useExternalStorage ? DATASOURCE_MODE_EXTERNAL : DATASOURCE_MODE_EMBEDDED));
    }
}

