/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.common.AbstractConnection;
import com.alibaba.nacos.istio.common.WatchedStatus;
import com.alibaba.nacos.istio.misc.Loggers;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.stub.StreamObserver;

public class XdsConnection
extends AbstractConnection<DiscoveryResponse> {
    public XdsConnection(StreamObserver<DiscoveryResponse> streamObserver) {
        super(streamObserver);
    }

    @Override
    public void push(DiscoveryResponse response, WatchedStatus watchedStatus) {
        if (Loggers.MAIN.isDebugEnabled()) {
            Loggers.MAIN.debug("discoveryResponse: {}", (Object)response.toString());
        }
        this.streamObserver.onNext((Object)response);
        watchedStatus.setLatestVersion(response.getVersionInfo());
        watchedStatus.setLatestNonce(response.getNonce());
        Loggers.MAIN.info("xds: push, type: {}, connection-id {}, version {}, nonce {}, resource size {}.", new Object[]{watchedStatus.getType(), this.getConnectionId(), response.getVersionInfo(), response.getNonce(), response.getResourcesCount()});
    }
}

