/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.executor.ExecutorFactory;
import com.alibaba.nacos.common.executor.NameThreadFactory;
import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.consistency.persistent.ClusterVersionJudgement;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeerSet;
import com.alibaba.nacos.naming.core.ServiceManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.core.v2.upgrade.SelfUpgradeChecker;
import com.alibaba.nacos.naming.core.v2.upgrade.SelfUpgradeCheckerSpiHolder;
import com.alibaba.nacos.naming.core.v2.upgrade.UpgradeStates;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.RefreshStorageDataTask;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute.AsyncServicesCheckTask;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NamingExecuteTaskDispatcher;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.util.VersionUtil;
import org.springframework.stereotype.Component;

@Component
public class UpgradeJudgement
extends Subscriber<MembersChangeEvent> {
    private final AtomicBoolean useGrpcFeatures = new AtomicBoolean(false);
    private final AtomicBoolean useJraftFeatures = new AtomicBoolean(false);
    private final AtomicBoolean all20XVersion = new AtomicBoolean(false);
    private final RaftPeerSet raftPeerSet;
    private final RaftCore raftCore;
    private final ClusterVersionJudgement versionJudgement;
    private final ServerMemberManager memberManager;
    private final ServiceManager serviceManager;
    private final DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine;
    private ScheduledExecutorService upgradeChecker;
    private SelfUpgradeChecker selfUpgradeChecker;
    private static final int MAJOR_VERSION = 2;
    private static final int MINOR_VERSION = 4;

    public UpgradeJudgement(RaftPeerSet raftPeerSet, RaftCore raftCore, ClusterVersionJudgement versionJudgement, ServerMemberManager memberManager, ServiceManager serviceManager, UpgradeStates upgradeStates, DoubleWriteDelayTaskEngine doubleWriteDelayTaskEngine) {
        this.raftPeerSet = raftPeerSet;
        this.raftCore = raftCore;
        this.versionJudgement = versionJudgement;
        this.memberManager = memberManager;
        this.serviceManager = serviceManager;
        this.doubleWriteDelayTaskEngine = doubleWriteDelayTaskEngine;
        Boolean upgraded = upgradeStates.isUpgraded();
        upgraded = upgraded != null && upgraded != false;
        boolean isStandaloneMode = EnvUtil.getStandaloneMode();
        if (isStandaloneMode || upgraded.booleanValue()) {
            this.useGrpcFeatures.set(true);
            this.useJraftFeatures.set(true);
            this.all20XVersion.set(true);
        }
        if (!isStandaloneMode) {
            this.initUpgradeChecker();
        }
        NotifyCenter.registerSubscriber((Subscriber)this);
    }

    private void initUpgradeChecker() {
        this.selfUpgradeChecker = SelfUpgradeCheckerSpiHolder.findSelfChecker(EnvUtil.getProperty((String)"upgrading.checker.type", (String)"default"));
        this.upgradeChecker = ExecutorFactory.newSingleScheduledExecutorService((ThreadFactory)new NameThreadFactory("upgrading.checker"));
        this.upgradeChecker.scheduleAtFixedRate(() -> {
            if (this.isUseGrpcFeatures()) {
                return;
            }
            boolean canUpgrade = this.checkForUpgrade();
            Loggers.SRV_LOG.info("upgrade check result {}", (Object)canUpgrade);
            if (canUpgrade) {
                this.doUpgrade();
            }
        }, 100L, 5000L, TimeUnit.MILLISECONDS);
    }

    @JustForTest
    void setUseGrpcFeatures(boolean value) {
        this.useGrpcFeatures.set(value);
    }

    @JustForTest
    void setUseJraftFeatures(boolean value) {
        this.useJraftFeatures.set(value);
    }

    public boolean isUseGrpcFeatures() {
        return this.useGrpcFeatures.get();
    }

    public boolean isUseJraftFeatures() {
        return this.useJraftFeatures.get();
    }

    public boolean isAll20XVersion() {
        return this.all20XVersion.get();
    }

    public void onEvent(MembersChangeEvent event) {
        if (!event.hasTriggers()) {
            Loggers.SRV_LOG.info("Member change without no trigger. It may be triggered by member lookup on startup. Skip.");
            return;
        }
        Loggers.SRV_LOG.info("member change, event: {}", (Object)event);
        for (Member each : event.getTriggers()) {
            Object versionStr = each.getExtendVal("version");
            if (null == versionStr) {
                this.checkAndDowngrade(false);
                this.all20XVersion.set(false);
                return;
            }
            Version version = VersionUtil.parseVersion((String)versionStr.toString());
            if (version.getMajorVersion() >= 2) continue;
            this.checkAndDowngrade(version.getMinorVersion() >= 4);
            this.all20XVersion.set(false);
            return;
        }
        this.all20XVersion.set(true);
    }

    private void checkAndDowngrade(boolean jraftFeature) {
        boolean isDowngradeGrpc = this.useGrpcFeatures.compareAndSet(true, false);
        boolean isDowngradeJraft = this.useJraftFeatures.getAndSet(jraftFeature);
        if (isDowngradeGrpc && isDowngradeJraft && !jraftFeature) {
            Loggers.SRV_LOG.info("Downgrade to 1.X");
            NotifyCenter.publishEvent((Event)new UpgradeStates.UpgradeStateChangedEvent(false));
            try {
                this.raftPeerSet.init();
                this.raftCore.init();
                this.versionJudgement.reset();
            }
            catch (Exception e) {
                Loggers.SRV_LOG.error("Downgrade rafe failed ", (Throwable)e);
            }
        }
    }

    private boolean checkForUpgrade() {
        if (!this.useGrpcFeatures.get()) {
            boolean selfCheckResult = this.selfUpgradeChecker.isReadyToUpgrade(this.serviceManager, this.doubleWriteDelayTaskEngine);
            Member self = this.memberManager.getSelf();
            self.setExtendVal("readyToUpgrade", (Object)selfCheckResult);
            this.memberManager.updateMember(self);
            if (!selfCheckResult) {
                NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(AsyncServicesCheckTask.class, new AsyncServicesCheckTask(this.doubleWriteDelayTaskEngine, this));
            }
        }
        boolean result = true;
        for (Member each : this.memberManager.allMembers()) {
            Object isReadyToUpgrade = each.getExtendVal("readyToUpgrade");
            result &= null != isReadyToUpgrade && (Boolean)isReadyToUpgrade != false;
        }
        return result;
    }

    private void doUpgrade() {
        Loggers.SRV_LOG.info("Upgrade to 2.0.X");
        this.useGrpcFeatures.compareAndSet(false, true);
        NotifyCenter.publishEvent((Event)new UpgradeStates.UpgradeStateChangedEvent(true));
        this.useJraftFeatures.set(true);
        this.refreshPersistentServices();
    }

    private void refreshPersistentServices() {
        for (String each : com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().getAllNamespaces()) {
            for (Service service : com.alibaba.nacos.naming.core.v2.ServiceManager.getInstance().getSingletons(each)) {
                NamingExecuteTaskDispatcher.getInstance().dispatchAndExecuteTask(service, new RefreshStorageDataTask(service));
            }
        }
    }

    public Class<? extends Event> subscribeType() {
        return MembersChangeEvent.class;
    }

    @PreDestroy
    public void shutdown() {
        if (null != this.upgradeChecker) {
            this.upgradeChecker.shutdownNow();
        }
    }

    public void stopAll() {
        try {
            Loggers.SRV_LOG.info("Disable Double write, stop and clean v1.x cache and features");
            this.useGrpcFeatures.set(true);
            NotifyCenter.publishEvent((Event)new UpgradeStates.UpgradeStateChangedEvent(true));
            this.useJraftFeatures.set(true);
            NotifyCenter.deregisterSubscriber((Subscriber)this);
            this.doubleWriteDelayTaskEngine.shutdown();
            if (null != this.upgradeChecker) {
                this.upgradeChecker.shutdownNow();
            }
            this.serviceManager.shutdown();
            this.raftCore.shutdown();
        }
        catch (NacosException e) {
            Loggers.SRV_LOG.info("Close double write with exception", (Throwable)e);
        }
    }
}

