/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.remote.rpc.handler;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.remote.request.ServiceListRequest;
import com.alibaba.nacos.api.naming.remote.response.ServiceListResponse;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.naming.core.v2.ServiceManager;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.utils.ServiceUtil;
import com.alibaba.nacos.naming.web.NamingResourceParser;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class ServiceListRequestHandler
extends RequestHandler<ServiceListRequest, ServiceListResponse> {
    @Secured(action=ActionTypes.READ, parser=NamingResourceParser.class)
    public ServiceListResponse handle(ServiceListRequest request, RequestMeta meta) throws NacosException {
        Set<Service> serviceSet = ServiceManager.getInstance().getSingletons(request.getNamespace());
        ServiceListResponse result = ServiceListResponse.buildSuccessResponse((int)0, new LinkedList());
        if (!serviceSet.isEmpty()) {
            Collection<String> serviceNameSet = this.selectServiceWithGroupName(serviceSet, request.getGroupName());
            List<String> serviceNameList = ServiceUtil.pageServiceName(request.getPageNo(), request.getPageSize(), serviceNameSet);
            result.setCount(serviceNameList.size());
            result.setServiceNames(serviceNameList);
        }
        return result;
    }

    private Collection<String> selectServiceWithGroupName(Collection<Service> serviceSet, String groupName) {
        HashSet<String> result = new HashSet<String>(serviceSet.size());
        for (Service each : serviceSet) {
            if (!Objects.equals(groupName, each.getGroup())) continue;
            result.add(each.getGroupedServiceName());
        }
        return result;
    }
}

