/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.selector;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.selector.Selector;
import com.alibaba.nacos.api.selector.context.SelectorContextBuilder;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.naming.misc.Loggers;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class SelectorManager {
    private Map<String, SelectorContextBuilder> contextBuilders = new HashMap<String, SelectorContextBuilder>(8);
    private Map<String, Class<? extends Selector>> selectorTypes = new HashMap<String, Class<? extends Selector>>(8);

    @PostConstruct
    public void init() {
        this.initSelectorContextBuilders();
        this.initSelectorTypes();
    }

    private void initSelectorContextBuilders() {
        Collection selectorContextBuilders = NacosServiceLoader.load(SelectorContextBuilder.class);
        for (SelectorContextBuilder selectorContextBuilder : selectorContextBuilders) {
            if (this.contextBuilders.containsKey(selectorContextBuilder.getContextType())) {
                Loggers.SRV_LOG.warn("[SelectorManager] init selectorContextBuilders, SelectorContextBuilder type {} has value, ignore it.", (Object)selectorContextBuilder.getContextType());
                continue;
            }
            this.contextBuilders.put(selectorContextBuilder.getContextType(), selectorContextBuilder);
            Loggers.SRV_LOG.info("[SelectorManager] Load SelectorContextBuilder({}) contextType({}) successfully.", selectorContextBuilder.getClass(), (Object)selectorContextBuilder.getContextType());
        }
    }

    private void initSelectorTypes() {
        Collection selectors = NacosServiceLoader.load(Selector.class);
        for (Selector selector : selectors) {
            if (this.selectorTypes.containsKey(selector.getType())) {
                Loggers.SRV_LOG.warn("[SelectorManager] init Selectors, Selector type {} has value, ignore it.", (Object)selector.getType());
                continue;
            }
            Class<?> selectorClass = selector.getClass();
            try {
                Constructor<?> constructor = selectorClass.getConstructor(new Class[0]);
                if (Objects.isNull(constructor)) {
                    throw new NoSuchMethodException();
                }
                JacksonUtils.registerSubtype(selectorClass, (String)selector.getType());
                this.selectorTypes.put(selector.getType(), selectorClass);
                Loggers.SRV_LOG.info("[SelectorManager] Load Selector({}) type({}) contextType({}) successfully.", new Object[]{selectorClass, selector.getType(), selector.getContextType()});
            }
            catch (Exception e) {
                Loggers.SRV_LOG.warn("[SelectorManager] Selector {} cannot find public access default constructor, will be ignored.", selectorClass);
            }
        }
    }

    public List<String> getAllSelectorTypes() {
        return new ArrayList<String>(this.selectorTypes.keySet());
    }

    public Selector parseSelector(String type, String condition) throws NacosException {
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        Class<? extends Selector> clazz = this.selectorTypes.get(type);
        if (Objects.isNull(clazz)) {
            return null;
        }
        try {
            Selector selector = clazz.newInstance();
            selector.parse((Object)condition);
            return selector;
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[SelectorManager] Parse Selector failed, type: {}, condition: {}.", new Object[]{type, condition, e});
            throw new NacosException(500, "Selector parses failed: " + e.getMessage());
        }
    }

    public <T extends Instance> List<T> select(Selector selector, String consumerIp, List<T> providers) {
        if (Objects.isNull(selector)) {
            return providers;
        }
        SelectorContextBuilder selectorContextBuilder = this.contextBuilders.get(selector.getContextType());
        if (Objects.isNull(selectorContextBuilder)) {
            Loggers.SRV_LOG.info("[SelectorManager] cannot find the contextBuilder of type {}.", (Object)selector.getType());
            return providers;
        }
        try {
            Object context = selectorContextBuilder.build((Object)consumerIp, providers);
            return (List)selector.select(context);
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("[SelectorManager] execute select failed, will return all providers.", (Throwable)e);
            return providers;
        }
    }
}

