/*
 * Decompiled with CFR 0.152.
 */
package brave.propagation;

import brave.internal.HexCodec;
import brave.internal.Nullable;
import brave.internal.Platform;
import brave.propagation.SamplingFlags;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import java.util.Collections;

public final class B3SingleFormat {
    static final int FORMAT_MAX_LENGTH = 68;
    static final ThreadLocal<char[]> CHAR_BUFFER = new ThreadLocal();

    public static String writeB3SingleFormatWithoutParentId(TraceContext context) {
        char[] buffer = B3SingleFormat.getCharBuffer();
        int length = B3SingleFormat.writeB3SingleFormat(context, 0L, buffer);
        return new String(buffer, 0, length);
    }

    public static byte[] writeB3SingleFormatWithoutParentIdAsBytes(TraceContext context) {
        char[] buffer = B3SingleFormat.getCharBuffer();
        int length = B3SingleFormat.writeB3SingleFormat(context, 0L, buffer);
        return B3SingleFormat.asciiToNewByteArray(buffer, length);
    }

    public static String writeB3SingleFormat(TraceContext context) {
        char[] buffer = B3SingleFormat.getCharBuffer();
        int length = B3SingleFormat.writeB3SingleFormat(context, context.parentIdAsLong(), buffer);
        return new String(buffer, 0, length);
    }

    public static byte[] writeB3SingleFormatAsBytes(TraceContext context) {
        char[] buffer = B3SingleFormat.getCharBuffer();
        int length = B3SingleFormat.writeB3SingleFormat(context, context.parentIdAsLong(), buffer);
        return B3SingleFormat.asciiToNewByteArray(buffer, length);
    }

    static int writeB3SingleFormat(TraceContext context, long parentId, char[] result) {
        int pos = 0;
        long traceIdHigh = context.traceIdHigh();
        if (traceIdHigh != 0L) {
            HexCodec.writeHexLong(result, pos, traceIdHigh);
            pos += 16;
        }
        HexCodec.writeHexLong(result, pos, context.traceId());
        pos += 16;
        result[pos++] = 45;
        HexCodec.writeHexLong(result, pos, context.spanId());
        pos += 16;
        Boolean sampled = context.sampled();
        if (sampled != null) {
            result[pos++] = 45;
            int n = context.debug() ? 100 : (result[pos++] = sampled != false ? 49 : 48);
        }
        if (parentId != 0L) {
            result[pos++] = 45;
            HexCodec.writeHexLong(result, pos, parentId);
            pos += 16;
        }
        return pos;
    }

    @Nullable
    public static TraceContextOrSamplingFlags parseB3SingleFormat(CharSequence b3) {
        return B3SingleFormat.parseB3SingleFormat(b3, 0, b3.length());
    }

    @Nullable
    public static TraceContextOrSamplingFlags parseB3SingleFormat(CharSequence b3, int beginIndex, int endIndex) {
        long traceId;
        long traceIdHigh;
        if (beginIndex == endIndex) {
            Platform.get().log("Invalid input: empty", null);
            return null;
        }
        int pos = beginIndex;
        if (pos + 1 == endIndex) {
            return B3SingleFormat.tryParseSamplingFlags(b3, pos);
        }
        if (endIndex < 33) {
            Platform.get().log("Invalid input: truncated", null);
            return null;
        }
        if (endIndex > 68) {
            Platform.get().log("Invalid input: too long", null);
            return null;
        }
        if (b3.charAt(pos + 32) == '-') {
            traceIdHigh = B3SingleFormat.tryParse16HexCharacters(b3, pos, endIndex);
            traceId = B3SingleFormat.tryParse16HexCharacters(b3, pos += 16, endIndex);
        } else {
            traceIdHigh = 0L;
            traceId = B3SingleFormat.tryParse16HexCharacters(b3, pos, endIndex);
        }
        pos += 16;
        if (!B3SingleFormat.checkHyphen(b3, pos++)) {
            return null;
        }
        if (traceIdHigh == 0L && traceId == 0L) {
            Platform.get().log("Invalid input: expected a 16 or 32 lower hex trace ID at offset 0", null);
            return null;
        }
        long spanId = B3SingleFormat.tryParse16HexCharacters(b3, pos, endIndex);
        if (spanId == 0L) {
            Platform.get().log("Invalid input: expected a 16 lower hex span ID at offset {0}", pos, null);
            return null;
        }
        int flags = 0;
        long parentId = 0L;
        if (endIndex > (pos += 16)) {
            if (endIndex == pos + 1) {
                Platform.get().log("Invalid input: truncated", null);
                return null;
            }
            if (!B3SingleFormat.checkHyphen(b3, pos++)) {
                return null;
            }
            if (endIndex == pos + 1 || B3SingleFormat.delimiterFollowsPos(b3, pos, endIndex)) {
                flags = B3SingleFormat.parseFlags(b3, pos);
                if (flags == 0) {
                    return null;
                }
                ++pos;
            }
            if (endIndex > pos) {
                if (endIndex != pos + 17) {
                    Platform.get().log("Invalid input: truncated", null);
                    return null;
                }
                if (!B3SingleFormat.checkHyphen(b3, pos++)) {
                    return null;
                }
                parentId = B3SingleFormat.tryParse16HexCharacters(b3, pos, endIndex);
                if (parentId == 0L) {
                    Platform.get().log("Invalid input: expected a 16 lower hex parent ID at offset {0}", pos, null);
                    return null;
                }
            }
        }
        return TraceContextOrSamplingFlags.create(new TraceContext(flags, traceIdHigh, traceId, parentId, spanId, Collections.<Object>emptyList()));
    }

    static TraceContextOrSamplingFlags tryParseSamplingFlags(CharSequence b3, int pos) {
        int flags = B3SingleFormat.parseFlags(b3, pos);
        if (flags == 0) {
            return null;
        }
        return TraceContextOrSamplingFlags.create(SamplingFlags.toSamplingFlags(flags));
    }

    static boolean checkHyphen(CharSequence b3, int pos) {
        if (b3.charAt(pos) == '-') {
            return true;
        }
        Platform.get().log("Invalid input: expected a hyphen(-) delimiter offset {0}", pos, null);
        return false;
    }

    static boolean delimiterFollowsPos(CharSequence b3, int pos, int end) {
        return end >= pos + 2 && b3.charAt(pos + 1) == '-';
    }

    static long tryParse16HexCharacters(CharSequence lowerHex, int index, int end) {
        int endIndex = index + 16;
        if (endIndex > end) {
            return 0L;
        }
        return HexCodec.lenientLowerHexToUnsignedLong(lowerHex, index, endIndex);
    }

    static int parseFlags(CharSequence b3, int pos) {
        int flags;
        char sampledChar = b3.charAt(pos);
        if (sampledChar == 'd') {
            flags = 14;
        } else if (sampledChar == '1') {
            flags = 6;
        } else if (sampledChar == '0') {
            flags = 4;
        } else {
            B3SingleFormat.logInvalidSampled(pos);
            flags = 0;
        }
        return flags;
    }

    static void logInvalidSampled(int pos) {
        Platform.get().log("Invalid input: expected 0, 1 or d for sampled at offset {0}", pos, null);
    }

    static byte[] asciiToNewByteArray(char[] buffer, int length) {
        byte[] result = new byte[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (byte)buffer[i];
        }
        return result;
    }

    static char[] getCharBuffer() {
        char[] charBuffer = CHAR_BUFFER.get();
        if (charBuffer == null) {
            charBuffer = new char[68];
            CHAR_BUFFER.set(charBuffer);
        }
        return charBuffer;
    }

    B3SingleFormat() {
    }
}

