/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.Span;
import zipkin.internal.CorrectForClockSkew;
import zipkin.internal.GroupByTraceId;
import zipkin.internal.MergeById;
import zipkin.internal.Nullable;
import zipkin.internal.Util;
import zipkin.internal.V2CallbackAdapter;
import zipkin.internal.V2SpanConverter;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$1;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$2;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$3;
import zipkin.internal.V2SpanStoreAdapter$$Lambda$4;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.Callback;
import zipkin.storage.QueryRequest;
import zipkin2.Call;
import zipkin2.internal.Platform;
import zipkin2.storage.SpanStore;

final class V2SpanStoreAdapter
implements zipkin.storage.SpanStore,
AsyncSpanStore {
    final SpanStore delegate;
    static final Call.Mapper<List<List<zipkin2.Span>>, List<List<Span>>> getTracesMapper = V2SpanStoreAdapter$$Lambda$2.lambdaFactory$();
    static final Call.Mapper<List<zipkin2.Span>, List<Span>> getTraceMapper = V2SpanStoreAdapter$$Lambda$3.lambdaFactory$();
    static final Call.Mapper<List<zipkin2.Span>, List<Span>> getRawTraceMapper = V2SpanStoreAdapter$$Lambda$4.lambdaFactory$();

    V2SpanStoreAdapter(SpanStore delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<List<Span>> getTraces(QueryRequest request) {
        try {
            return this.getTracesCall(request).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getTraces(QueryRequest request, Callback<List<List<Span>>> callback) {
        this.getTracesCall(request).enqueue(new V2CallbackAdapter<List<List<Span>>>(callback));
    }

    Call<List<List<Span>>> getTracesCall(QueryRequest v1Request) {
        return this.delegate.getTraces(V2SpanStoreAdapter.convertRequest(v1Request)).map(getTracesMapper);
    }

    @Override
    @Nullable
    public List<Span> getTrace(long traceIdHigh, long traceIdLow) {
        try {
            return this.getTraceCall(traceIdHigh, traceIdLow).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        this.getTraceCall(traceIdHigh, traceIdLow).enqueue(new V2CallbackAdapter<List<Span>>(callback));
    }

    Call<List<Span>> getTraceCall(long traceIdHigh, long traceIdLow) {
        return this.delegate.getTrace(Util.toLowerHex(traceIdHigh, traceIdLow)).map(getTraceMapper);
    }

    @Override
    @Nullable
    public List<Span> getRawTrace(long traceIdHigh, long traceIdLow) {
        try {
            return this.getRawTraceCall(traceIdHigh, traceIdLow).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getRawTrace(long traceIdHigh, long traceIdLow, Callback<List<Span>> callback) {
        this.getRawTraceCall(traceIdHigh, traceIdLow).enqueue(new V2CallbackAdapter<List<Span>>(callback));
    }

    Call<List<Span>> getRawTraceCall(long traceIdHigh, long traceIdLow) {
        return this.delegate.getTrace(Util.toLowerHex(traceIdHigh, traceIdLow)).map(getRawTraceMapper);
    }

    @Override
    public List<String> getServiceNames() {
        try {
            return Util.sortedList((Collection)this.delegate.getServiceNames().execute());
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getServiceNames(Callback<List<String>> callback) {
        this.delegate.getServiceNames().enqueue(new V2CallbackAdapter<List<String>>(callback));
    }

    @Override
    public List<String> getSpanNames(String serviceName) {
        try {
            return Util.sortedList((Collection)this.delegate.getSpanNames(serviceName).execute());
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getSpanNames(String serviceName, Callback<List<String>> callback) {
        this.delegate.getSpanNames(serviceName).enqueue(new V2CallbackAdapter<List<String>>(callback));
    }

    @Override
    public List<DependencyLink> getDependencies(long endTs, @Nullable Long lookback) {
        try {
            return this.getDependenciesCall(endTs, lookback).execute();
        }
        catch (IOException e) {
            throw Platform.get().uncheckedIOException(e);
        }
    }

    @Override
    public void getDependencies(long endTs, @Nullable Long lookback, Callback<List<DependencyLink>> callback) {
        this.getDependenciesCall(endTs, lookback).enqueue(new V2CallbackAdapter<List<DependencyLink>>(callback));
    }

    Call<List<DependencyLink>> getDependenciesCall(long endTs, @Nullable Long lookback) {
        return this.delegate.getDependencies(endTs, lookback != null ? lookback : endTs).map(V2SpanStoreAdapter$$Lambda$1.lambdaFactory$());
    }

    @Override
    @Nullable
    public List<Span> getTrace(long traceId) {
        return this.getTrace(0L, traceId);
    }

    @Override
    public void getTrace(long id, Callback<List<Span>> callback) {
        this.getTrace(0L, id, callback);
    }

    @Override
    @Nullable
    public List<Span> getRawTrace(long traceId) {
        return this.getRawTrace(0L, traceId);
    }

    @Override
    public void getRawTrace(long traceId, Callback<List<Span>> callback) {
        this.getRawTrace(0L, traceId, callback);
    }

    static zipkin2.storage.QueryRequest convertRequest(QueryRequest v1Request) {
        return zipkin2.storage.QueryRequest.newBuilder().serviceName(v1Request.serviceName).spanName(v1Request.spanName).parseAnnotationQuery(v1Request.toAnnotationQuery()).minDuration(v1Request.minDuration).maxDuration(v1Request.maxDuration).endTs(v1Request.endTs).lookback(v1Request.lookback).limit(v1Request.limit).build();
    }

    static /* synthetic */ List lambda$static$2(List spans) {
        List<Span> span1s = V2SpanConverter.toSpans(spans);
        return span1s.isEmpty() ? null : span1s;
    }

    static /* synthetic */ List lambda$static$1(List spans) {
        List<Span> span1s = CorrectForClockSkew.apply(MergeById.apply(V2SpanConverter.toSpans(spans)));
        return span1s.isEmpty() ? null : span1s;
    }

    static /* synthetic */ List lambda$static$0(List trace2s) {
        if (trace2s.isEmpty()) {
            return Collections.emptyList();
        }
        int length = trace2s.size();
        ArrayList<List<Span>> trace1s = new ArrayList<List<Span>>(length);
        for (int i = 0; i < length; ++i) {
            trace1s.add(CorrectForClockSkew.apply(MergeById.apply(V2SpanConverter.toSpans((List)trace2s.get(i)))));
        }
        Collections.sort(trace1s, GroupByTraceId.TRACE_DESCENDING);
        return trace1s;
    }
}

