/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import zipkin.Component;
import zipkin.internal.LenientDoubleCallbackAsyncSpanStore;
import zipkin.internal.Nullable;
import zipkin.internal.V2SpanConsumerAdapter;
import zipkin.internal.V2SpanStoreAdapter;
import zipkin.storage.AsyncSpanConsumer;
import zipkin.storage.AsyncSpanStore;
import zipkin.storage.SpanStore;
import zipkin.storage.StorageAdapters;
import zipkin2.CheckResult;
import zipkin2.storage.StorageComponent;

public abstract class V2StorageComponent
implements zipkin.storage.StorageComponent {
    public static V2StorageComponent create(final StorageComponent delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        final LegacySpanStoreProvider legacyProvider = delegate instanceof LegacySpanStoreProvider ? (LegacySpanStoreProvider)((Object)delegate) : null;
        return new V2StorageComponent(){

            @Override
            protected LegacySpanStoreProvider legacyProvider() {
                return legacyProvider;
            }

            @Override
            public StorageComponent delegate() {
                return delegate;
            }
        };
    }

    protected abstract LegacySpanStoreProvider legacyProvider();

    public abstract StorageComponent delegate();

    @Override
    public SpanStore spanStore() {
        AsyncSpanStore legacy;
        AsyncSpanStore asyncSpanStore = legacy = this.legacyProvider() != null ? this.legacyProvider().legacyAsyncSpanStore() : null;
        if (legacy != null) {
            return StorageAdapters.asyncToBlocking(this.asyncSpanStore());
        }
        return new V2SpanStoreAdapter(this.delegate().spanStore());
    }

    @Override
    public AsyncSpanStore asyncSpanStore() {
        AsyncSpanStore legacy;
        V2SpanStoreAdapter v2 = new V2SpanStoreAdapter(this.delegate().spanStore());
        AsyncSpanStore asyncSpanStore = legacy = this.legacyProvider() != null ? this.legacyProvider().legacyAsyncSpanStore() : null;
        if (legacy == null) {
            return v2;
        }
        return new LenientDoubleCallbackAsyncSpanStore(v2, legacy);
    }

    @Override
    public final AsyncSpanConsumer asyncSpanConsumer() {
        return new V2SpanConsumerAdapter(this.delegate().spanConsumer());
    }

    @Override
    public Component.CheckResult check() {
        CheckResult result = this.delegate().check();
        return result.ok() ? Component.CheckResult.OK : Component.CheckResult.failed(result.error() instanceof Exception ? (Exception)result.error() : new ExecutionException(result.error()));
    }

    @Override
    public void close() throws IOException {
        this.delegate().close();
    }

    public String toString() {
        return this.delegate().toString();
    }

    public static interface LegacySpanStoreProvider {
        @Nullable
        public AsyncSpanStore legacyAsyncSpanStore();
    }
}

