/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.util.List;
import ma.glasnost.orika.Filter;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;

public class AggregateFilter
implements Filter<Object, Object> {
    private final List<Filter<Object, Object>> filters;
    private final boolean filtersSource;
    private final boolean filtersDestination;

    public AggregateFilter(List<Filter<Object, Object>> filters) {
        this.filters = filters;
        boolean sourceIsFiltered = false;
        boolean destIsFiltered = false;
        for (Filter<Object, Object> filter : filters) {
            if (filter.filtersSource()) {
                sourceIsFiltered = true;
            }
            if (!filter.filtersDestination()) continue;
            destIsFiltered = true;
        }
        this.filtersSource = sourceIsFiltered;
        this.filtersDestination = destIsFiltered;
    }

    @Override
    public Type<Object> getAType() {
        return TypeFactory.TYPE_OF_OBJECT;
    }

    @Override
    public Type<Object> getBType() {
        return TypeFactory.TYPE_OF_OBJECT;
    }

    @Override
    public boolean appliesTo(Property source, Property destination) {
        return true;
    }

    @Override
    public boolean filtersSource() {
        return this.filtersSource;
    }

    @Override
    public boolean filtersDestination() {
        return this.filtersDestination;
    }

    @Override
    public <S, D> boolean shouldMap(Type<S> sourceType, String sourceName, S source, Type<D> destType, String destName, D dest, MappingContext mappingContext) {
        boolean shouldMap = true;
        for (Filter<Object, Object> filter : this.filters) {
            if (filter.shouldMap(sourceType, sourceName, source, destType, destName, dest, mappingContext)) continue;
            shouldMap = false;
            break;
        }
        return shouldMap;
    }

    @Override
    public <D> D filterDestination(D destinationValue, Type<?> sourceType, String sourceName, Type<D> destType, String destName, MappingContext mappingContext) {
        D value = destinationValue;
        for (Filter<Object, Object> filter : this.filters) {
            if (!filter.filtersDestination()) continue;
            value = filter.filterDestination(value, sourceType, sourceName, destType, destName, mappingContext);
        }
        return value;
    }

    @Override
    public <S> S filterSource(S sourceValue, Type<S> sourceType, String sourceName, Type<?> destType, String destName, MappingContext mappingContext) {
        S value = sourceValue;
        for (Filter<Object, Object> filter : this.filters) {
            if (!filter.filtersDestination()) continue;
            value = filter.filterSource(value, sourceType, sourceName, destType, destName, mappingContext);
        }
        return value;
    }
}

