/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import ma.glasnost.orika.Converter;
import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MapperFacade;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.MappingContextFactory;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.MappingStrategy;
import ma.glasnost.orika.ObjectFactory;
import ma.glasnost.orika.StateReporter;
import ma.glasnost.orika.converter.ConverterFactory;
import ma.glasnost.orika.impl.ExceptionUtility;
import ma.glasnost.orika.impl.ReversedMapper;
import ma.glasnost.orika.impl.mapping.strategy.MappingStrategyRecorder;
import ma.glasnost.orika.impl.util.ClassUtil;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.unenhance.UnenhanceStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperFacadeImpl
implements MapperFacade,
StateReporter.Reportable {
    protected final MapperFactory mapperFactory;
    private final MappingContextFactory contextFactory;
    protected final UnenhanceStrategy unenhanceStrategy;
    private final UnenhanceStrategy userUnenhanceStrategy;
    private final ConcurrentHashMap<MappingStrategy.Key, MappingStrategy> strategyCache = new ConcurrentHashMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ExceptionUtility exceptionUtil;

    public MapperFacadeImpl(MapperFactory mapperFactory, MappingContextFactory contextFactory, UnenhanceStrategy unenhanceStrategy, ExceptionUtility exceptionUtil) {
        this.mapperFactory = mapperFactory;
        this.exceptionUtil = exceptionUtil;
        this.unenhanceStrategy = unenhanceStrategy;
        this.userUnenhanceStrategy = mapperFactory.getUserUnenhanceStrategy();
        this.contextFactory = contextFactory;
    }

    private <S, D> Type<S> normalizeSourceType(S sourceObject, Type<S> sourceType, Type<D> destinationType) {
        Type<S> resolvedType;
        if (sourceType != null) {
            if (destinationType != null && (this.canCopyByReference(destinationType, sourceType) || this.canConvert(sourceType, destinationType))) {
                resolvedType = sourceType;
            } else {
                if (sourceType.isAssignableFrom(sourceObject.getClass())) {
                    sourceType = TypeFactory.valueOf(sourceObject.getClass());
                }
                resolvedType = sourceType.isConcrete() ? this.unenhanceStrategy.unenhanceType(sourceObject, sourceType) : this.unenhanceStrategy.unenhanceType(sourceObject, this.resolveTypeOf(sourceObject, sourceType));
            }
        } else {
            resolvedType = this.unenhanceStrategy.unenhanceType(sourceObject, this.typeOf(sourceObject));
        }
        return resolvedType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D map(S sourceObject, Type<S> sourceType, Type<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D d = this.map(sourceObject, sourceType, destinationClass, context);
            return d;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    protected Class<?> getClass(Object object) {
        if (this.userUnenhanceStrategy == null) {
            return object.getClass();
        }
        return this.userUnenhanceStrategy.unenhanceObject(object, TypeFactory.TYPE_OF_OBJECT).getClass();
    }

    @Override
    public <S, D> MappingStrategy resolveMappingStrategy(S sourceObject, java.lang.reflect.Type initialSourceType, java.lang.reflect.Type initialDestinationType, boolean mapInPlace, MappingContext context) {
        MappingStrategy.Key key = new MappingStrategy.Key(this.getClass(sourceObject), initialSourceType, initialDestinationType, mapInPlace);
        MappingStrategy strategy = this.strategyCache.get(key);
        if (strategy == null) {
            MappingStrategy existing;
            Type<Object> sourceType = initialSourceType != null ? TypeFactory.valueOf(initialSourceType) : this.typeOf(sourceObject);
            Type destinationType = TypeFactory.valueOf(initialDestinationType);
            MappingStrategyRecorder strategyRecorder = new MappingStrategyRecorder(key, this.unenhanceStrategy);
            Type<S> resolvedSourceType = this.normalizeSourceType(sourceObject, sourceType, destinationType);
            strategyRecorder.setResolvedSourceType(resolvedSourceType);
            strategyRecorder.setResolvedDestinationType(destinationType);
            if (!mapInPlace && this.canCopyByReference(destinationType, resolvedSourceType)) {
                strategyRecorder.setCopyByReference(true);
            } else if (!mapInPlace && this.canConvert(resolvedSourceType, destinationType)) {
                strategyRecorder.setResolvedConverter(this.mapperFactory.getConverterFactory().getConverter(resolvedSourceType, destinationType));
            } else {
                strategyRecorder.setInstantiate(true);
                Type resolvedDestinationType = this.resolveDestinationType(context, sourceType, destinationType, resolvedSourceType);
                strategyRecorder.setResolvedDestinationType(resolvedDestinationType);
                strategyRecorder.setResolvedMapper(this.resolveMapper(resolvedSourceType, resolvedDestinationType, context));
                if (!mapInPlace) {
                    strategyRecorder.setResolvedObjectFactory(this.mapperFactory.lookupObjectFactory(resolvedDestinationType, resolvedSourceType, context));
                }
            }
            strategy = strategyRecorder.playback();
            if (this.log.isDebugEnabled()) {
                this.log.debug(strategyRecorder.describeDetails());
            }
            if ((existing = this.strategyCache.putIfAbsent(key, strategy)) != null) {
                strategy = existing;
            }
        }
        context.setResolvedSourceType(strategy.getAType());
        context.setResolvedDestinationType(strategy.getBType());
        context.setResolvedStrategy(strategy);
        return strategy;
    }

    private <S, D> Type<? extends D> resolveDestinationType(MappingContext context, Type<S> sourceType, Type<D> destinationType, Type<S> resolvedSourceType) {
        Type<Object> resolvedDestinationType = this.mapperFactory.lookupConcreteDestinationType(resolvedSourceType, destinationType, context);
        if (resolvedDestinationType == null) {
            if (destinationType.isAssignableFrom(sourceType)) {
                resolvedDestinationType = resolvedSourceType;
            } else {
                if (!destinationType.isConcrete()) {
                    MappingException e = new MappingException("No concrete class mapping defined for source class " + resolvedSourceType.getName());
                    e.setDestinationType(destinationType);
                    e.setSourceType(resolvedSourceType);
                    throw this.exceptionUtil.decorate(e);
                }
                resolvedDestinationType = destinationType;
            }
        }
        return resolvedDestinationType;
    }

    @Override
    public <S, D> D map(S sourceObject, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        return this.map(sourceObject, sourceType, destinationType, context, null);
    }

    public <S, D> D map(S sourceObject, Type<S> sourceType, Type<D> destinationType, MappingContext context, MappingStrategy suggestedStrategy) {
        MappingStrategy strategy = suggestedStrategy;
        try {
            if (destinationType == null) {
                throw new MappingException("Can not map to a null class.");
            }
            if (sourceObject == null) {
                return null;
            }
            Object existingResult = context.getMappedObject(sourceObject, destinationType);
            if (existingResult == null) {
                if (strategy == null) {
                    strategy = this.resolveMappingStrategy(sourceObject, sourceType, destinationType, false, context);
                }
                if (strategy.getBType() != null && !strategy.getBType().equals(destinationType)) {
                    existingResult = context.getMappedObject(sourceObject, strategy.getBType());
                    if (existingResult == null) {
                        existingResult = strategy.map(sourceObject, null, context);
                    }
                } else {
                    existingResult = strategy.map(sourceObject, null, context);
                }
            }
            return existingResult;
        }
        catch (MappingException e) {
            throw this.exceptionUtil.decorate(e);
        }
        catch (RuntimeException e) {
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            MappingException me = this.exceptionUtil.newMappingException(e);
            me.setSourceClass(sourceObject.getClass());
            me.setSourceType(sourceType);
            me.setDestinationType(destinationType);
            me.setMappingStrategy(strategy);
            throw me;
        }
    }

    private <D, S> boolean canCopyByReference(Type<D> destinationType, Type<S> resolvedSourceType) {
        if (resolvedSourceType.isImmutable() && destinationType.isAssignableFrom(resolvedSourceType)) {
            return true;
        }
        if (resolvedSourceType.isPrimitiveWrapper() && resolvedSourceType.getRawType().equals(ClassUtil.getWrapperType(destinationType.getRawType()))) {
            return true;
        }
        return resolvedSourceType.isPrimitive() && destinationType.getRawType().equals(ClassUtil.getWrapperType(resolvedSourceType.getRawType()));
    }

    @Override
    public <S, D> void map(S sourceObject, D destinationObject, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        this.map(sourceObject, destinationObject, sourceType, destinationType, context, null);
    }

    private <S, D> void map(S sourceObject, D destinationObject, Type<S> sourceType, Type<D> destinationType, MappingContext context, MappingStrategy suggestedStrategy) {
        MappingStrategy strategy = suggestedStrategy;
        try {
            if (context.getMappedObject(sourceObject, destinationType) == null) {
                if (strategy == null) {
                    strategy = this.resolveMappingStrategy(sourceObject, sourceType, destinationType, true, context);
                }
                strategy.map(sourceObject, destinationObject, context);
            }
        }
        catch (MappingException e) {
            throw this.exceptionUtil.decorate(e);
        }
        catch (RuntimeException e) {
            if (destinationObject == null) {
                throw new MappingException("[destinationObject] can not be null.");
            }
            if (destinationType == null) {
                throw new MappingException("[destinationType] can not be null.");
            }
            if (sourceObject == null) {
                throw new MappingException("[sourceObject] can not be null.");
            }
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            MappingException me = this.exceptionUtil.newMappingException(e);
            me.setSourceClass(sourceObject.getClass());
            me.setSourceType(sourceType);
            me.setDestinationType(destinationType);
            me.setMappingStrategy(strategy);
            throw me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void map(S sourceObject, D destinationObject, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.map(sourceObject, destinationObject, sourceType, destinationType, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> void map(S sourceObject, D destinationObject, MappingContext context) {
        this.map(sourceObject, destinationObject, context, null);
    }

    private <S, D> void map(S sourceObject, D destinationObject, MappingContext context, MappingStrategy suggestedStrategy) {
        MappingStrategy strategy = suggestedStrategy;
        try {
            if (strategy == null) {
                strategy = this.resolveMappingStrategy(sourceObject, null, destinationObject.getClass(), true, context);
            }
            strategy.map(sourceObject, destinationObject, context);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (destinationObject == null) {
                throw new MappingException("[destinationObject] can not be null.");
            }
            if (sourceObject == null) {
                throw new MappingException("[sourceObject] can not be null.");
            }
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            MappingException me = this.exceptionUtil.newMappingException(e);
            me.setSourceClass(sourceObject.getClass());
            me.setDestinationType(TypeFactory.valueOf(destinationObject.getClass()));
            me.setMappingStrategy(strategy);
            throw me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void map(S sourceObject, D destinationObject) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.map(sourceObject, destinationObject, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S, D> Set<D> mapAsSet(Iterable<S> source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Set<D> set = this.mapAsSet(source, sourceType, destinationType, context);
            return set;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public final <S, D> Set<D> mapAsSet(Iterable<S> source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        return (Set)this.mapAsCollection(source, sourceType, destinationType, new HashSet(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S, D> List<D> mapAsList(Iterable<S> source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            List list = (List)this.mapAsCollection(source, sourceType, destinationType, new ArrayList(), context);
            return list;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public final <S, D> List<D> mapAsList(Iterable<S> source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        return (List)this.mapAsCollection(source, sourceType, destinationType, new ArrayList(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D[] DArray = this.mapAsArray(destination, source, sourceType, destinationType, context);
            return DArray;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D[] DArray = this.mapAsArray(destination, source, sourceType, destinationType, context);
            return DArray;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return null;
        }
        int i = 0;
        ElementStrategyContext<S, D> elementContext = new ElementStrategyContext<S, D>(context, sourceType, destinationType);
        for (S item : source) {
            if (item == null) continue;
            destination[i++] = this.mapElement(item, elementContext);
        }
        return destination;
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return null;
        }
        int i = 0;
        ElementStrategyContext<S, D> elementContext = new ElementStrategyContext<S, D>(context, sourceType, destinationType);
        for (S item : source) {
            if (item == null) continue;
            destination[i++] = this.mapElement(item, elementContext);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> List<D> mapAsList(S[] source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            List<D> list = this.mapAsList(source, sourceType, destinationType, context);
            return list;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> List<D> mapAsList(S[] source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        ArrayList<D> destination = new ArrayList<D>(source.length);
        for (S s : source) {
            destination.add(this.map(s, sourceType, destinationType, context));
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Set<D> set = this.mapAsSet(source, sourceType, destinationType, context);
            return set;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        HashSet<D> destination = new HashSet<D>(source.length);
        for (S s : source) {
            destination.add(this.map(s, sourceType, destinationType, context));
        }
        return destination;
    }

    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return;
        }
        if (destination != null) {
            destination.clear();
            for (S item : source) {
                destination.add(this.map(item, sourceType, destinationType, context));
            }
        }
    }

    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType, MappingContext context) {
        if (source == null) {
            return;
        }
        if (destination != null) {
            destination.clear();
            for (S item : source) {
                destination.add(this.map(item, sourceType, destinationType, context));
            }
        }
    }

    private Mapper<Object, Object> resolveMapper(Type<?> sourceType, Type<?> destinationType, MappingContext context) {
        MapperKey mapperKey = new MapperKey(sourceType, destinationType);
        Mapper<Object, Object> mapper = this.mapperFactory.lookupMapper(mapperKey, context);
        if (mapper == null) {
            throw new IllegalStateException(String.format("Cannot create a mapper for classes : %s, %s", destinationType, sourceType));
        }
        if (!mapper.getAType().equals(sourceType) && mapper.getAType().equals(destinationType) || !mapper.getAType().isAssignableFrom(sourceType) && mapper.getAType().isAssignableFrom(destinationType)) {
            mapper = ReversedMapper.reverse(mapper);
        }
        return mapper;
    }

    private <S, D> D newObject(S sourceObject, Type<? extends D> destinationType, MappingContext context, MappingStrategyRecorder strategyBuilder) {
        ObjectFactory<D> objectFactory = this.mapperFactory.lookupObjectFactory(destinationType, TypeFactory.valueOf(sourceObject.getClass()), context);
        if (strategyBuilder != null) {
            strategyBuilder.setResolvedObjectFactory(objectFactory);
        }
        return objectFactory.create(sourceObject, context);
    }

    @Override
    public <S, D> D newObject(S sourceObject, Type<? extends D> destinationType, MappingContext context) {
        return this.newObject(sourceObject, destinationType, context, null);
    }

    private <S, D> Collection<D> mapAsCollection(Iterable<S> source, Type<S> sourceType, Type<D> destinationType, Collection<D> destination, MappingContext context) {
        if (source == null) {
            return null;
        }
        ElementStrategyContext<S, D> elementContext = new ElementStrategyContext<S, D>(context, sourceType, destinationType);
        for (S item : source) {
            if (item == null) continue;
            destination.add(this.mapElement(item, elementContext));
        }
        return destination;
    }

    @Override
    public <S, D> D convert(S source, Type<S> sourceType, Type<D> destinationType, String converterId, MappingContext context) {
        Converter<Object, Object> converter;
        ConverterFactory converterFactory = this.mapperFactory.getConverterFactory();
        if (converterId == null) {
            Type<S> sourceClass = this.normalizeSourceType(source, sourceType, destinationType);
            converter = converterFactory.getConverter(sourceClass, destinationType);
        } else {
            converter = converterFactory.getConverter(converterId);
        }
        return (D)converter.convert(source, destinationType, context);
    }

    private <S, D> boolean canConvert(Type<S> sourceType, Type<D> destinationType) {
        return this.mapperFactory.getConverterFactory().canConvert(sourceType, destinationType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> D map(S sourceObject, Class<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D d = this.map(sourceObject, destinationClass, context);
            return d;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> D map(S sourceObject, Class<D> destinationClass, MappingContext context) {
        MappingStrategy strategy = null;
        try {
            if (destinationClass == null) {
                throw new MappingException("'destinationClass' is required");
            }
            if (sourceObject == null) {
                return null;
            }
            Object result = context.getMappedObject(sourceObject, TypeFactory.valueOf(destinationClass));
            if (result == null) {
                strategy = this.resolveMappingStrategy(sourceObject, null, destinationClass, false, context);
                result = strategy.map(sourceObject, null, context);
            }
            return result;
        }
        catch (MappingException e) {
            throw this.exceptionUtil.decorate(e);
        }
        catch (RuntimeException e) {
            if (!ExceptionUtility.originatedByOrika(e)) {
                throw e;
            }
            MappingException me = this.exceptionUtil.newMappingException(e);
            me.setSourceClass(sourceObject.getClass());
            me.setDestinationType(TypeFactory.valueOf(destinationClass));
            me.setMappingStrategy(strategy);
            throw me;
        }
    }

    @Override
    public <S, D> Set<D> mapAsSet(Iterable<S> source, Class<D> destinationClass) {
        return this.mapAsSet(source, this.elementTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> Set<D> mapAsSet(Iterable<S> source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsSet(source, this.elementTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Class<D> destinationClass) {
        return this.mapAsSet(source, this.componentTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> Set<D> mapAsSet(S[] source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsSet(source, this.componentTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> List<D> mapAsList(Iterable<S> source, Class<D> destinationClass) {
        return this.mapAsList(source, this.elementTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> List<D> mapAsList(Iterable<S> source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsList(source, this.elementTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> List<D> mapAsList(S[] source, Class<D> destinationClass) {
        return this.mapAsList(source, this.componentTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> List<D> mapAsList(S[] source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsList(source, this.componentTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Class<D> destinationClass) {
        return this.mapAsArray(destination, source, this.elementTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Class<D> destinationClass) {
        return this.mapAsArray(destination, source, this.componentTypeOf(source), TypeFactory.valueOf(destinationClass));
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, Iterable<S> source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsArray(destination, source, this.elementTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> D[] mapAsArray(D[] destination, S[] source, Class<D> destinationClass, MappingContext context) {
        return this.mapAsArray(destination, source, this.componentTypeOf(source), TypeFactory.valueOf(destinationClass), context);
    }

    @Override
    public <S, D> D convert(S source, Class<D> destinationClass, String converterId, MappingContext context) {
        return this.convert(source, this.typeOf(source), TypeFactory.valueOf(destinationClass), converterId, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, Dk, Dv> Map<Dk, Dv> mapAsMap(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<? extends Map<Dk, Dv>> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Map<Dk, Dv> map = this.mapAsMap(source, sourceType, destinationType, context);
            return map;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    private <S, D> D mapElement(S source, ElementStrategyContext<S, D> context) {
        Class<?> sourceClass = this.getClass(source);
        if (((ElementStrategyContext)context).strategy == null || !sourceClass.equals(((ElementStrategyContext)context).sourceClass)) {
            ((ElementStrategyContext)context).strategy = this.resolveMappingStrategy(source, ((ElementStrategyContext)context).sourceType, ((ElementStrategyContext)context).destinationType, false, ((ElementStrategyContext)context).mappingContext);
            ((ElementStrategyContext)context).sourceClass = sourceClass;
        } else {
            ((ElementStrategyContext)context).mappingContext.setResolvedSourceType(((ElementStrategyContext)context).sourceType);
            ((ElementStrategyContext)context).mappingContext.setResolvedDestinationType(((ElementStrategyContext)context).destinationType);
            ((ElementStrategyContext)context).mappingContext.setResolvedStrategy(((ElementStrategyContext)context).strategy);
        }
        return this.map(source, ((ElementStrategyContext)context).sourceType, ((ElementStrategyContext)context).destinationType, ((ElementStrategyContext)context).mappingContext, ((ElementStrategyContext)context).strategy);
    }

    @Override
    public <Sk, Sv, Dk, Dv> Map<Dk, Dv> mapAsMap(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<? extends Map<Dk, Dv>> destinationType, MappingContext context) {
        LinkedHashMap<Object, Object> destination = new LinkedHashMap<Object, Object>(source.size());
        ElementStrategyContext keyContext = new ElementStrategyContext(context, sourceType.getNestedType(0), destinationType.getNestedType(0));
        ElementStrategyContext valContext = new ElementStrategyContext(context, sourceType.getNestedType(1), destinationType.getNestedType(1));
        for (Map.Entry<Sk, Sv> entry : source.entrySet()) {
            Object key = entry.getKey() == null ? null : (Object)this.mapElement(entry.getKey(), keyContext);
            Object value = entry.getValue() == null ? null : (Object)this.mapElement(entry.getValue(), valContext);
            destination.put(key, value);
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(Iterable<S> source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Map<Dk, Dv> map = this.mapAsMap(source, sourceType, destinationType, context);
            return map;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(Iterable<S> source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType, MappingContext context) {
        HashMap destination = new HashMap();
        Type<Map.Entry> entryType = TypeFactory.valueOf(Map.Entry.class, destinationType.getNestedType(0), destinationType.getNestedType(1));
        ElementStrategyContext<S, Map.Entry> elementContext = new ElementStrategyContext<S, Map.Entry>(context, sourceType, entryType);
        for (S element : source) {
            if (element == null) continue;
            Map.Entry entry = this.mapElement(element, elementContext);
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(S[] source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Map<Dk, Dv> map = this.mapAsMap(source, sourceType, destinationType, context);
            return map;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, Dk, Dv> Map<Dk, Dv> mapAsMap(S[] source, Type<S> sourceType, Type<? extends Map<Dk, Dv>> destinationType, MappingContext context) {
        HashMap destination = new HashMap();
        Type entryType = MapEntry.concreteEntryType(destinationType);
        ElementStrategyContext elementContext = new ElementStrategyContext(context, sourceType, entryType);
        for (S element : source) {
            if (element == null) continue;
            Map.Entry entry = this.mapElement(element, elementContext);
            destination.put(entry.getKey(), entry.getValue());
        }
        return destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, D> List<D> mapAsList(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            List<D> list = this.mapAsList(source, sourceType, destinationType, context);
            return list;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, D> List<D> mapAsList(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType, MappingContext context) {
        ArrayList destination = new ArrayList(source.size());
        Type entryType = MapEntry.concreteEntryType(sourceType);
        return (List)this.mapAsCollection(MapEntry.entrySet(source), entryType, destinationType, destination, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, D> Set<D> mapAsSet(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            Set<D> set = this.mapAsSet(source, sourceType, destinationType, context);
            return set;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, D> Set<D> mapAsSet(Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType, MappingContext context) {
        HashSet destination = new HashSet(source.size());
        Type entryType = this.resolveTypeOf(source.entrySet(), sourceType).getNestedType(0);
        return (Set)this.mapAsCollection(source.entrySet(), entryType, destinationType, destination, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <Sk, Sv, D> D[] mapAsArray(D[] destination, Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            D[] DArray = this.mapAsArray(destination, source, sourceType, destinationType, context);
            return DArray;
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <Sk, Sv, D> D[] mapAsArray(D[] destination, Map<Sk, Sv> source, Type<? extends Map<Sk, Sv>> sourceType, Type<D> destinationType, MappingContext context) {
        Type entryType = MapEntry.concreteEntryType(sourceType);
        return this.mapAsArray(destination, MapEntry.entrySet(source), entryType, destinationType, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Class<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, destinationClass, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Class<D> destinationClass, MappingContext context) {
        this.mapAsCollection(source, destination, null, TypeFactory.valueOf(destinationClass), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Class<D> destinationClass) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, destinationClass, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Class<D> destinationClass, MappingContext context) {
        this.mapAsCollection(source, destination, TypeFactory.valueOf(source.getClass().getComponentType()), TypeFactory.valueOf(destinationClass), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(Iterable<S> source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, sourceType, destinationType, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S, D> void mapAsCollection(S[] source, Collection<D> destination, Type<S> sourceType, Type<D> destinationType) {
        MappingContext context = this.contextFactory.getContext();
        try {
            this.mapAsCollection(source, destination, sourceType, destinationType, context);
        }
        finally {
            this.contextFactory.release(context);
        }
    }

    @Override
    public void factoryModified(MapperFactory factory) {
        this.strategyCache.clear();
    }

    @Override
    public void reportCurrentState(StringBuilder out) {
        out.append("\n-------------------------------------------------------------");
        out.append("\nResolved strategies: ").append(this.strategyCache.size()).append(" (approximate size: ").append(StateReporter.humanReadableSizeInMemory(this.strategyCache)).append(")");
        for (Map.Entry<MappingStrategy.Key, MappingStrategy> entry : this.strategyCache.entrySet()) {
            out.append("\n").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        out.append("\n-------------------------------------------------------------");
        out.append("\nUnenhance strategy: ").append(this.unenhanceStrategy);
    }

    private <T> Type<T> typeOf(T object) {
        return object == null ? null : TypeFactory.valueOf(object.getClass());
    }

    private <T> Type<T> componentTypeOf(T[] object) {
        return object == null ? null : TypeFactory.valueOf(object.getClass().getComponentType());
    }

    private <T> Type<T> resolveTypeOf(T object, Type<?> referenceType) {
        return object == null ? null : TypeFactory.resolveValueOf(object.getClass(), referenceType);
    }

    private <T> Type<T> elementTypeOf(Iterable<T> object) {
        try {
            Method iterator = object.getClass().getMethod("iterator", new Class[0]);
            Type type = TypeFactory.valueOf(iterator.getGenericReturnType());
            return type.getNestedType(0);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ElementStrategyContext<S, D> {
        private MappingContext mappingContext;
        private MappingStrategy strategy;
        private Type<S> sourceType;
        private Type<D> destinationType;
        private Class<?> sourceClass;

        public ElementStrategyContext(MappingContext mappingContext, Type<S> sourceType, Type<D> destinationType) {
            this.mappingContext = mappingContext;
            this.sourceType = sourceType;
            this.destinationType = destinationType;
        }
    }
}

