/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.impl.generator.specification;

import ma.glasnost.orika.MapEntry;
import ma.glasnost.orika.impl.generator.MapEntryRef;
import ma.glasnost.orika.impl.generator.MultiOccurrenceVariableRef;
import ma.glasnost.orika.impl.generator.SourceCodeContext;
import ma.glasnost.orika.impl.generator.VariableRef;
import ma.glasnost.orika.impl.generator.specification.AbstractSpecification;
import ma.glasnost.orika.impl.util.StringUtil;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.Type;

public class ArrayOrCollectionToMap
extends AbstractSpecification {
    @Override
    public boolean appliesTo(FieldMap fieldMap) {
        return fieldMap.getDestination().isMap() && (fieldMap.getSource().isCollection() || fieldMap.getSource().isArray());
    }

    @Override
    public String generateMappingCode(FieldMap fieldMap, VariableRef source, VariableRef destination, SourceCodeContext code) {
        StringBuilder out = new StringBuilder();
        MultiOccurrenceVariableRef d = MultiOccurrenceVariableRef.from(destination);
        MultiOccurrenceVariableRef s = MultiOccurrenceVariableRef.from(source);
        MultiOccurrenceVariableRef newDest = new MultiOccurrenceVariableRef(d.type(), "new_" + d.name());
        SourceCodeContext.append(out, s.ifNotNull() + " {");
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(newDest.declare(newDest.newInstance(d.newMap()), new Object[0]), new Object[0]));
        } else {
            out.append(SourceCodeContext.statement(newDest.declare(d), new Object[0]));
            out.append(SourceCodeContext.statement("%s.clear()", newDest));
        }
        VariableRef element = new VariableRef(s.elementType(), "source" + StringUtil.capitalize(s.name()) + "Element");
        Type entryType = MapEntry.concreteEntryType(d.type());
        VariableRef newEntry = new VariableRef(entryType, "source" + StringUtil.capitalize(s.name()) + "Entry");
        MapEntryRef newKey = new MapEntryRef(newEntry.type(), newEntry.name(), MapEntryRef.EntryPart.KEY);
        MapEntryRef newVal = new MapEntryRef(newEntry.type(), newEntry.name(), MapEntryRef.EntryPart.VALUE);
        if (s.isArray()) {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "mapping " + s.elementTypeName() + "[] to Map<" + d.type().getNestedType(0) + ", " + d.type().getNestedType(1) + ">");
            }
            SourceCodeContext.append(out, String.format("for( int entryIndex = 0, entryLen = %s.length; entryIndex < entryLen; ++entryIndex ) {\n", s), element.declare("%s[entryIndex]", s), newEntry.declare("mapperFacade.map(%s, %s, %s, mappingContext)", element, code.usedType(element), code.usedType(newEntry)), "\n", String.format("%s.put(%s, %s)", newDest, newKey, newVal), "}");
        } else {
            if (code.isDebugEnabled()) {
                code.debugField(fieldMap, "mapping Collection<" + s.elementTypeName() + "> to Map<" + d.type().getNestedType(0) + ", " + d.type().getNestedType(1) + ">");
            }
            SourceCodeContext.append(out, String.format("for( java.util.Iterator entryIter = %s.iterator(); entryIter.hasNext(); ) {\n", s), element.declare("entryIter.next()", new Object[0]), newEntry.declare("mapperFacade.map(%s, %s, %s, mappingContext)", element, code.usedType(element), code.usedType(newEntry)), "\n", String.format("%s.put(%s, %s)", newDest, newKey, newVal), "}");
        }
        if (d.isAssignable()) {
            out.append(SourceCodeContext.statement(d.assign(newDest), new Object[0]));
        }
        String mapNull = ArrayOrCollectionToMap.shouldMapNulls(fieldMap, code) ? String.format(" else {\n %s;\n}", d.assignIfPossible("null", new Object[0])) : "";
        SourceCodeContext.append(out, "}" + mapNull);
        return out.toString();
    }
}

