/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.property.PropertyResolverStrategy;

public class NestedElementProperty
extends Property {
    private final Property elementProperty;

    public NestedElementProperty(Property owningProperty, Property elementProperty, PropertyResolverStrategy resolver) {
        super(NestedElementProperty.getElementExpression(owningProperty, elementProperty), elementProperty.getName(), elementProperty.getGetter(), elementProperty.getSetter(), elementProperty.getType(), elementProperty.getElementType(), NestedElementProperty.initContainer(owningProperty, elementProperty.getExpression(), resolver));
        Property element = NestedElementProperty.initElement(this.getContainer(), elementProperty.getExpression(), resolver);
        if (element == null) {
            element = elementProperty;
        }
        this.elementProperty = element;
    }

    private static String getElementExpression(Property owningProperty, Property elementProperty) {
        int splitIndex = owningProperty.getExpression().lastIndexOf("{");
        if (splitIndex >= 0) {
            return owningProperty.getExpression().substring(0, splitIndex + 1) + "{" + elementProperty.getExpression() + "}" + owningProperty.getExpression().substring(splitIndex + 1);
        }
        return owningProperty.getExpression() + "{" + elementProperty.getExpression() + "}";
    }

    private static Property initContainer(Property owningProperty, String propertyExpression, PropertyResolverStrategy resolver) {
        String[] parts = propertyExpression.replace("}", "").split("\\{");
        if (parts.length > 1) {
            StringBuilder containerExpression = new StringBuilder("");
            for (int i = parts.length - 2; i >= 0; --i) {
                String part = parts[i];
                containerExpression.insert(0, "{" + part);
                containerExpression.append("}");
            }
            Property container = "".equals(containerExpression.toString()) ? owningProperty : resolver.getProperty(owningProperty, containerExpression.toString());
            return container;
        }
        return owningProperty;
    }

    private static Property initElement(Property container, String propertyExpression, PropertyResolverStrategy resolver) {
        String[] parts = propertyExpression.replace("}", "").split("\\{");
        if (parts.length > 1) {
            return resolver.getProperty(container, "{" + parts[parts.length - 1] + "}");
        }
        return null;
    }

    @Override
    public Property getElement() {
        return this.elementProperty;
    }

    public Property getRootContainer() {
        Property container = this.getContainer();
        while (container.getContainer() != null) {
            container = container.getContainer();
        }
        return container;
    }
}

