/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.internal.common.InputOutput;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterStorage;
import org.jrobin.core.Archive;
import org.jrobin.core.Robin;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;

abstract class CollectorDataMerge {
    private final List<File> sourceDirectories;
    private final File targetDirectory;

    CollectorDataMerge(List<File> sourceDirectories, File targetDirectory) {
        this.sourceDirectories = sourceDirectories;
        this.targetDirectory = targetDirectory;
    }

    protected abstract void log(String var1);

    int mergeDirectories() throws IOException {
        ArrayList<String> mergedFileNames = new ArrayList<String>();
        for (File directory : this.sourceDirectories) {
            List<File> files = this.listFiles(directory);
            for (File file : files) {
                String fileName = file.getName();
                if (mergedFileNames.contains(fileName)) continue;
                if (this.isFileExcluded(fileName)) {
                    this.log("Excluding " + fileName);
                    continue;
                }
                mergedFileNames.add(fileName);
                ArrayList<File> filesToMerge = new ArrayList<File>();
                for (File directoryToMerge : this.sourceDirectories) {
                    File fileToMerge = new File(directoryToMerge, fileName);
                    if (!fileToMerge.exists()) continue;
                    filesToMerge.add(fileToMerge);
                }
                assert (!filesToMerge.isEmpty());
                File target = new File(this.targetDirectory, fileName);
                if (fileName.endsWith(".rrd")) {
                    this.log("Merging " + fileName);
                    if (filesToMerge.size() == 1) {
                        InputOutput.copyFile((File)filesToMerge.get(0), new File(this.targetDirectory, fileName));
                        continue;
                    }
                    this.mergeGraphs(filesToMerge, target);
                    continue;
                }
                if (fileName.endsWith(".ser.gz")) {
                    this.log("Merging " + fileName);
                    if (filesToMerge.size() == 1) {
                        InputOutput.copyFile((File)filesToMerge.get(0), new File(this.targetDirectory, fileName));
                        continue;
                    }
                    this.mergeStatistics(filesToMerge, target);
                    continue;
                }
                this.log("Ignoring " + fileName);
            }
        }
        return mergedFileNames.size();
    }

    private boolean isFileExcluded(String fileName) {
        return fileName.endsWith(".rrd") && fileName.length() > 40;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeGraphs(List<File> sources, File target) throws IOException {
        try {
            RrdDb mergedRrdDb = null;
            Double coeff = null;
            String name = target.getName();
            boolean percentageValues = "cpu.rrd".equals(name) || "gc.rrd".equals(name) || "systemCpuLoad.rrd".equals(name) || name.endsWith("SystemErrors.rrd");
            File lastSource = sources.get(sources.size() - 1);
            for (File source : sources) {
                if (mergedRrdDb == null) {
                    InputOutput.copyFile(source, target);
                    mergedRrdDb = new RrdDb(target.getPath());
                    continue;
                }
                if (percentageValues && source.equals(lastSource)) {
                    coeff = 1.0 / (double)sources.size();
                }
                RrdDb sourceRrdDb = new RrdDb(source.getPath());
                try {
                    this.mergeRrdDbs(sourceRrdDb, mergedRrdDb, coeff);
                }
                finally {
                    sourceRrdDb.close();
                }
            }
            assert (mergedRrdDb != null);
            mergedRrdDb.close();
        }
        catch (RrdException e) {
            this.log(e.toString());
            InputOutput.deleteFile(target);
        }
    }

    private void mergeRrdDbs(RrdDb sourceRrdDb, RrdDb mergedRrdDb, Double coeff) throws IOException, RrdException {
        assert (sourceRrdDb.getArcCount() == mergedRrdDb.getArcCount());
        assert (sourceRrdDb.getDsCount() == mergedRrdDb.getDsCount());
        for (int i = 0; i < sourceRrdDb.getArcCount(); ++i) {
            Archive sourceArchive = sourceRrdDb.getArchive(i);
            Archive mergedArchive = mergedRrdDb.getArchive(i);
            assert (sourceArchive.getArcStep() == mergedArchive.getArcStep());
            assert (sourceArchive.getConsolFun().equals(mergedArchive.getConsolFun()));
            for (int j = 0; j < sourceRrdDb.getDsCount(); ++j) {
                Robin sourceRobin = sourceArchive.getRobin(j);
                Robin mergedRobin = mergedArchive.getRobin(j);
                double[] sourceValues = sourceRobin.getValues();
                double[] mergedValues = mergedRobin.getValues();
                assert (sourceValues.length == mergedValues.length);
                for (int k = 0; k < mergedValues.length; ++k) {
                    int n = k;
                    mergedValues[n] = mergedValues[n] + sourceValues[k];
                    if (coeff == null) continue;
                    int n2 = k;
                    mergedValues[n2] = mergedValues[n2] * coeff;
                }
                mergedRobin.setValues(mergedValues);
            }
        }
    }

    private void mergeStatistics(List<File> sources, File target) throws IOException {
        Counter mergedCounter = null;
        for (File source : sources) {
            Counter counter = null;
            try {
                counter = CounterStorage.readFromFile(source);
            }
            catch (IOException e) {
                this.log(e.toString() + " for " + source);
                continue;
            }
            if (mergedCounter == null) {
                mergedCounter = counter;
                continue;
            }
            for (CounterRequest request : counter.getRequests()) {
                mergedCounter.addHits(request);
            }
            if (!counter.isErrorCounter()) continue;
            mergedCounter.addErrors(counter.getErrors());
        }
        assert (mergedCounter != null);
        CounterStorage.writeToFile(mergedCounter, target);
    }

    private List<File> listFiles(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }
}

