/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.SpringContext;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.CacheInformations;
import net.bull.javamelody.internal.model.HsErrPid;
import net.bull.javamelody.internal.model.JCacheInformations;
import net.bull.javamelody.internal.model.JobInformations;
import net.bull.javamelody.internal.model.MBeansAccessor;
import net.bull.javamelody.internal.model.MavenArtifact;
import net.bull.javamelody.internal.model.MemoryInformations;
import net.bull.javamelody.internal.model.PID;
import net.bull.javamelody.internal.model.ThreadInformations;
import net.bull.javamelody.internal.model.TomcatInformations;

public class JavaInformations
implements Serializable {
    public static final double HIGH_USAGE_THRESHOLD_IN_PERCENTS = 95.0;
    private static final long serialVersionUID = 3281861236369720876L;
    private static final Date START_DATE = new Date();
    private static final boolean SPRING_AVAILABLE = JavaInformations.isSpringAvailable();
    private static boolean localWebXmlExists = true;
    private static boolean localPomXmlExists = true;
    private final MemoryInformations memoryInformations;
    private final List<TomcatInformations> tomcatInformationsList;
    private final int sessionCount;
    private final long sessionAgeSum;
    private final int activeThreadCount;
    private final int usedConnectionCount;
    private final int maxConnectionCount;
    private final int activeConnectionCount;
    private final long transactionCount;
    private final long processCpuTimeMillis;
    private final double systemLoadAverage;
    private final double systemCpuLoad;
    private final long unixOpenFileDescriptorCount;
    private final long unixMaxFileDescriptorCount;
    private final String host;
    private final String os;
    private final int availableProcessors;
    private final String javaVersion;
    private final String jvmVersion;
    private final String pid;
    private final String serverInfo;
    private final String contextPath;
    private final String contextDisplayName;
    private final String webappVersion;
    private final Date startDate;
    private final String jvmArguments;
    private final long freeDiskSpaceInTemp;
    private final int threadCount;
    private final int peakThreadCount;
    private final long totalStartedThreadCount;
    private final String dataBaseVersion;
    private final String dataSourceDetails;
    private final List<ThreadInformations> threadInformationsList;
    private final List<CacheInformations> cacheInformationsList;
    private final List<JCacheInformations> jcacheInformationsList;
    private final List<JobInformations> jobInformationsList;
    private final List<HsErrPid> hsErrPidList;
    private final boolean webXmlExists = localWebXmlExists;
    private final boolean pomXmlExists = localPomXmlExists;
    private final boolean springBeanExists;

    public JavaInformations(ServletContext servletContext, boolean includeDetails) {
        this.memoryInformations = new MemoryInformations();
        this.tomcatInformationsList = TomcatInformations.buildTomcatInformationsList();
        this.sessionCount = SessionListener.getSessionCount();
        this.sessionAgeSum = SessionListener.getSessionAgeSum();
        this.activeThreadCount = JdbcWrapper.getActiveThreadCount();
        this.usedConnectionCount = JdbcWrapper.getUsedConnectionCount();
        this.activeConnectionCount = JdbcWrapper.getActiveConnectionCount();
        this.maxConnectionCount = JdbcWrapper.getMaxConnectionCount();
        this.transactionCount = JdbcWrapper.getTransactionCount();
        this.systemLoadAverage = JavaInformations.buildSystemLoadAverage();
        this.systemCpuLoad = JavaInformations.buildSystemCpuLoad();
        this.processCpuTimeMillis = JavaInformations.buildProcessCpuTimeMillis();
        this.unixOpenFileDescriptorCount = JavaInformations.buildOpenFileDescriptorCount();
        this.unixMaxFileDescriptorCount = JavaInformations.buildMaxFileDescriptorCount();
        this.host = Parameters.getHostName() + '@' + Parameters.getHostAddress();
        this.os = JavaInformations.buildOS();
        this.availableProcessors = Runtime.getRuntime().availableProcessors();
        this.javaVersion = System.getProperty("java.runtime.name") + ", " + System.getProperty("java.runtime.version");
        this.jvmVersion = System.getProperty("java.vm.name") + ", " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info");
        if (servletContext == null) {
            this.serverInfo = null;
            this.contextPath = null;
            this.contextDisplayName = null;
            this.webappVersion = null;
        } else {
            this.serverInfo = servletContext.getServerInfo();
            this.contextPath = Parameters.getContextPath(servletContext);
            this.contextDisplayName = servletContext.getServletContextName();
            this.webappVersion = MavenArtifact.getWebappVersion();
        }
        this.startDate = START_DATE;
        this.jvmArguments = JavaInformations.buildJvmArguments();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        this.threadCount = threadBean.getThreadCount();
        this.peakThreadCount = threadBean.getPeakThreadCount();
        this.totalStartedThreadCount = threadBean.getTotalStartedThreadCount();
        this.freeDiskSpaceInTemp = Parameters.TEMPORARY_DIRECTORY.getFreeSpace();
        boolean bl = this.springBeanExists = SPRING_AVAILABLE && SpringContext.getSingleton() != null;
        if (includeDetails) {
            this.dataBaseVersion = JavaInformations.buildDataBaseVersion();
            this.dataSourceDetails = JavaInformations.buildDataSourceDetails();
            this.threadInformationsList = JavaInformations.buildThreadInformationsList();
            this.cacheInformationsList = CacheInformations.buildCacheInformationsList();
            this.jcacheInformationsList = JCacheInformations.buildJCacheInformationsList();
            this.jobInformationsList = JobInformations.buildJobInformationsList();
            this.hsErrPidList = HsErrPid.buildHsErrPidList();
            this.pid = PID.getPID();
        } else {
            this.dataBaseVersion = null;
            this.dataSourceDetails = null;
            this.threadInformationsList = null;
            this.cacheInformationsList = null;
            this.jcacheInformationsList = null;
            this.jobInformationsList = null;
            this.hsErrPidList = null;
            this.pid = null;
        }
    }

    public static void setWebXmlExistsAndPomXmlExists(boolean webXmlExists, boolean pomXmlExists) {
        localWebXmlExists = webXmlExists;
        localPomXmlExists = pomXmlExists;
    }

    public boolean doesWebXmlExists() {
        return this.webXmlExists;
    }

    public boolean doesPomXmlExists() {
        return this.pomXmlExists;
    }

    private static String buildOS() {
        String name = System.getProperty("os.name");
        String version = System.getProperty("os.version");
        String patchLevel = System.getProperty("sun.os.patch.level");
        String arch = System.getProperty("os.arch");
        String bits = System.getProperty("sun.arch.data.model");
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(", ");
        if (!name.toLowerCase(Locale.ENGLISH).contains("windows")) {
            sb.append(version).append(' ');
        }
        if (!"unknown".equals(patchLevel)) {
            sb.append(patchLevel);
        }
        sb.append(", ").append(arch).append('/').append(bits);
        return sb.toString();
    }

    private static long buildProcessCpuTimeMillis() {
        long processCpuTime = MBeansAccessor.getLongFromOperatingSystem("ProcessCpuTime");
        if (processCpuTime >= 0L) {
            return processCpuTime / 1000000L;
        }
        return -1L;
    }

    private static long buildOpenFileDescriptorCount() {
        try {
            return MBeansAccessor.getLongFromOperatingSystem("OpenFileDescriptorCount");
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    private static long buildMaxFileDescriptorCount() {
        try {
            return MBeansAccessor.getLongFromOperatingSystem("MaxFileDescriptorCount");
        }
        catch (Throwable e) {
            return -1L;
        }
    }

    private static double buildSystemCpuLoad() {
        double systemCpu = MBeansAccessor.getDoubleFromOperatingSystem("SystemCpuLoad");
        if (systemCpu >= 0.0) {
            return systemCpu * 100.0;
        }
        return -1.0;
    }

    private static double buildSystemLoadAverage() {
        OperatingSystemMXBean operatingSystem = ManagementFactory.getOperatingSystemMXBean();
        if (operatingSystem.getSystemLoadAverage() >= 0.0) {
            return operatingSystem.getSystemLoadAverage();
        }
        return -1.0;
    }

    private static String buildJvmArguments() {
        StringBuilder jvmArgs = new StringBuilder();
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            jvmArgs.append(jvmArg).append('\n');
        }
        if (jvmArgs.length() > 0) {
            jvmArgs.deleteCharAt(jvmArgs.length() - 1);
        }
        return jvmArgs.toString();
    }

    public static List<ThreadInformations> buildThreadInformationsList() {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(stackTraces.keySet());
        boolean cpuTimeEnabled = threadBean.isThreadCpuTimeSupported() && threadBean.isThreadCpuTimeEnabled();
        long[] deadlockedThreads = JavaInformations.getDeadlockedThreads(threadBean);
        ArrayList<ThreadInformations> threadInfosList = new ArrayList<ThreadInformations>(threads.size());
        String hostAddress = Parameters.getHostAddress();
        for (Thread thread : threads) {
            long userTimeMillis;
            long cpuTimeMillis;
            ArrayList<StackTraceElement> stackTraceElementList;
            StackTraceElement[] stackTraceElements = stackTraces.get(thread);
            ArrayList<StackTraceElement> arrayList = stackTraceElementList = stackTraceElements == null ? null : new ArrayList<StackTraceElement>(Arrays.asList(stackTraceElements));
            if (cpuTimeEnabled) {
                cpuTimeMillis = threadBean.getThreadCpuTime(thread.getId()) / 1000000L;
                userTimeMillis = threadBean.getThreadUserTime(thread.getId()) / 1000000L;
            } else {
                cpuTimeMillis = -1L;
                userTimeMillis = -1L;
            }
            boolean deadlocked = deadlockedThreads != null && Arrays.binarySearch(deadlockedThreads, thread.getId()) >= 0;
            threadInfosList.add(new ThreadInformations(thread, stackTraceElementList, cpuTimeMillis, userTimeMillis, deadlocked, hostAddress));
        }
        return threadInfosList;
    }

    static List<Thread> getThreadsFromThreadGroups() {
        ThreadGroup group = Thread.currentThread().getThreadGroup();
        while (group.getParent() != null) {
            group = group.getParent();
        }
        Thread[] threadsArray = new Thread[group.activeCount()];
        group.enumerate(threadsArray, true);
        ArrayList<Thread> threads = new ArrayList<Thread>(threadsArray.length);
        for (Thread thread : threadsArray) {
            if (thread == null) continue;
            threads.add(thread);
        }
        return threads;
    }

    private static long[] getDeadlockedThreads(ThreadMXBean threadBean) {
        long[] deadlockedThreads = threadBean.isSynchronizerUsageSupported() ? threadBean.findDeadlockedThreads() : threadBean.findMonitorDeadlockedThreads();
        if (deadlockedThreads != null) {
            Arrays.sort(deadlockedThreads);
        }
        return deadlockedThreads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String buildDataBaseVersion() {
        if (Parameters.isNoDatabase()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        try {
            if (Parameters.getLastConnectUrl() != null) {
                Connection connection = DriverManager.getConnection(Parameters.getLastConnectUrl(), Parameters.getLastConnectInfo());
                connection.setAutoCommit(false);
                try {
                    JavaInformations.appendDataBaseVersion(result, connection);
                }
                finally {
                    connection.close();
                }
            }
            Map<String, DataSource> dataSources = JdbcWrapper.getJndiAndSpringDataSources();
            for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
                String name = entry.getKey();
                DataSource dataSource = entry.getValue();
                Connection connection = dataSource.getConnection();
                try {
                    if (result.length() > 0) {
                        result.append("\n\n");
                    }
                    result.append(name).append(":\n");
                    JavaInformations.appendDataBaseVersion(result, connection);
                }
                finally {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            result.append(e.toString());
        }
        if (result.length() > 0) {
            return result.toString();
        }
        return null;
    }

    private static void appendDataBaseVersion(StringBuilder result, Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        result.append(metaData.getURL()).append('\n');
        result.append(metaData.getDatabaseProductName()).append(", ").append(metaData.getDatabaseProductVersion()).append('\n');
        result.append("Driver JDBC:\n").append(metaData.getDriverName()).append(", ").append(metaData.getDriverVersion());
    }

    private static String buildDataSourceDetails() {
        Map<String, Map<String, Object>> dataSourcesProperties = JdbcWrapper.getBasicDataSourceProperties();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<String, Object>> entry : dataSourcesProperties.entrySet()) {
            String name;
            Map<String, Object> dataSourceProperties = entry.getValue();
            if (dataSourceProperties.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if ((name = entry.getKey()) != null) {
                sb.append(name).append(":\n");
            }
            for (Map.Entry<String, Object> propertyEntry : dataSourceProperties.entrySet()) {
                sb.append(propertyEntry.getKey()).append(" = ").append(propertyEntry.getValue()).append('\n');
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public MemoryInformations getMemoryInformations() {
        return this.memoryInformations;
    }

    public List<TomcatInformations> getTomcatInformationsList() {
        return this.tomcatInformationsList;
    }

    public int getSessionCount() {
        return this.sessionCount;
    }

    long getSessionAgeSum() {
        return this.sessionAgeSum;
    }

    public long getSessionMeanAgeInMinutes() {
        if (this.sessionCount > 0) {
            return this.sessionAgeSum / (long)this.sessionCount / 60000L;
        }
        return -1L;
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount;
    }

    public int getUsedConnectionCount() {
        return this.usedConnectionCount;
    }

    public int getActiveConnectionCount() {
        return this.activeConnectionCount;
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public long getTransactionCount() {
        return this.transactionCount;
    }

    public double getUsedConnectionPercentage() {
        if (this.maxConnectionCount > 0) {
            return 100.0 * (double)this.usedConnectionCount / (double)this.maxConnectionCount;
        }
        return -1.0;
    }

    public long getProcessCpuTimeMillis() {
        return this.processCpuTimeMillis;
    }

    public double getSystemLoadAverage() {
        return this.systemLoadAverage;
    }

    public double getSystemCpuLoad() {
        return this.systemCpuLoad;
    }

    public long getUnixOpenFileDescriptorCount() {
        return this.unixOpenFileDescriptorCount;
    }

    public long getUnixMaxFileDescriptorCount() {
        return this.unixMaxFileDescriptorCount;
    }

    public double getUnixOpenFileDescriptorPercentage() {
        if (this.unixOpenFileDescriptorCount >= 0L) {
            return 100.0 * (double)this.unixOpenFileDescriptorCount / (double)this.unixMaxFileDescriptorCount;
        }
        return -1.0;
    }

    public String getHost() {
        return this.host;
    }

    public String getOS() {
        return this.os;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getJvmVersion() {
        return this.jvmVersion;
    }

    public String getPID() {
        return this.pid;
    }

    public String getServerInfo() {
        return this.serverInfo;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getContextDisplayName() {
        return this.contextDisplayName;
    }

    public String getWebappVersion() {
        return this.webappVersion;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public String getJvmArguments() {
        return this.jvmArguments;
    }

    public long getFreeDiskSpaceInTemp() {
        return this.freeDiskSpaceInTemp;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public long getTotalStartedThreadCount() {
        return this.totalStartedThreadCount;
    }

    public String getDataBaseVersion() {
        return this.dataBaseVersion;
    }

    public String getDataSourceDetails() {
        return this.dataSourceDetails;
    }

    public List<ThreadInformations> getThreadInformationsList() {
        ArrayList<ThreadInformations> result = new ArrayList<ThreadInformations>(this.threadInformationsList);
        Collections.sort(result, new ThreadInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    public List<CacheInformations> getCacheInformationsList() {
        ArrayList<CacheInformations> result = new ArrayList<CacheInformations>(this.cacheInformationsList);
        Collections.sort(result, new CacheInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    public List<JCacheInformations> getJCacheInformationsList() {
        ArrayList<JCacheInformations> result = new ArrayList<JCacheInformations>(this.jcacheInformationsList);
        Collections.sort(result, new JCacheInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    public List<JobInformations> getJobInformationsList() {
        ArrayList<JobInformations> result = new ArrayList<JobInformations>(this.jobInformationsList);
        Collections.sort(result, new JobInformationsComparator());
        return Collections.unmodifiableList(result);
    }

    public int getCurrentlyExecutingJobCount() {
        int result = 0;
        for (JobInformations jobInformations : this.jobInformationsList) {
            if (!jobInformations.isCurrentlyExecuting()) continue;
            ++result;
        }
        return result;
    }

    public List<HsErrPid> getHsErrPidList() {
        if (this.hsErrPidList != null) {
            ArrayList<HsErrPid> result = new ArrayList<HsErrPid>(this.hsErrPidList);
            Collections.sort(result, new HsErrPid.HsErrPidComparator());
            return Collections.unmodifiableList(result);
        }
        return null;
    }

    public boolean isStackTraceEnabled() {
        for (ThreadInformations threadInformations : this.threadInformationsList) {
            List<StackTraceElement> stackTrace = threadInformations.getStackTrace();
            if (stackTrace == null || stackTrace.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean isCacheEnabled() {
        return this.cacheInformationsList != null && !this.cacheInformationsList.isEmpty();
    }

    public boolean isJCacheEnabled() {
        return this.jcacheInformationsList != null && !this.jcacheInformationsList.isEmpty();
    }

    public boolean isJobEnabled() {
        return this.jobInformationsList != null && !this.jobInformationsList.isEmpty();
    }

    public boolean isSpringBeansEnabled() {
        return this.springBeanExists;
    }

    private static boolean isSpringAvailable() {
        try {
            Class.forName("org.springframework.context.ApplicationContextAware");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pid=" + this.getPID() + ", host=" + this.getHost() + ", javaVersion=" + this.getJavaVersion() + ", serverInfo=" + this.getServerInfo() + ']';
    }

    static final class JobInformationsComparator
    implements Comparator<JobInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JobInformationsComparator() {
        }

        @Override
        public int compare(JobInformations job1, JobInformations job2) {
            return job1.getName().compareToIgnoreCase(job2.getName());
        }
    }

    static final class JCacheInformationsComparator
    implements Comparator<JCacheInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        JCacheInformationsComparator() {
        }

        @Override
        public int compare(JCacheInformations cache1, JCacheInformations cache2) {
            return cache1.getName().compareToIgnoreCase(cache2.getName());
        }
    }

    static final class CacheInformationsComparator
    implements Comparator<CacheInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CacheInformationsComparator() {
        }

        @Override
        public int compare(CacheInformations cache1, CacheInformations cache2) {
            return cache1.getName().compareToIgnoreCase(cache2.getName());
        }
    }

    static final class ThreadInformationsComparator
    implements Comparator<ThreadInformations>,
    Serializable {
        private static final long serialVersionUID = 1L;

        ThreadInformationsComparator() {
        }

        @Override
        public int compare(ThreadInformations thread1, ThreadInformations thread2) {
            return thread1.getName().compareToIgnoreCase(thread2.getName());
        }
    }
}

