/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.FreehandRoi;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.measure.SplineFitter;
import ij.plugin.frame.LineWidthAdjuster;
import ij.plugin.frame.Recorder;
import ij.process.FloatPolygon;
import ij.process.ImageProcessor;
import ij.process.PolygonFiller;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;

public class PolygonRoi
extends Roi {
    protected int maxPoints = 1000;
    protected int[] xp;
    protected int[] yp;
    protected float[] xpf;
    protected float[] ypf;
    protected int[] xp2;
    protected int[] yp2;
    protected int nPoints;
    protected float[] xSpline;
    protected float[] ySpline;
    protected int splinePoints = 200;
    Rectangle clip;
    private double angle1;
    private double degrees = Double.NaN;
    private int xClipMin;
    private int yClipMin;
    private int xClipMax;
    private int yClipMax;
    private boolean userCreated;
    private int boxSize = 8;
    long mouseUpTime = 0L;

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, int type) {
        super(0, 0, null);
        this.init1(nPoints, type);
        this.xp = xPoints;
        this.yp = yPoints;
        if (type != 4) {
            this.xp = new int[nPoints];
            this.yp = new int[nPoints];
            for (int i = 0; i < nPoints; ++i) {
                this.xp[i] = xPoints[i];
                this.yp[i] = yPoints[i];
            }
        }
        this.xp2 = new int[nPoints];
        this.yp2 = new int[nPoints];
        this.init2(type);
        this.state = 3;
    }

    public PolygonRoi(float[] xPoints, float[] yPoints, int nPoints, int type) {
        super(0, 0, null);
        this.init1(nPoints, type);
        this.xpf = new float[nPoints];
        this.ypf = new float[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            this.xpf[i] = xPoints[i];
            this.ypf[i] = yPoints[i];
        }
        this.enableSubPixelResolution();
        this.xp2 = new int[nPoints];
        this.yp2 = new int[nPoints];
        this.init2(type);
        this.state = 3;
    }

    public PolygonRoi(float[] xPoints, float[] yPoints, int type) {
        this(xPoints, yPoints, xPoints.length, type);
    }

    private void init1(int nPoints, int type) throws IllegalArgumentException {
        this.maxPoints = nPoints;
        this.nPoints = nPoints;
        if (type == 2) {
            this.type = 2;
        } else if (type == 3) {
            this.type = 3;
        } else if (type == 4) {
            this.type = 4;
        } else if (type == 6) {
            this.type = 6;
        } else if (type == 7) {
            this.type = 7;
        } else if (type == 8) {
            this.type = 8;
        } else if (type == 10) {
            this.type = 10;
        } else {
            throw new IllegalArgumentException("PolygonRoi: Invalid type");
        }
    }

    private void init2(int type) {
        if (type == 8 && this.nPoints == 3) {
            this.getAngleAsString();
        }
        if (type == 10 && Toolbar.getMultiPointMode()) {
            Prefs.pointAutoMeasure = false;
            Prefs.pointAutoNextSlice = false;
            Prefs.pointAddToManager = false;
            Prefs.pointAddToOverlay = false;
            this.userCreated = true;
        }
        if (lineWidth > 1 && this.isLine()) {
            this.updateWideLine(lineWidth);
        }
        this.finishPolygon();
    }

    public PolygonRoi(Polygon p, int type) {
        this(p.xpoints, p.ypoints, p.npoints, type);
    }

    public PolygonRoi(FloatPolygon p, int type) {
        this(p.xpoints, p.ypoints, p.npoints, type);
    }

    public PolygonRoi(int[] xPoints, int[] yPoints, int nPoints, ImagePlus imp, int type) {
        this(xPoints, yPoints, nPoints, type);
        this.setImage(imp);
    }

    public PolygonRoi(int sx, int sy, ImagePlus imp) {
        super(sx, sy, imp);
        int tool = Toolbar.getToolId();
        switch (tool) {
            case 2: {
                this.type = 2;
                break;
            }
            case 3: {
                this.type = 3;
                break;
            }
            case 6: {
                this.type = 7;
                break;
            }
            case 14: {
                this.type = 8;
                break;
            }
            default: {
                this.type = 6;
            }
        }
        if (this.magnificationForSubPixel()) {
            this.enableSubPixelResolution();
        }
        this.previousSX = sx;
        this.previousSY = sy;
        this.x = this.offScreenX(sx);
        this.y = this.offScreenY(sy);
        this.startXD = this.offScreenXD(sx);
        this.startYD = this.offScreenYD(sy);
        if (this.subPixelResolution()) {
            this.setLocation(this.startXD, this.startYD);
            this.xpf = new float[this.maxPoints];
            this.ypf = new float[this.maxPoints];
            double xbase = this.getXBase();
            double ybase = this.getYBase();
            this.xpf[0] = (float)(this.startXD - xbase);
            this.ypf[0] = (float)(this.startYD - ybase);
            this.xpf[1] = this.xpf[0];
            this.ypf[1] = this.ypf[0];
        } else {
            this.xp = new int[this.maxPoints];
            this.yp = new int[this.maxPoints];
        }
        this.xp2 = new int[this.maxPoints];
        this.yp2 = new int[this.maxPoints];
        this.nPoints = 2;
        this.width = 1;
        this.height = 1;
        this.clipX = this.x;
        this.clipY = this.y;
        this.clipWidth = 1;
        this.clipHeight = 1;
        this.state = 0;
        this.userCreated = true;
        if (lineWidth > 1 && this.isLine()) {
            this.updateWideLine(lineWidth);
        }
        this.boxSize = (int)((double)this.boxSize * Prefs.getGuiScale());
    }

    private void drawStartBox(Graphics g) {
        if (this.type != 8) {
            g.drawRect(this.screenXD(this.startXD) - 4, this.screenYD(this.startYD) - 4, 8, 8);
        }
    }

    @Override
    public void draw(Graphics g) {
        boolean isActiveOverlayRoi;
        this.updatePolygon();
        Color color = this.strokeColor != null ? this.strokeColor : ROIColor;
        boolean hasHandles = this.xSpline != null || this.type == 2 || this.type == 6 || this.type == 8;
        boolean bl = isActiveOverlayRoi = !this.overlay && this.isActiveOverlayRoi();
        if (isActiveOverlayRoi) {
            color = color == Color.cyan ? Color.magenta : Color.cyan;
        }
        boolean fill = false;
        this.mag = this.getMagnification();
        if (this.fillColor != null && !this.isLine() && this.state != 0) {
            color = this.fillColor;
            fill = true;
        }
        g.setColor(color);
        Graphics2D g2d = (Graphics2D)g;
        this.setRenderingHint(g2d);
        if (this.stroke != null && !isActiveOverlayRoi) {
            g2d.setStroke(this.getScaledStroke());
        }
        if (this.xSpline != null) {
            if (this.type == 6 || this.type == 7) {
                this.drawSpline(g, this.xSpline, this.ySpline, this.splinePoints, false, fill, isActiveOverlayRoi);
                if (this.wideLine && !this.overlay) {
                    g2d.setStroke(onePixelWide);
                    g.setColor(PolygonRoi.getColor());
                    this.drawSpline(g, this.xSpline, this.ySpline, this.splinePoints, false, fill, isActiveOverlayRoi);
                }
            } else {
                this.drawSpline(g, this.xSpline, this.ySpline, this.splinePoints, true, fill, isActiveOverlayRoi);
            }
        } else {
            if (this.type == 6 || this.type == 7 || this.type == 8 || this.state == 0) {
                g.drawPolyline(this.xp2, this.yp2, this.nPoints);
                if (this.wideLine && !this.overlay) {
                    g2d.setStroke(onePixelWide);
                    g.setColor(PolygonRoi.getColor());
                    g.drawPolyline(this.xp2, this.yp2, this.nPoints);
                }
            } else if (fill) {
                if (isActiveOverlayRoi) {
                    g.setColor(Color.cyan);
                    g.drawPolygon(this.xp2, this.yp2, this.nPoints);
                } else {
                    g.fillPolygon(this.xp2, this.yp2, this.nPoints);
                }
            } else {
                g.drawPolygon(this.xp2, this.yp2, this.nPoints);
            }
            if (this.state == 0 && this.type != 3 && this.type != 7) {
                this.drawStartBox(g);
            }
        }
        if (hasHandles && this.clipboard == null && !this.overlay) {
            if (this.activeHandle > 0) {
                this.drawHandle(g, this.xp2[this.activeHandle - 1], this.yp2[this.activeHandle - 1]);
            }
            if (this.activeHandle < this.nPoints - 1) {
                this.drawHandle(g, this.xp2[this.activeHandle + 1], this.yp2[this.activeHandle + 1]);
            }
            this.handleColor = this.strokeColor != null ? this.strokeColor : ROIColor;
            this.drawHandle(g, this.xp2[0], this.yp2[0]);
            this.handleColor = Color.white;
            for (int i = 1; i < this.nPoints; ++i) {
                this.drawHandle(g, this.xp2[i], this.yp2[i]);
            }
        }
        this.drawPreviousRoi(g);
        if (this.state != 4 && this.state != 0 && this.state != 3) {
            this.showStatus();
        }
        if (this.updateFullWindow) {
            this.updateFullWindow = false;
            this.imp.draw();
        }
    }

    private void drawSpline(Graphics g, float[] xpoints, float[] ypoints, int npoints, boolean closed, boolean fill, boolean isActiveOverlayRoi) {
        boolean doScaling;
        if (xpoints == null || xpoints.length == 0) {
            return;
        }
        boolean bl = doScaling = this.ic != null;
        if (this.ic != null) {
            Rectangle srcRect = this.ic.getSrcRect();
            if (srcRect.x == 0 && srcRect.y == 0 && this.ic.getMagnification() == 1.0) {
                doScaling = false;
            }
        }
        double xd = this.getXBase();
        double yd = this.getYBase();
        Graphics2D g2d = (Graphics2D)g;
        GeneralPath path = new GeneralPath();
        path.moveTo(this.screenXD((double)xpoints[0] + xd), this.screenYD((double)ypoints[0] + yd));
        if (doScaling) {
            for (int i = 1; i < npoints; ++i) {
                path.lineTo(this.screenXD((double)xpoints[i] + xd), this.screenYD((double)ypoints[i] + yd));
            }
        } else {
            double xd1 = xd;
            double yd1 = yd;
            if (this.useLineSubpixelConvention()) {
                xd1 += 0.5;
                yd1 += 0.5;
            }
            for (int i = 1; i < npoints; ++i) {
                path.lineTo((double)xpoints[i] + xd1, (double)ypoints[i] + yd1);
            }
        }
        if (closed) {
            path.lineTo(this.screenXD((double)xpoints[0] + xd), this.screenYD((double)ypoints[0] + yd));
        }
        if (fill) {
            if (isActiveOverlayRoi) {
                g2d.setColor(Color.cyan);
                g2d.draw(path);
            } else {
                g2d.fill(path);
            }
        } else {
            g2d.draw(path);
        }
    }

    @Override
    public void drawPixels(ImageProcessor ip) {
        int saveWidth = ip.getLineWidth();
        if (this.getStrokeWidth() > 1.0f) {
            ip.setLineWidth(Math.round(this.getStrokeWidth()));
        }
        double xbase = this.getXBase();
        double ybase = this.getYBase();
        if (this.xSpline != null) {
            ip.moveTo((int)Math.round(xbase + (double)this.xSpline[0]), (int)Math.round(ybase + (double)this.ySpline[0]));
            for (int i = 1; i < this.splinePoints; ++i) {
                ip.lineTo((int)Math.round(xbase + (double)this.xSpline[i]), (int)Math.round(ybase + (double)this.ySpline[i]));
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo((int)Math.round(xbase + (double)this.xSpline[0]), (int)Math.round(ybase + (double)this.ySpline[0]));
            }
        } else if (this.xpf != null) {
            ip.moveTo((int)Math.round(xbase + (double)this.xpf[0]), (int)Math.round(ybase + (double)this.ypf[0]));
            for (int i = 1; i < this.nPoints; ++i) {
                ip.lineTo((int)Math.round(xbase + (double)this.xpf[i]), (int)Math.round(ybase + (double)this.ypf[i]));
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo((int)Math.round(xbase + (double)this.xpf[0]), (int)Math.round(ybase + (double)this.ypf[0]));
            }
        } else {
            ip.moveTo(this.x + this.xp[0], this.y + this.yp[0]);
            for (int i = 1; i < this.nPoints; ++i) {
                ip.lineTo(this.x + this.xp[i], this.y + this.yp[i]);
            }
            if (this.type == 2 || this.type == 3 || this.type == 4) {
                ip.lineTo(this.x + this.xp[0], this.y + this.yp[0]);
            }
        }
        ip.setLineWidth(saveWidth);
        this.updateFullWindow = true;
    }

    @Override
    protected void grow(int sx, int sy) {
    }

    protected void updatePolygon() {
        double mag;
        int basex = 0;
        int basey = 0;
        if (this.ic != null) {
            Rectangle srcRect = this.ic.getSrcRect();
            basex = srcRect.x;
            basey = srcRect.y;
        }
        if ((mag = this.getMagnification()) == 1.0 && basex == 0 && basey == 0) {
            if (this.xpf != null) {
                float xbase = (float)this.getXBase();
                float ybase = (float)this.getYBase();
                for (int i = 0; i < this.nPoints; ++i) {
                    this.xp2[i] = Math.round(this.xpf[i] + xbase);
                    this.yp2[i] = Math.round(this.ypf[i] + ybase);
                }
            } else {
                for (int i = 0; i < this.nPoints; ++i) {
                    this.xp2[i] = this.xp[i] + this.x;
                    this.yp2[i] = this.yp[i] + this.y;
                }
            }
        } else if (this.xpf != null) {
            float xbase = (float)this.getXBase();
            float ybase = (float)this.getYBase();
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.screenXD(this.xpf[i] + xbase);
                this.yp2[i] = this.screenYD(this.ypf[i] + ybase);
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp2[i] = this.screenXD(this.xp[i] + this.x);
                this.yp2[i] = this.screenYD(this.yp[i] + this.y);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int tool;
        int sx = e.getX();
        int sy = e.getY();
        int flags = e.getModifiers();
        boolean bl = this.constrain = (flags & 1) != 0;
        if (this.constrain) {
            int dx = sx - this.previousSX;
            int dy = sy - this.previousSY;
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
            sx = this.previousSX + dx;
            sy = this.previousSY + dy;
        }
        if ((tool = Toolbar.getToolId()) != 2 && tool != 5 && tool != 14) {
            this.imp.deleteRoi();
            this.imp.draw();
            return;
        }
        if (IJ.altKeyDown()) {
            this.wipeBack();
        }
        this.drawRubberBand(sx, sy);
        this.degrees = Double.NaN;
        double len = -1.0;
        if (this.nPoints > 1) {
            double y2;
            double x2;
            double y1;
            double x1;
            if (this.xpf != null) {
                x1 = this.xpf[this.nPoints - 2];
                y1 = this.ypf[this.nPoints - 2];
                x2 = this.xpf[this.nPoints - 1];
                y2 = this.ypf[this.nPoints - 1];
            } else {
                x1 = this.xp[this.nPoints - 2];
                y1 = this.yp[this.nPoints - 2];
                x2 = this.xp[this.nPoints - 1];
                y2 = this.yp[this.nPoints - 1];
            }
            this.degrees = this.getFloatAngle(x1, y1, x2, y2);
            if (tool != 14) {
                Calibration cal = this.imp.getCalibration();
                double pw = cal.pixelWidth;
                double ph = cal.pixelHeight;
                if (IJ.altKeyDown()) {
                    pw = 1.0;
                    ph = 1.0;
                }
                len = Math.sqrt((x2 - x1) * pw * (x2 - x1) * pw + (y2 - y1) * ph * (y2 - y1) * ph);
            }
        }
        if (tool == 14) {
            if (this.nPoints == 2) {
                this.angle1 = this.degrees;
            } else if (this.nPoints == 3) {
                double angle2 = this.xpf != null ? this.getFloatAngle(this.xpf[1], this.ypf[1], this.xpf[2], this.ypf[2]) : this.getAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
                this.degrees = Math.abs(180.0 - Math.abs(this.angle1 - angle2));
                if (this.degrees > 180.0) {
                    this.degrees = 360.0 - this.degrees;
                }
            }
        }
        String length = len != -1.0 ? ", length=" + IJ.d2s(len) : "";
        double degrees2 = tool == 14 && this.nPoints == 3 && Prefs.reflexAngle ? 360.0 - this.degrees : this.degrees;
        String angle = !Double.isNaN(this.degrees) ? ", angle=" + IJ.d2s(degrees2) : "";
        int ox = this.ic.offScreenX(sx);
        int oy = this.ic.offScreenY(sy);
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + length + angle);
    }

    protected void wipeBack() {
        int p3;
        Roi prevRoi = Roi.getPreviousRoi();
        if (prevRoi != null && prevRoi.modState == 2) {
            return;
        }
        double correctionRadius = 20.0;
        if (this.ic != null) {
            correctionRadius /= this.ic.getMagnification();
        }
        boolean found = false;
        int p1 = p3 = this.nPoints - 1;
        while (p1 > 0 && !found) {
            double dx = this.xpf != null ? (double)(this.xpf[p3] - this.xpf[p1]) : (double)(this.xp[p3] - this.xp[--p1]);
            double d = this.xpf != null ? (double)(this.ypf[p3] - this.ypf[p1]) : (double)(this.yp[p3] - this.yp[p1]);
            double dy = d;
            double dist = Math.sqrt(dx * dx + dy * dy);
            if (!(dist > correctionRadius)) continue;
            found = true;
        }
        boolean killed = false;
        int safety = 10;
        do {
            killed = false;
            --safety;
            for (int p2 = p1 + 1; p2 < p3; ++p2) {
                double dx1 = this.xpf != null ? (double)(this.xpf[p2] - this.xpf[p1]) : (double)(this.xp[p2] - this.xp[p1]);
                double dy1 = this.xpf != null ? (double)(this.ypf[p2] - this.ypf[p1]) : (double)(this.yp[p2] - this.yp[p1]);
                double dx2 = this.xpf != null ? (double)(this.xpf[p3] - this.xpf[p1]) : (double)(this.xp[p3] - this.xp[p1]);
                double dy2 = this.xpf != null ? (double)(this.ypf[p3] - this.ypf[p1]) : (double)(this.yp[p3] - this.yp[p1]);
                double kk = 1.0;
                if (this instanceof FreehandRoi) {
                    kk = 0.8;
                }
                if (!(dx1 * dx1 + dy1 * dy1 > kk * (dx2 * dx2 + dy2 * dy2))) continue;
                if (this.xpf != null) {
                    this.xpf[p2] = this.xpf[p3];
                    this.ypf[p2] = this.ypf[p3];
                } else {
                    this.xp[p2] = this.xp[p3];
                    this.yp[p2] = this.yp[p3];
                }
                p3 = p2;
                this.nPoints = p2 + 1;
                killed = true;
            }
        } while (killed && safety > 0);
    }

    void drawRubberBand(int sx, int sy) {
        double mag;
        int y2;
        int x2;
        int y1;
        int x1;
        double oxd = this.offScreenXD(sx);
        double oyd = this.offScreenYD(sy);
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        if (this.xpf != null) {
            x1 = (int)this.xpf[this.nPoints - 2] + this.x;
            y1 = (int)this.ypf[this.nPoints - 2] + this.y;
            x2 = (int)this.xpf[this.nPoints - 1] + this.x;
            y2 = (int)this.ypf[this.nPoints - 1] + this.y;
        } else {
            x1 = this.xp[this.nPoints - 2] + this.x;
            y1 = this.yp[this.nPoints - 2] + this.y;
            x2 = this.xp[this.nPoints - 1] + this.x;
            y2 = this.yp[this.nPoints - 1] + this.y;
        }
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymax = 0;
        if (x1 < xmin) {
            xmin = x1;
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (ox < xmin) {
            xmin = ox;
        }
        if (x1 > xmax) {
            xmax = x1;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (ox > xmax) {
            xmax = ox;
        }
        if (y1 < ymin) {
            ymin = y1;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (oy < ymin) {
            ymin = oy;
        }
        if (y1 > ymax) {
            ymax = y1;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if (oy > ymax) {
            ymax = oy;
        }
        int margin = this.boxSize;
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            margin = (int)((double)margin / mag);
        }
        margin = (int)((float)margin + this.getStrokeWidth());
        if (IJ.altKeyDown()) {
            margin += 20;
        }
        if (this.xpf != null) {
            this.xpf[this.nPoints - 1] = (float)(oxd - this.getXBase());
            this.ypf[this.nPoints - 1] = (float)(oyd - this.getYBase());
        } else {
            this.xp[this.nPoints - 1] = ox - this.x;
            this.yp[this.nPoints - 1] = oy - this.y;
        }
        if (this.type == 6 && Prefs.splineFitLines) {
            this.fitSpline();
            this.imp.draw();
        } else {
            this.imp.draw(xmin - margin, ymin - margin, xmax - xmin + margin * 2, ymax - ymin + margin * 2);
        }
    }

    void finishPolygon() {
        if (this.xpf != null) {
            double xbase0 = this.getXBase();
            double ybase0 = this.getYBase();
            FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            this.bounds = poly.getFloatBounds();
            int i = 0;
            while (i < this.nPoints) {
                int n = i;
                this.xpf[n] = this.xpf[n] - (float)this.bounds.x;
                int n2 = i++;
                this.ypf[n2] = this.ypf[n2] - (float)this.bounds.y;
            }
            if (this.xSpline != null) {
                i = 0;
                while (i < this.splinePoints) {
                    int n = i;
                    this.xSpline[n] = this.xSpline[n] + (float)(xbase0 - this.bounds.x);
                    int n3 = i++;
                    this.ySpline[n3] = this.ySpline[n3] + (float)(ybase0 - this.bounds.y);
                }
            }
            this.setIntBounds(this.bounds);
        } else {
            Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
            Rectangle r = poly.getBounds();
            this.x = r.x;
            this.y = r.y;
            this.width = r.width;
            this.height = r.height;
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp[i] = this.xp[i] - this.x;
                this.yp[i] = this.yp[i] - this.y;
            }
            if (this.useLineSubpixelConvention()) {
                ++this.width;
                ++this.height;
            }
            this.bounds = null;
        }
        if (this.nPoints < 2 || this.type != 7 && this.type != 6 && this.type != 8 && (this.nPoints < 3 || this.width == 0 || this.height == 0)) {
            if (this.imp != null) {
                this.imp.deleteRoi();
            }
            if (this.type != 10) {
                return;
            }
        }
        this.state = 3;
        if (this.imp != null && this.type != 4) {
            this.imp.draw(this.x - 5, this.y - 5, this.width + 10, this.height + 10);
        }
        this.oldX = this.x;
        this.oldY = this.y;
        this.oldWidth = this.width;
        this.oldHeight = this.height;
        if (Recorder.record && this.userCreated && (this.type == 2 || this.type == 6 || this.type == 8 || this.type == 10 && Recorder.scriptMode() && this.nPoints == 3)) {
            Recorder.recordRoi(this.getPolygon(), this.type);
        }
        if (this.type != 10) {
            this.modifyRoi();
        }
        LineWidthAdjuster.update();
        this.notifyListeners(5);
        this.updateFullWindow = true;
    }

    public void exitConstructingMode() {
        if (this.type == 6 && this.state == 0) {
            this.addOffset();
            this.finishPolygon();
        }
    }

    @Override
    protected void moveHandle(int sx, int sy) {
        if (this.constrain) {
            int dx = sx - this.previousSX;
            int dy = sy - this.previousSY;
            if (Math.abs(dx) > Math.abs(dy)) {
                dy = 0;
            } else {
                dx = 0;
            }
            sx = this.previousSX + dx;
            sy = this.previousSY + dy;
        }
        if (this.clipboard != null) {
            return;
        }
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        if (this.xpf != null) {
            this.xpf[this.activeHandle] = (float)(this.offScreenXD(sx) - this.getXBase());
            this.ypf[this.activeHandle] = (float)(this.offScreenYD(sy) - this.getYBase());
        } else {
            this.xp[this.activeHandle] = ox - this.x;
            this.yp[this.activeHandle] = oy - this.y;
        }
        if (this.xSpline != null) {
            this.fitSpline(this.splinePoints);
            this.imp.draw();
        } else {
            if (!this.subPixelResolution() || this.type == 10 && this.nPoints == 1) {
                this.resetBoundingRect();
            }
            if (this.type == 10 && this.width == 0 && this.height == 0) {
                this.width = 1;
                this.height = 1;
            }
            this.updateClipRectAndDraw();
        }
        String angle = this.type == 8 ? this.getAngleAsString() : "";
        IJ.showStatus(this.imp.getLocationAsString(ox, oy) + angle);
    }

    void updateClipRectAndDraw() {
        int y2;
        int x2;
        if (this.xpf != null) {
            this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
            this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
        }
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = 0;
        int ymax = 0;
        if (this.activeHandle > 0) {
            x2 = this.x + this.xp[this.activeHandle - 1];
            y2 = this.y + this.yp[this.activeHandle - 1];
        } else {
            x2 = this.x + this.xp[this.nPoints - 1];
            y2 = this.y + this.yp[this.nPoints - 1];
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        x2 = this.x + this.xp[this.activeHandle];
        y2 = this.y + this.yp[this.activeHandle];
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        if (this.activeHandle < this.nPoints - 1) {
            x2 = this.x + this.xp[this.activeHandle + 1];
            y2 = this.y + this.yp[this.activeHandle + 1];
        } else {
            x2 = this.x + this.xp[0];
            y2 = this.y + this.yp[0];
        }
        if (x2 < xmin) {
            xmin = x2;
        }
        if (y2 < ymin) {
            ymin = y2;
        }
        if (x2 > xmax) {
            xmax = x2;
        }
        if (y2 > ymax) {
            ymax = y2;
        }
        int xmin2 = xmin;
        int ymin2 = ymin;
        int xmax2 = xmax;
        int ymax2 = ymax;
        if (this.xClipMin < xmin2) {
            xmin2 = this.xClipMin;
        }
        if (this.yClipMin < ymin2) {
            ymin2 = this.yClipMin;
        }
        if (this.xClipMax > xmax2) {
            xmax2 = this.xClipMax;
        }
        if (this.yClipMax > ymax2) {
            ymax2 = this.yClipMax;
        }
        this.xClipMin = xmin;
        this.yClipMin = ymin;
        this.xClipMax = xmax;
        this.yClipMax = ymax;
        double mag = this.ic.getMagnification();
        int handleSize = this.type == 10 ? this.getHandleSize() + 25 : this.getHandleSize();
        double strokeWidth = this.getStrokeWidth();
        if (strokeWidth < 1.0) {
            strokeWidth = 1.0;
        }
        if ((double)handleSize < strokeWidth && this.isLine()) {
            handleSize = (int)strokeWidth;
        }
        int m = mag < 1.0 ? (int)((double)handleSize / mag) : handleSize;
        m = (int)((double)m * strokeWidth);
        this.imp.draw(xmin2 - m, ymin2 - m, xmax2 - xmin2 + m * 2, ymax2 - ymin2 + m * 2);
    }

    protected void resetBoundingRect() {
        int i;
        if (this.xpf != null) {
            this.resetSubPixelBoundingRect();
            this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
            this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
            return;
        }
        int xmin = Integer.MAX_VALUE;
        int xmax = -xmin;
        int ymin = xmin;
        int ymax = xmax;
        for (i = 0; i < this.nPoints; ++i) {
            int yy;
            int xx = this.xp[i];
            if (xx < xmin) {
                xmin = xx;
            }
            if (xx > xmax) {
                xmax = xx;
            }
            if ((yy = this.yp[i]) < ymin) {
                ymin = yy;
            }
            if (yy <= ymax) continue;
            ymax = yy;
        }
        if (xmin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.xp[n] = this.xp[n] - xmin;
            }
        }
        if (ymin != 0) {
            i = 0;
            while (i < this.nPoints) {
                int n = i++;
                this.yp[n] = this.yp[n] - ymin;
            }
        }
        this.x += xmin;
        this.y += ymin;
        this.width = xmax - xmin;
        this.height = ymax - ymin;
        if (this.useLineSubpixelConvention()) {
            ++this.width;
            ++this.height;
        }
        this.bounds = null;
    }

    private void resetSubPixelBoundingRect() {
        if (this.xSpline != null) {
            this.resetSplineFitBoundingRect();
            return;
        }
        float xbase = (float)this.getXBase();
        float ybase = (float)this.getYBase();
        for (int i = 0; i < this.nPoints; ++i) {
            this.xpf[i] = this.xpf[i] + xbase;
            this.ypf[i] = this.ypf[i] + ybase;
        }
        FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
        this.bounds = poly.getFloatBounds();
        this.setIntBounds(this.bounds);
        xbase = (float)this.bounds.x;
        ybase = (float)this.bounds.y;
        int i = 0;
        while (i < this.nPoints) {
            int n = i;
            this.xpf[n] = this.xpf[n] - xbase;
            int n2 = i++;
            this.ypf[n2] = this.ypf[n2] - ybase;
        }
    }

    private void resetSplineFitBoundingRect() {
        if (this.splinePoints == 0) {
            return;
        }
        float xbase = (float)this.getXBase();
        float ybase = (float)this.getYBase();
        float xSpline0 = this.xSpline[0];
        float ySpline0 = this.ySpline[0];
        for (int i = 0; i < this.splinePoints; ++i) {
            this.xSpline[i] = this.xSpline[i] + xbase;
            this.ySpline[i] = this.ySpline[i] + ybase;
        }
        FloatPolygon poly = new FloatPolygon(this.xSpline, this.ySpline, this.splinePoints);
        this.bounds = poly.getFloatBounds();
        this.setIntBounds(this.bounds);
        xbase = (float)this.bounds.x;
        ybase = (float)this.bounds.y;
        int i = 0;
        while (i < this.splinePoints) {
            int n = i;
            this.xSpline[n] = this.xSpline[n] - xbase;
            int n2 = i++;
            this.ySpline[n2] = this.ySpline[n2] - ybase;
        }
        i = 0;
        while (i < this.nPoints) {
            int n = i;
            this.xpf[n] = this.xpf[n] - (xSpline0 - this.xSpline[0]);
            int n3 = i++;
            this.ypf[n3] = this.ypf[n3] - (ySpline0 - this.ySpline[0]);
        }
    }

    String getAngleAsString() {
        double angle1 = 0.0;
        double angle2 = 0.0;
        if (this.xpf != null) {
            angle1 = this.getFloatAngle(this.xpf[0], this.ypf[0], this.xpf[1], this.ypf[1]);
            angle2 = this.getFloatAngle(this.xpf[1], this.ypf[1], this.xpf[2], this.ypf[2]);
        } else {
            angle1 = this.getFloatAngle(this.xp[0], this.yp[0], this.xp[1], this.yp[1]);
            angle2 = this.getFloatAngle(this.xp[1], this.yp[1], this.xp[2], this.yp[2]);
        }
        this.degrees = Math.abs(180.0 - Math.abs(angle1 - angle2));
        if (this.degrees > 180.0) {
            this.degrees = 360.0 - this.degrees;
        }
        double degrees2 = Prefs.reflexAngle && this.type == 8 ? 360.0 - this.degrees : this.degrees;
        return ", angle=" + IJ.d2s(degrees2);
    }

    @Override
    protected void mouseDownInHandle(int handle, int sx, int sy) {
        if (this.state == 0) {
            return;
        }
        int ox = this.offScreenX(sx);
        int oy = this.offScreenY(sy);
        double oxd = this.offScreenXD(sx);
        double oyd = this.offScreenYD(sy);
        if (!(!IJ.altKeyDown() && !IJ.controlKeyDown() || this.nPoints <= 3 && this.type != 10 || this instanceof RotatedRectRoi)) {
            this.deleteHandle(oxd, oyd);
            return;
        }
        if (IJ.shiftKeyDown() && this.type != 10 && !(this instanceof RotatedRectRoi)) {
            this.addHandle(oxd, oyd);
            return;
        }
        super.mouseDownInHandle(handle, sx, sy);
        int m = this.ic != null ? (int)(10.0 / this.ic.getMagnification()) : 1;
        this.xClipMin = ox - m;
        this.yClipMin = oy - m;
        this.xClipMax = ox + m;
        this.yClipMax = oy + m;
    }

    public void deleteHandle(double ox, double oy) {
        FloatPolygon points;
        int pointToDelete;
        boolean splineFit;
        if (this.imp == null) {
            return;
        }
        if (this.nPoints <= 1) {
            this.imp.deleteRoi();
            return;
        }
        boolean bl = splineFit = this.xSpline != null;
        if (splineFit) {
            this.removeSplineFit();
        }
        if ((pointToDelete = this.getClosestPoint(ox, oy, points = this.getFloatPolygon())) >= 0) {
            this.deletePoint(pointToDelete);
            if (splineFit) {
                this.fitSpline(this.splinePoints);
            }
            this.imp.draw();
        }
    }

    protected void deletePoint(int index) {
        if (index < 0 || index >= this.nPoints) {
            return;
        }
        for (int i = index; i < this.nPoints - 1; ++i) {
            if (this.xp != null) {
                this.xp[i] = this.xp[i + 1];
                this.yp[i] = this.yp[i + 1];
            }
            if (this.xp2 != null) {
                this.xp2[i] = this.xp2[i + 1];
                this.yp2[i] = this.yp2[i + 1];
            }
            if (this.xpf == null) continue;
            this.xpf[i] = this.xpf[i + 1];
            this.ypf[i] = this.ypf[i + 1];
        }
        --this.nPoints;
    }

    void addHandle(double ox, double oy) {
        int pointToDuplicate;
        if (this.imp == null || this.type == 8) {
            return;
        }
        boolean splineFit = this.xSpline != null;
        this.xSpline = null;
        FloatPolygon points = this.getFloatPolygon();
        int n = points.npoints;
        this.modState = 0;
        Roi prevRoi = Roi.getPreviousRoi();
        if (prevRoi != null) {
            prevRoi.modState = 0;
        }
        if ((pointToDuplicate = this.getClosestPoint(ox, oy, points)) < 0) {
            return;
        }
        FloatPolygon points2 = new FloatPolygon();
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 == pointToDuplicate) {
                int i3;
                int i1 = i2 - 1;
                if (i1 == -1) {
                    int n2 = i1 = this.isLine() ? i2 : n - 1;
                }
                if ((i3 = i2 + 1) == n) {
                    i3 = this.isLine() ? i2 : 0;
                }
                double x1 = points.xpoints[i1] + 2.0f * (points.xpoints[i2] - points.xpoints[i1]) / 3.0f;
                double y1 = points.ypoints[i1] + 2.0f * (points.ypoints[i2] - points.ypoints[i1]) / 3.0f;
                double x2 = points.xpoints[i2] + (points.xpoints[i3] - points.xpoints[i2]) / 3.0f;
                double y2 = points.ypoints[i2] + (points.ypoints[i3] - points.ypoints[i2]) / 3.0f;
                points2.addPoint(x1, y1);
                points2.addPoint(x2, y2);
                continue;
            }
            points2.addPoint(points.xpoints[i2], points.ypoints[i2]);
        }
        if (this.type == 10) {
            this.imp.setRoi(new PointRoi(points2));
        } else {
            this.setPolygon(points2);
            if (splineFit) {
                this.fitSpline(this.splinePoints);
            }
            if (this.imp != null) {
                this.imp.draw();
            }
        }
    }

    private void setPolygon(FloatPolygon p2) {
        this.nPoints = p2.npoints;
        if (this.nPoints >= this.maxPoints) {
            this.enlargeArrays();
        }
        float xbase = (float)this.getXBase();
        float ybase = (float)this.getYBase();
        if (this.xp == null) {
            this.xp = new int[this.maxPoints];
            this.yp = new int[this.maxPoints];
        }
        for (int i = 0; i < this.nPoints; ++i) {
            this.xp[i] = (int)(p2.xpoints[i] - (float)this.x);
            this.yp[i] = (int)(p2.ypoints[i] - (float)this.y);
            if (this.xpf == null) continue;
            this.xpf[i] = p2.xpoints[i] - xbase;
            this.ypf[i] = p2.ypoints[i] - ybase;
        }
    }

    protected int getClosestPoint(double x, double y, FloatPolygon points) {
        int index = -1;
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < points.npoints; ++i) {
            double dx = (double)points.xpoints[i] - x;
            double dy = (double)points.ypoints[i] - y;
            double distance2 = dx * dx + dy * dy;
            if (!(distance2 < distance)) continue;
            distance = distance2;
            index = i;
        }
        return index;
    }

    public void fitSpline(int evaluationPoints) {
        float[][] spline = this.getSpline(evaluationPoints, this.xSpline, this.ySpline);
        this.setSpline(spline[0], spline[1]);
    }

    void setSpline(float[] xSpline, float[] ySpline) {
        this.xSpline = xSpline;
        this.ySpline = ySpline;
        this.splinePoints = xSpline.length;
        this.cachedMask = null;
        this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
        this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
        if (this.state == 3) {
            this.resetBoundingRect();
        }
    }

    float[][] getSpline(int evaluationPoints, float[] xSpline, float[] ySpline) {
        if (this.xpf == null) {
            this.xpf = PolygonRoi.toFloat(this.xp);
            this.ypf = PolygonRoi.toFloat(this.yp);
            this.enableSubPixelResolution();
        }
        if (xSpline == null || xSpline.length != evaluationPoints) {
            xSpline = new float[evaluationPoints];
        }
        if (ySpline == null || ySpline.length != evaluationPoints) {
            ySpline = new float[evaluationPoints];
        }
        int nNodes = this.isLine() ? this.nPoints : this.nPoints + 1;
        double length = this.getUncalibratedLength();
        float[] nodePositions = new float[nNodes];
        float lastNodePosition = 0.0f;
        nodePositions[0] = 0.0f;
        for (int i = 1; i < this.nPoints; ++i) {
            float dx = this.xpf[i] - this.xpf[i - 1];
            float dy = this.ypf[i] - this.ypf[i - 1];
            float dLength = (float)Math.sqrt(Math.sqrt(dx * dx + dy * dy));
            if (dLength < 0.001f) {
                dLength = 0.001f;
            }
            nodePositions[i] = lastNodePosition += dLength;
        }
        if (!this.isLine()) {
            float dx = this.xpf[this.nPoints - 1] - this.xpf[0];
            float dy = this.ypf[this.nPoints - 1] - this.ypf[0];
            float dLength = (float)Math.sqrt(Math.sqrt(dx * dx + dy * dy));
            if (dLength < 0.001f) {
                dLength = 0.001f;
            }
            nodePositions[nNodes - 1] = lastNodePosition += dLength;
            if (this.xpf.length < nNodes) {
                this.enlargeArrays(nNodes);
            }
            this.xpf[nNodes - 1] = this.xpf[0];
            this.ypf[nNodes - 1] = this.ypf[0];
        }
        SplineFitter sfx = new SplineFitter(nodePositions, this.xpf, nNodes, !this.isLine());
        SplineFitter sfy = new SplineFitter(nodePositions, this.ypf, nNodes, !this.isLine());
        double scale = (double)lastNodePosition / (double)(evaluationPoints - 1);
        for (int i = 0; i < evaluationPoints; ++i) {
            double xvalue = (double)i * scale;
            xSpline[i] = (float)sfx.evalSpline(xvalue);
            ySpline[i] = (float)sfy.evalSpline(xvalue);
        }
        return new float[][]{xSpline, ySpline};
    }

    public void fitSpline() {
        double mag;
        double length = this.getUncalibratedLength();
        int evaluationPoints = (int)(length / 2.0);
        if (this.ic != null && (mag = this.ic.getMagnification()) < 1.0) {
            evaluationPoints = (int)((double)evaluationPoints * mag);
        }
        if (evaluationPoints < 100) {
            evaluationPoints = 100;
        }
        this.fitSpline(evaluationPoints);
    }

    public void removeSplineFit() {
        this.xSpline = null;
        this.ySpline = null;
    }

    public boolean isSplineFit() {
        return this.xSpline != null;
    }

    public void fitSplineForStraightening() {
        float[][] spline = this.getSpline((int)(this.getUncalibratedLength() * 2.0) + 1, null, null);
        spline = PolygonRoi.getEquidistantPoints(spline[0], spline[1], spline[0].length, 1.0, null);
        this.setSpline(spline[0], spline[1]);
    }

    static float[][] getEquidistantPoints(float[] xpoints, float[] ypoints, int npoints, double segmentLength, ImagePlus imp) {
        if (xpoints == null || xpoints == null || npoints <= 0) {
            return null;
        }
        if (xpoints.length < npoints) {
            npoints = xpoints.length;
        }
        if (ypoints.length < npoints) {
            npoints = ypoints.length;
        }
        double length = PolygonRoi.getLength(xpoints, ypoints, npoints, false, imp);
        int npOut = (int)Math.round(length / segmentLength) + 1;
        double step = length / (double)(npOut - 1);
        float[] xpOut = new float[npOut];
        float[] ypOut = new float[npOut];
        double pixelWidth = 1.0;
        double pixelHeight = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            pixelWidth = cal.pixelWidth;
            pixelHeight = cal.pixelHeight;
        }
        xpOut[0] = xpoints[0];
        ypOut[0] = ypoints[0];
        double lengthRead = 0.0;
        int pointsWritten = 1;
        double x2 = xpoints[0];
        double y2 = ypoints[0];
        for (int i = 1; i < npoints; ++i) {
            double x1 = x2;
            double y1 = y2;
            x2 = xpoints[i];
            y2 = ypoints[i];
            double dx = x2 - x1;
            double dy = y2 - y1;
            double distance = Math.sqrt(PolygonRoi.sqr(dx * pixelWidth) + PolygonRoi.sqr(dy * pixelHeight));
            for (double distanceOverNextWrite = (lengthRead += distance) - (double)pointsWritten * step; (distanceOverNextWrite >= 0.0 || i == npoints - 1) && pointsWritten < npOut; distanceOverNextWrite -= step, ++pointsWritten) {
                double fractionOverNextWrite = distanceOverNextWrite / distance;
                if (distance == 0.0) {
                    fractionOverNextWrite = 0.0;
                }
                xpOut[pointsWritten] = (float)(x2 - fractionOverNextWrite * dx);
                ypOut[pointsWritten] = (float)(y2 - fractionOverNextWrite * dy);
            }
        }
        return new float[][]{xpOut, ypOut, {(float)step}};
    }

    @Override
    protected void handleMouseUp(int sx, int sy) {
        if (this.state == 1) {
            this.state = 3;
            return;
        }
        if (this.state == 4) {
            this.cachedMask = null;
            this.state = 3;
            this.updateClipRect();
            this.oldX = this.x;
            this.oldY = this.y;
            this.oldWidth = this.width;
            this.oldHeight = this.height;
            if (this.subPixelResolution()) {
                this.resetBoundingRect();
            }
            return;
        }
        if (this.state != 0) {
            return;
        }
        if (IJ.spaceBarDown()) {
            return;
        }
        boolean samePoint = false;
        samePoint = this.xpf != null ? this.xpf[this.nPoints - 2] == this.xpf[this.nPoints - 1] && this.ypf[this.nPoints - 2] == this.ypf[this.nPoints - 1] : this.xp[this.nPoints - 2] == this.xp[this.nPoints - 1] && this.yp[this.nPoints - 2] == this.yp[this.nPoints - 1];
        boolean doubleClick = System.currentTimeMillis() - this.mouseUpTime <= 300L;
        int size = this.boxSize + 2;
        int size2 = this.boxSize / 2 + 1;
        Rectangle biggerStartBox = new Rectangle(this.screenXD(this.startXD) - 5, this.screenYD(this.startYD) - 5, 10, 10);
        if (this.nPoints > 2 && (biggerStartBox.contains(sx, sy) || this.offScreenXD(sx) == this.startXD && this.offScreenYD(sy) == this.startYD || samePoint && doubleClick)) {
            boolean okayToFinish = true;
            if (this.type == 2 && samePoint && doubleClick && this.nPoints > 25) {
                okayToFinish = IJ.showMessageWithCancel("Polygon Tool", "Complete the selection?");
            }
            if (okayToFinish) {
                --this.nPoints;
                this.addOffset();
                this.finishPolygon();
                return;
            }
        } else if (!samePoint) {
            this.mouseUpTime = System.currentTimeMillis();
            if (this.type == 8 && this.nPoints == 3) {
                this.addOffset();
                this.finishPolygon();
                return;
            }
            if (this.xpf != null) {
                this.xpf[this.nPoints] = this.xpf[this.nPoints - 1];
                this.ypf[this.nPoints] = this.ypf[this.nPoints - 1];
                ++this.nPoints;
                if (this.nPoints == this.xpf.length) {
                    this.enlargeArrays();
                }
            } else {
                this.xp[this.nPoints] = this.xp[this.nPoints - 1];
                this.yp[this.nPoints] = this.yp[this.nPoints - 1];
                ++this.nPoints;
                if (this.nPoints == this.xp.length) {
                    this.enlargeArrays();
                }
            }
            if (this.constrain) {
                int dx = sx - this.previousSX;
                int dy = sy - this.previousSY;
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0;
                } else {
                    dx = 0;
                }
                sx = this.previousSX + dx;
                sy = this.previousSY + dy;
            }
            this.previousSX = sx;
            this.previousSY = sy;
            this.notifyListeners(4);
        }
    }

    protected void addOffset() {
        if (this.xpf != null) {
            float xbase = (float)this.getXBase();
            float ybase = (float)this.getYBase();
            for (int i = 0; i < this.nPoints; ++i) {
                this.xpf[i] = this.xpf[i] + xbase;
                this.ypf[i] = this.ypf[i] + ybase;
            }
        } else {
            for (int i = 0; i < this.nPoints; ++i) {
                this.xp[i] = this.xp[i] + this.x;
                this.yp[i] = this.yp[i] + this.y;
            }
        }
    }

    @Override
    public boolean contains(int x, int y) {
        if (!super.contains(x, y)) {
            return false;
        }
        if (this.xSpline != null) {
            FloatPolygon poly = new FloatPolygon(this.xSpline, this.ySpline, this.splinePoints);
            return poly.contains((double)x - this.getXBase() + 0.4999, (double)y - this.getYBase() + 0.5);
        }
        if (this.xpf != null) {
            FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            return poly.contains((double)x - this.getXBase() + 0.4999, (double)y - this.getYBase() + 0.5);
        }
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        return poly.contains((double)(x - this.x) + 0.4999, (double)(y - this.y) + 0.5);
    }

    @Override
    public boolean containsPoint(double x, double y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        if (this.xSpline != null) {
            FloatPolygon poly = new FloatPolygon(this.xSpline, this.ySpline, this.splinePoints);
            return poly.contains(x - this.getXBase() + 1.0E-7, y - this.getYBase() + 1.0E-10);
        }
        if (this.xpf != null) {
            FloatPolygon poly = new FloatPolygon(this.xpf, this.ypf, this.nPoints);
            return poly.contains(x - this.getXBase() + 1.0E-7, y - this.getYBase() + 1.0E-10);
        }
        Polygon poly = new Polygon(this.xp, this.yp, this.nPoints);
        return poly.contains(x - (double)this.x + 1.0E-7, y - (double)this.y + 1.0E-10);
    }

    @Override
    public int isHandle(int sx, int sy) {
        if (this.xSpline == null && this.type != 2 && this.type != 6 && this.type != 8 && this.type != 10 || this.clipboard != null) {
            return -1;
        }
        int size = this.getHandleSize() + 5;
        int halfSize = size / 2;
        int handle = -1;
        for (int i = 0; i < this.nPoints; ++i) {
            int sx2 = this.xp2[i] - halfSize;
            int sy2 = this.yp2[i] - halfSize;
            if (sx < sx2 || sx > sx2 + size || sy < sy2 || sy > sy2 + size) continue;
            handle = i;
            break;
        }
        return handle;
    }

    @Override
    public ImageProcessor getMask() {
        ImageProcessor mask = this.cachedMask;
        if (mask != null && mask.getPixels() != null && mask.getWidth() == this.width && mask.getHeight() == this.height) {
            return mask;
        }
        PolygonFiller pf = new PolygonFiller();
        if (this.xSpline != null) {
            pf.setPolygon(this.xSpline, this.ySpline, this.splinePoints, this.getXBase() - (double)this.x, this.getYBase() - (double)this.y);
        } else if (this.xpf != null) {
            pf.setPolygon(this.xpf, this.ypf, this.nPoints, this.getXBase() - (double)this.x, this.getYBase() - (double)this.y);
        } else {
            pf.setPolygon(this.xp, this.yp, this.nPoints);
        }
        this.cachedMask = mask = pf.getMask(this.width, this.height);
        return mask;
    }

    double getSmoothedLineLength(ImagePlus imp) {
        if (this.subPixelResolution() && this.xpf != null) {
            return this.getFloatSmoothedLineLength(imp);
        }
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = (double)(this.xp[0] + this.xp[1] + this.xp[2]) / 3.0 - (double)this.xp[0];
        double dy = (double)(this.yp[0] + this.yp[1] + this.yp[2]) / 3.0 - (double)this.yp[0];
        length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        for (int i = 1; i < this.nPoints - 2; ++i) {
            dx = (double)(this.xp[i + 2] - this.xp[i - 1]) / 3.0;
            dy = (double)(this.yp[i + 2] - this.yp[i - 1]) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        dx = (double)this.xp[this.nPoints - 1] - (double)(this.xp[this.nPoints - 3] + this.xp[this.nPoints - 2] + this.xp[this.nPoints - 1]) / 3.0;
        dy = (double)this.yp[this.nPoints - 1] - (double)(this.yp[this.nPoints - 3] + this.yp[this.nPoints - 2] + this.yp[this.nPoints - 1]) / 3.0;
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getFloatSmoothedLineLength(ImagePlus imp) {
        double length = 0.0;
        double w2 = 1.0;
        double h2 = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = (double)(this.xpf[0] + this.xpf[1] + this.xpf[2]) / 3.0 - (double)this.xpf[0];
        double dy = (double)(this.ypf[0] + this.ypf[1] + this.ypf[2]) / 3.0 - (double)this.ypf[0];
        length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        for (int i = 1; i < this.nPoints - 2; ++i) {
            dx = (double)(this.xpf[i + 2] - this.xpf[i - 1]) / 3.0;
            dy = (double)(this.ypf[i + 2] - this.ypf[i - 1]) / 3.0;
            length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
        }
        dx = (double)this.xpf[this.nPoints - 1] - (double)(this.xpf[this.nPoints - 3] + this.xpf[this.nPoints - 2] + this.xpf[this.nPoints - 1]) / 3.0;
        dy = (double)this.ypf[this.nPoints - 1] - (double)(this.ypf[this.nPoints - 3] + this.ypf[this.nPoints - 2] + this.ypf[this.nPoints - 1]) / 3.0;
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getSmoothedPerimeter(ImagePlus imp) {
        if (this.subPixelResolution() && this.xpf != null) {
            return this.getFloatSmoothedPerimeter(imp);
        }
        double length = this.getSmoothedLineLength(imp);
        double w2 = 1.0;
        double h2 = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = this.xp[this.nPoints - 1] - this.xp[0];
        double dy = this.yp[this.nPoints - 1] - this.yp[0];
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getFloatSmoothedPerimeter(ImagePlus imp) {
        double length = this.getSmoothedLineLength(imp);
        double w2 = 1.0;
        double h2 = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            w2 = cal.pixelWidth * cal.pixelWidth;
            h2 = cal.pixelHeight * cal.pixelHeight;
        }
        double dx = this.xpf[this.nPoints - 1] - this.xpf[0];
        double dy = this.ypf[this.nPoints - 1] - this.ypf[0];
        return length += Math.sqrt(dx * dx * w2 + dy * dy * h2);
    }

    double getTracedPerimeter(ImagePlus imp) {
        if (this.xp == null) {
            return Double.NaN;
        }
        if (this.nPoints < 4) {
            return 0.0;
        }
        int sumdx = 0;
        int sumdy = 0;
        int nCorners = 0;
        int dx1 = this.xp[0] - this.xp[this.nPoints - 1];
        int dy1 = this.yp[0] - this.yp[this.nPoints - 1];
        int side1 = Math.abs(dx1) + Math.abs(dy1);
        boolean corner = false;
        for (int i = 0; i < this.nPoints; ++i) {
            int nexti = i + 1;
            if (nexti == this.nPoints) {
                nexti = 0;
            }
            int dx2 = this.xp[nexti] - this.xp[i];
            int dy2 = this.yp[nexti] - this.yp[i];
            sumdx += Math.abs(dx1);
            sumdy += Math.abs(dy1);
            int side2 = Math.abs(dx2) + Math.abs(dy2);
            if (side1 > 1 || !corner) {
                corner = true;
                ++nCorners;
            } else {
                corner = false;
            }
            dx1 = dx2;
            dy1 = dy2;
            side1 = side2;
        }
        double w = 1.0;
        double h = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            w = cal.pixelWidth;
            h = cal.pixelHeight;
        }
        return (double)sumdx * w + (double)sumdy * h - (double)nCorners * (w + h - Math.sqrt(w * w + h * h));
    }

    @Override
    public double getLength() {
        return this.getLength(this.imp);
    }

    public double getUncalibratedLength() {
        return this.getLength(null);
    }

    double getLength(ImagePlus imp) {
        if (this.isTraced()) {
            return this.getTracedPerimeter(imp);
        }
        if (this.nPoints > 2) {
            if (this.type == 3) {
                return this.getSmoothedPerimeter(imp);
            }
            if (this.type == 7 && this.width != 0 && this.height != 0) {
                return this.getSmoothedLineLength(imp);
            }
        }
        boolean closeShape = this.isArea();
        if (this.xSpline != null) {
            return PolygonRoi.getLength(this.xSpline, this.ySpline, this.splinePoints, closeShape, imp);
        }
        if (this.xpf != null) {
            return PolygonRoi.getLength(this.xpf, this.ypf, this.nPoints, closeShape, imp);
        }
        return PolygonRoi.getLength(this.xp, this.yp, this.nPoints, closeShape, imp);
    }

    private boolean isTraced() {
        int nexti;
        int i;
        if (this.type == 4) {
            return true;
        }
        if (this.type != 2) {
            return false;
        }
        if (this.xp == null) {
            if (this.xpf == null) {
                return false;
            }
            for (i = 0; i < this.nPoints; ++i) {
                nexti = i + 1;
                if (nexti == this.nPoints) {
                    nexti = 0;
                }
                if (this.xpf[nexti] - this.xpf[i] != 0.0f && this.ypf[nexti] - this.ypf[i] != 0.0f) {
                    return false;
                }
                if (this.xpf[i] == (float)((int)this.xpf[i]) && this.ypf[i] == (float)((int)this.ypf[i])) continue;
                return false;
            }
            this.xp = PolygonRoi.toInt(this.xpf, this.xp, this.nPoints);
            this.yp = PolygonRoi.toInt(this.ypf, this.yp, this.nPoints);
        }
        for (i = 0; i < this.nPoints; ++i) {
            nexti = i + 1;
            if (nexti == this.nPoints) {
                nexti = 0;
            }
            if (this.xp[nexti] - this.xp[i] == 0 || this.yp[nexti] - this.yp[i] == 0) continue;
            return false;
        }
        return true;
    }

    static double getLength(int[] xpoints, int[] ypoints, int npoints, boolean closeShape, ImagePlus imp) {
        if (npoints < 2) {
            return 0.0;
        }
        double pixelWidth = 1.0;
        double pixelHeight = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            pixelWidth = cal.pixelWidth;
            pixelHeight = cal.pixelHeight;
        }
        double length = 0.0;
        for (int i = 0; i < npoints - 1; ++i) {
            length += Math.sqrt(PolygonRoi.sqr((double)(xpoints[i + 1] - xpoints[i]) * pixelWidth) + PolygonRoi.sqr((double)(ypoints[i + 1] - ypoints[i]) * pixelHeight));
        }
        if (closeShape) {
            length += Math.sqrt(PolygonRoi.sqr((double)(xpoints[0] - xpoints[npoints - 1]) * pixelWidth) + PolygonRoi.sqr((double)(ypoints[0] - ypoints[npoints - 1]) * pixelHeight));
        }
        return length;
    }

    static double getLength(float[] xpoints, float[] ypoints, int npoints, boolean closeShape, ImagePlus imp) {
        if (npoints < 2) {
            return 0.0;
        }
        double pixelWidth = 1.0;
        double pixelHeight = 1.0;
        if (imp != null) {
            Calibration cal = imp.getCalibration();
            pixelWidth = cal.pixelWidth;
            pixelHeight = cal.pixelHeight;
        }
        double length = 0.0;
        for (int i = 0; i < npoints - 1; ++i) {
            length += Math.sqrt(PolygonRoi.sqr((double)(xpoints[i + 1] - xpoints[i]) * pixelWidth) + PolygonRoi.sqr((double)(ypoints[i + 1] - ypoints[i]) * pixelHeight));
        }
        if (closeShape) {
            length += Math.sqrt(PolygonRoi.sqr((double)(xpoints[0] - xpoints[npoints - 1]) * pixelWidth) + PolygonRoi.sqr((double)(ypoints[0] - ypoints[npoints - 1]) * pixelHeight));
        }
        return length;
    }

    @Override
    public double getAngle() {
        return this.degrees;
    }

    public int getNCoordinates() {
        if (this.xSpline != null) {
            return this.splinePoints;
        }
        return this.nPoints;
    }

    public int[] getXCoordinates() {
        if (this.xSpline != null) {
            return PolygonRoi.toIntR(this.xSpline);
        }
        if (this.xpf != null) {
            return PolygonRoi.toIntR(this.xpf);
        }
        return this.xp;
    }

    public int[] getYCoordinates() {
        if (this.xSpline != null) {
            return PolygonRoi.toIntR(this.ySpline);
        }
        if (this.ypf != null) {
            return PolygonRoi.toIntR(this.ypf);
        }
        return this.yp;
    }

    public Polygon getNonSplineCoordinates() {
        if (this.xpf != null) {
            return new Polygon(PolygonRoi.toIntR(this.xpf), PolygonRoi.toIntR(this.ypf), this.nPoints);
        }
        return new Polygon(this.xp, this.yp, this.nPoints);
    }

    public FloatPolygon getNonSplineFloatPolygon() {
        if (this.xpf != null) {
            FloatPolygon p = new FloatPolygon(this.xpf, this.ypf, this.nPoints).duplicate();
            float xbase = (float)this.getXBase();
            float ybase = (float)this.getYBase();
            int i = 0;
            while (i < p.npoints) {
                int n = i;
                p.xpoints[n] = p.xpoints[n] + xbase;
                int n2 = i++;
                p.ypoints[n2] = p.ypoints[n2] + ybase;
            }
            return p;
        }
        return this.getFloatPolygon();
    }

    @Override
    public Polygon getPolygon() {
        int[] ypoints1;
        int[] xpoints1;
        int n;
        if (this.xSpline != null) {
            n = this.splinePoints;
            xpoints1 = PolygonRoi.toInt(this.xSpline);
            ypoints1 = PolygonRoi.toInt(this.ySpline);
        } else if (this.xpf != null) {
            n = this.nPoints;
            xpoints1 = PolygonRoi.toIntR(this.xpf);
            ypoints1 = PolygonRoi.toIntR(this.ypf);
        } else {
            n = this.nPoints;
            xpoints1 = this.xp;
            ypoints1 = this.yp;
        }
        int[] xpoints2 = new int[n];
        int[] ypoints2 = new int[n];
        for (int i = 0; i < n; ++i) {
            xpoints2[i] = xpoints1[i] + this.x;
            ypoints2[i] = ypoints1[i] + this.y;
        }
        return new Polygon(xpoints2, ypoints2, n);
    }

    @Override
    public FloatPolygon getFloatPolygon() {
        int n = this.xSpline != null ? this.splinePoints : this.nPoints;
        float[] xpoints2 = new float[n];
        float[] ypoints2 = new float[n];
        float xbase = (float)this.getXBase();
        float ybase = (float)this.getYBase();
        if (this.xSpline != null) {
            for (int i = 0; i < n; ++i) {
                xpoints2[i] = this.xSpline[i] + xbase;
                ypoints2[i] = this.ySpline[i] + ybase;
            }
        } else if (this.xpf != null) {
            for (int i = 0; i < n; ++i) {
                xpoints2[i] = this.xpf[i] + xbase;
                ypoints2[i] = this.ypf[i] + ybase;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                xpoints2[i] = this.xp[i] + this.x;
                ypoints2[i] = this.yp[i] + this.y;
            }
        }
        return new FloatPolygon(xpoints2, ypoints2, n);
    }

    @Override
    public int size() {
        return this.xSpline != null ? this.splinePoints : this.nPoints;
    }

    @Override
    public FloatPolygon getInterpolatedPolygon(double interval, boolean smooth) {
        FloatPolygon p = this.getFloatPolygon();
        if (smooth && (this.type == 4 || this.type == 3 || this.type == 7)) {
            for (int i = 1; i < p.npoints - 2; ++i) {
                p.xpoints[i] = (p.xpoints[i - 1] + p.xpoints[i] + p.xpoints[i + 1]) / 3.0f;
                p.ypoints[i] = (p.ypoints[i - 1] + p.ypoints[i] + p.ypoints[i + 1]) / 3.0f;
            }
            if (this.type != 7) {
                p.xpoints[0] = (p.xpoints[p.npoints - 1] + p.xpoints[0] + p.xpoints[1]) / 3.0f;
                p.ypoints[0] = (p.ypoints[p.npoints - 1] + p.ypoints[0] + p.ypoints[1]) / 3.0f;
                p.xpoints[p.npoints - 1] = (p.xpoints[p.npoints - 2] + p.xpoints[p.npoints - 1] + p.xpoints[0]) / 3.0f;
                p.ypoints[p.npoints - 1] = (p.ypoints[p.npoints - 2] + p.ypoints[p.npoints - 1] + p.ypoints[0]) / 3.0f;
            }
        }
        return super.getInterpolatedPolygon(p, interval, smooth);
    }

    @Override
    protected int clipRectMargin() {
        return this.type == 10 ? 4 : 0;
    }

    @Override
    public synchronized Object clone() {
        int i;
        PolygonRoi r = (PolygonRoi)super.clone();
        if (this.xpf != null) {
            r.xpf = new float[this.maxPoints];
            r.ypf = new float[this.maxPoints];
        } else {
            r.xp = new int[this.maxPoints];
            r.yp = new int[this.maxPoints];
        }
        r.xp2 = new int[this.maxPoints];
        r.yp2 = new int[this.maxPoints];
        for (i = 0; i < this.nPoints; ++i) {
            if (this.xpf != null) {
                r.xpf[i] = this.xpf[i];
                r.ypf[i] = this.ypf[i];
            } else {
                r.xp[i] = this.xp[i];
                r.yp[i] = this.yp[i];
            }
            r.xp2[i] = this.xp2[i];
            r.yp2[i] = this.yp2[i];
        }
        if (this.xSpline != null) {
            r.xSpline = new float[this.splinePoints];
            r.ySpline = new float[this.splinePoints];
            r.splinePoints = this.splinePoints;
            for (i = 0; i < this.splinePoints; ++i) {
                r.xSpline[i] = this.xSpline[i];
                r.ySpline[i] = this.ySpline[i];
            }
        }
        return r;
    }

    void enlargeArrays() {
        this.enlargeArrays(this.maxPoints * 2);
    }

    void enlargeArrays(int newSize) {
        if (this.xp != null) {
            int[] xptemp = new int[newSize];
            int[] yptemp = new int[newSize];
            System.arraycopy(this.xp, 0, xptemp, 0, this.maxPoints);
            System.arraycopy(this.yp, 0, yptemp, 0, this.maxPoints);
            this.xp = xptemp;
            this.yp = yptemp;
        }
        if (this.xpf != null) {
            float[] xpftemp = new float[newSize];
            float[] ypftemp = new float[newSize];
            System.arraycopy(this.xpf, 0, xpftemp, 0, this.maxPoints);
            System.arraycopy(this.ypf, 0, ypftemp, 0, this.maxPoints);
            this.xpf = xpftemp;
            this.ypf = ypftemp;
        }
        int[] xp2temp = new int[newSize];
        int[] yp2temp = new int[newSize];
        System.arraycopy(this.xp2, 0, xp2temp, 0, this.maxPoints);
        System.arraycopy(this.yp2, 0, yp2temp, 0, this.maxPoints);
        this.xp2 = xp2temp;
        this.yp2 = yp2temp;
        if (IJ.debugMode) {
            IJ.log("PolygonRoi: " + this.maxPoints + " points -> " + newSize);
        }
        this.maxPoints = newSize;
    }

    @Override
    public void setLocation(double x, double y) {
        super.setLocation(x, y);
        if ((double)((int)x) != x || (double)((int)y) != y) {
            this.enableSubPixelResolution();
        }
    }

    @Override
    public void enableSubPixelResolution() {
        super.enableSubPixelResolution();
        if (this.xpf == null && this.xp != null) {
            this.xpf = PolygonRoi.toFloat(this.xp);
            this.ypf = PolygonRoi.toFloat(this.yp);
        }
    }

    @Override
    public String getDebugInfo() {
        String s = "ROI Debug Properties\n";
        s = s + "\tbounds: " + this.bounds + "\n";
        s = s + "\tx,y,w,h: " + this.x + "," + this.y + "," + this.width + "," + this.height + "\n";
        if (this.xpf != null && this.xpf.length > 0) {
            s = s + "\txpf[0],ypf[0]: " + this.xpf[0] + "," + this.ypf[0] + "\n";
        }
        return s;
    }
}

