/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.config.template;

import cn.hutool.core.util.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.common.utils.JsonUtils;
import net.maku.generator.config.template.GeneratorInfo;
import net.maku.generator.config.template.TemplateInfo;
import org.springframework.util.StreamUtils;

public class GeneratorConfig {
    private String template;

    public GeneratorConfig(String template) {
        this.template = template;
    }

    public GeneratorInfo getGeneratorConfig() {
        InputStream isConfig;
        if (!StrUtil.endWith((CharSequence)this.template, (char)'/')) {
            this.template = this.template + "/";
        }
        if ((isConfig = this.getClass().getResourceAsStream(this.template + "config.json")) == null) {
            throw new ServerException("\u6a21\u677f\u914d\u7f6e\u6587\u4ef6\uff0cconfig.json\u4e0d\u5b58\u5728");
        }
        try {
            String configContent = StreamUtils.copyToString((InputStream)isConfig, (Charset)StandardCharsets.UTF_8);
            GeneratorInfo generator = JsonUtils.parseObject(configContent, GeneratorInfo.class);
            for (TemplateInfo templateInfo : generator.getTemplates()) {
                InputStream isTemplate = this.getClass().getResourceAsStream(this.template + templateInfo.getTemplateName());
                if (isTemplate == null) {
                    throw new ServerException("\u6a21\u677f\u6587\u4ef6 " + templateInfo.getTemplateName() + " \u4e0d\u5b58\u5728");
                }
                String templateContent = StreamUtils.copyToString((InputStream)isTemplate, (Charset)StandardCharsets.UTF_8);
                templateInfo.setTemplateContent(templateContent);
            }
            return generator;
        }
        catch (IOException e) {
            throw new ServerException("\u8bfb\u53d6config.json\u914d\u7f6e\u6587\u4ef6\u5931\u8d25");
        }
    }
}

