/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.controller;

import java.util.List;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.utils.Result;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.service.TableFieldService;
import net.maku.generator.service.TableService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"maku-generator/gen/table"})
public class TableController {
    private final TableService tableService;
    private final TableFieldService tableFieldService;

    @GetMapping(value={"page"})
    public Result<PageResult<TableEntity>> page(Query query) {
        PageResult<TableEntity> page = this.tableService.page(query);
        return Result.ok(page);
    }

    @GetMapping(value={"{id}"})
    public Result<TableEntity> get(@PathVariable(value="id") Long id) {
        TableEntity table = (TableEntity)this.tableService.getById(id);
        List<TableFieldEntity> fieldList = this.tableFieldService.getByTableId(table.getId());
        table.setFieldList(fieldList);
        return Result.ok(table);
    }

    @PutMapping
    public Result<String> update(@RequestBody TableEntity table) {
        this.tableService.updateById(table);
        return Result.ok();
    }

    @DeleteMapping
    public Result<String> delete(@RequestBody Long[] ids) {
        this.tableService.deleteBatchIds(ids);
        return Result.ok();
    }

    @PostMapping(value={"sync/{id}"})
    public Result<String> sync(@PathVariable(value="id") Long id) {
        this.tableService.sync(id);
        return Result.ok();
    }

    @PostMapping(value={"import/{datasourceId}"})
    public Result<String> tableImport(@PathVariable(value="datasourceId") Long datasourceId, @RequestBody List<String> tableNameList) {
        for (String tableName : tableNameList) {
            this.tableService.tableImport(datasourceId, tableName);
        }
        return Result.ok();
    }

    @PutMapping(value={"field/{tableId}"})
    public Result<String> updateTableField(@PathVariable(value="tableId") Long tableId, @RequestBody List<TableFieldEntity> tableFieldList) {
        this.tableFieldService.updateTableField(tableId, tableFieldList);
        return Result.ok();
    }

    @Generated
    public TableController(TableService tableService, TableFieldService tableFieldService) {
        this.tableService = tableService;
        this.tableFieldService = tableFieldService;
    }
}

