/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import lombok.Generated;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.common.utils.DateUtils;
import net.maku.generator.config.template.GeneratorConfig;
import net.maku.generator.config.template.GeneratorInfo;
import net.maku.generator.config.template.TemplateInfo;
import net.maku.generator.entity.BaseClassEntity;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.service.BaseClassService;
import net.maku.generator.service.DataSourceService;
import net.maku.generator.service.FieldTypeService;
import net.maku.generator.service.GeneratorService;
import net.maku.generator.service.TableFieldService;
import net.maku.generator.service.TableService;
import net.maku.generator.utils.TemplateUtils;
import net.maku.generator.vo.PreviewVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GeneratorServiceImpl
implements GeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GeneratorServiceImpl.class);
    private final DataSourceService datasourceService;
    private final FieldTypeService fieldTypeService;
    private final BaseClassService baseClassService;
    private final GeneratorConfig generatorConfig;
    private final TableService tableService;
    private final TableFieldService tableFieldService;

    @Override
    public void downloadCode(Long tableId, ZipOutputStream zip) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        GeneratorInfo generator = this.generatorConfig.getGeneratorConfig();
        for (TemplateInfo template : generator.getTemplates()) {
            dataModel.put("templateName", template.getTemplateName());
            String content = TemplateUtils.getContent(template.getTemplateContent(), dataModel);
            String path = TemplateUtils.getContent(template.getGeneratorPath(), dataModel);
            try {
                zip.putNextEntry(new ZipEntry(path));
                IoUtil.writeUtf8((OutputStream)zip, (boolean)false, (Object[])new Object[]{content});
                zip.flush();
                zip.closeEntry();
            }
            catch (IOException e) {
                throw new ServerException("\u6a21\u677f\u5199\u5165\u5931\u8d25\uff1a" + path, e);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void generatorCode(Long tableId) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        GeneratorInfo generator = this.generatorConfig.getGeneratorConfig();
        for (TemplateInfo template : generator.getTemplates()) {
            dataModel.put("templateName", template.getTemplateName());
            String content = TemplateUtils.getContent(template.getTemplateContent(), dataModel);
            String path = TemplateUtils.getContent(template.getGeneratorPath(), dataModel);
            FileUtil.writeUtf8String((String)content, (String)path);
        }
    }

    private Map<String, Object> getDataModel(Long tableId) {
        TableEntity table = (TableEntity)this.tableService.getById(tableId);
        List<TableFieldEntity> fieldList = this.tableFieldService.getByTableId(tableId);
        table.setFieldList(fieldList);
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        String dbType = this.datasourceService.getDatabaseProductName(table.getDatasourceId());
        dataModel.put("dbType", dbType);
        dataModel.put("package", table.getPackageName());
        dataModel.put("packagePath", table.getPackageName().replace(".", File.separator));
        dataModel.put("version", table.getVersion());
        dataModel.put("moduleName", table.getModuleName());
        dataModel.put("ModuleName", StrUtil.upperFirst((CharSequence)table.getModuleName()));
        dataModel.put("functionName", table.getFunctionName());
        dataModel.put("FunctionName", StrUtil.upperFirst((CharSequence)table.getFunctionName()));
        dataModel.put("formLayout", table.getFormLayout());
        dataModel.put("author", table.getAuthor());
        dataModel.put("email", table.getEmail());
        dataModel.put("datetime", DateUtils.format(new Date(), "yyyy-MM-dd HH:mm:ss"));
        dataModel.put("date", DateUtils.format(new Date(), "yyyy-MM-dd"));
        this.setFieldTypeList(dataModel, table);
        this.setBaseClass(dataModel, table);
        Set<String> importList = this.fieldTypeService.getPackageByTableId(table.getId());
        dataModel.put("importList", importList);
        dataModel.put("tableName", table.getTableName());
        dataModel.put("tableComment", table.getTableComment());
        dataModel.put("className", StrUtil.lowerFirst((CharSequence)table.getClassName()));
        dataModel.put("ClassName", table.getClassName());
        dataModel.put("fieldList", table.getFieldList());
        dataModel.put("backendPath", table.getBackendPath());
        dataModel.put("frontendPath", table.getFrontendPath());
        return dataModel;
    }

    private void setBaseClass(Map<String, Object> dataModel, TableEntity table) {
        if (table.getBaseclassId() == null) {
            return;
        }
        BaseClassEntity baseClass = (BaseClassEntity)this.baseClassService.getById(table.getBaseclassId());
        baseClass.setPackageName(baseClass.getPackageName());
        dataModel.put("baseClass", baseClass);
        Object[] fields = baseClass.getFields().split(",");
        for (TableFieldEntity field : table.getFieldList()) {
            if (!ArrayUtil.contains((Object[])fields, (Object)field.getFieldName())) continue;
            field.setBaseField(true);
        }
    }

    private void setFieldTypeList(Map<String, Object> dataModel, TableEntity table) {
        ArrayList<TableFieldEntity> primaryList = new ArrayList<TableFieldEntity>();
        ArrayList<TableFieldEntity> formList = new ArrayList<TableFieldEntity>();
        ArrayList<TableFieldEntity> gridList = new ArrayList<TableFieldEntity>();
        ArrayList<TableFieldEntity> queryList = new ArrayList<TableFieldEntity>();
        for (TableFieldEntity field : table.getFieldList()) {
            if (field.isPrimaryPk()) {
                primaryList.add(field);
            }
            if (field.isFormItem()) {
                formList.add(field);
            }
            if (field.isGridItem()) {
                gridList.add(field);
            }
            if (!field.isQueryItem()) continue;
            queryList.add(field);
        }
        dataModel.put("primaryList", primaryList);
        dataModel.put("formList", formList);
        dataModel.put("gridList", gridList);
        dataModel.put("queryList", queryList);
    }

    @Override
    public List<PreviewVO> preview(Long tableId) {
        Map<String, Object> dataModel = this.getDataModel(tableId);
        GeneratorInfo generator = this.generatorConfig.getGeneratorConfig();
        return generator.getTemplates().stream().map(t -> {
            dataModel.put("templateName", t.getTemplateName());
            String content = TemplateUtils.getContent(t.getTemplateContent(), dataModel);
            String fileName = t.getGeneratorPath().substring(t.getGeneratorPath().lastIndexOf("/") + 1);
            fileName = TemplateUtils.getContent(fileName, dataModel);
            return new PreviewVO(fileName, content);
        }).collect(Collectors.toList());
    }

    @Generated
    public GeneratorServiceImpl(DataSourceService datasourceService, FieldTypeService fieldTypeService, BaseClassService baseClassService, GeneratorConfig generatorConfig, TableService tableService, TableFieldService tableFieldService) {
        this.datasourceService = datasourceService;
        this.fieldTypeService = fieldTypeService;
        this.baseClassService = baseClassService;
        this.generatorConfig = generatorConfig;
        this.tableService = tableService;
        this.tableFieldService = tableFieldService;
    }
}

