/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.dao.TableFieldDao;
import net.maku.generator.entity.FieldTypeEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.enums.AutoFillEnum;
import net.maku.generator.service.FieldTypeService;
import net.maku.generator.service.TableFieldService;
import org.springframework.stereotype.Service;

@Service
public class TableFieldServiceImpl
extends BaseServiceImpl<TableFieldDao, TableFieldEntity>
implements TableFieldService {
    private final FieldTypeService fieldTypeService;

    @Override
    public List<TableFieldEntity> getByTableId(Long tableId) {
        return ((TableFieldDao)this.baseMapper).getByTableId(tableId);
    }

    @Override
    public void deleteBatchTableIds(Long[] tableIds) {
        ((TableFieldDao)this.baseMapper).deleteBatchTableIds(tableIds);
    }

    @Override
    public void updateTableField(Long tableId, List<TableFieldEntity> tableFieldList) {
        int sort = 0;
        for (TableFieldEntity tableField : tableFieldList) {
            tableField.setSort(sort++);
            this.updateById(tableField);
        }
    }

    @Override
    public void initFieldList(List<TableFieldEntity> tableFieldList) {
        Map<String, FieldTypeEntity> fieldTypeMap = this.fieldTypeService.getMap();
        int index = 0;
        for (TableFieldEntity field : tableFieldList) {
            field.setAttrName(StringUtils.underlineToCamel((String)field.getFieldName()));
            FieldTypeEntity fieldTypeMapping = fieldTypeMap.get(field.getFieldType().toLowerCase());
            if (fieldTypeMapping == null) {
                field.setAttrType("Object");
            } else {
                field.setAttrType(fieldTypeMapping.getAttrType());
                field.setPackageName(fieldTypeMapping.getPackageName());
            }
            field.setAutoFill(AutoFillEnum.DEFAULT.name());
            field.setFormItem(true);
            field.setGridItem(true);
            field.setQueryType("=");
            field.setQueryFormType("text");
            field.setFormType("text");
            field.setSort(index++);
        }
    }

    @Generated
    public TableFieldServiceImpl(FieldTypeService fieldTypeService) {
        this.fieldTypeService = fieldTypeService;
    }
}

