/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.service.impl;

import cn.hutool.core.text.NamingCase;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import net.maku.generator.common.exception.ServerException;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.service.impl.BaseServiceImpl;
import net.maku.generator.config.GenDataSource;
import net.maku.generator.config.template.GeneratorConfig;
import net.maku.generator.config.template.GeneratorInfo;
import net.maku.generator.dao.TableDao;
import net.maku.generator.entity.TableEntity;
import net.maku.generator.entity.TableFieldEntity;
import net.maku.generator.enums.FormLayoutEnum;
import net.maku.generator.enums.GeneratorTypeEnum;
import net.maku.generator.service.DataSourceService;
import net.maku.generator.service.TableFieldService;
import net.maku.generator.service.TableService;
import net.maku.generator.utils.GenUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TableServiceImpl
extends BaseServiceImpl<TableDao, TableEntity>
implements TableService {
    private final TableFieldService tableFieldService;
    private final DataSourceService dataSourceService;
    private final GeneratorConfig generatorConfig;

    @Override
    public PageResult<TableEntity> page(Query query) {
        IPage page = ((TableDao)this.baseMapper).selectPage(this.getPage(query), (Wrapper)this.getWrapper(query));
        return new PageResult<TableEntity>(page.getRecords(), page.getTotal());
    }

    @Override
    public TableEntity getByTableName(String tableName) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        return (TableEntity)((TableDao)this.baseMapper).selectOne((Wrapper)queryWrapper.eq(TableEntity::getTableName, (Object)tableName));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatchIds(Long[] ids) {
        ((TableDao)this.baseMapper).deleteBatchIds(Arrays.asList(ids));
        this.tableFieldService.deleteBatchTableIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void tableImport(Long datasourceId, String tableName) {
        GenDataSource dataSource = this.dataSourceService.get(datasourceId);
        TableEntity table = this.getByTableName(tableName);
        if (table != null) {
            throw new ServerException(tableName + "\u5df2\u5b58\u5728");
        }
        table = GenUtils.getTable(dataSource, tableName);
        GeneratorInfo generator = this.generatorConfig.getGeneratorConfig();
        table.setPackageName(generator.getProject().getPackageName());
        table.setVersion(generator.getProject().getVersion());
        table.setBackendPath(generator.getProject().getBackendPath());
        table.setFrontendPath(generator.getProject().getFrontendPath());
        table.setAuthor(generator.getDeveloper().getAuthor());
        table.setEmail(generator.getDeveloper().getEmail());
        table.setFormLayout(FormLayoutEnum.ONE.getValue());
        table.setGeneratorType(GeneratorTypeEnum.ZIP_DOWNLOAD.ordinal());
        table.setClassName(NamingCase.toPascalCase((CharSequence)tableName));
        table.setModuleName(GenUtils.getModuleName(table.getPackageName()));
        table.setFunctionName(GenUtils.getFunctionName(tableName));
        table.setCreateTime(new Date());
        this.save(table);
        List<TableFieldEntity> tableFieldList = GenUtils.getTableFieldList(dataSource, table.getId(), table.getTableName());
        this.tableFieldService.initFieldList(tableFieldList);
        tableFieldList.forEach(arg_0 -> ((TableFieldService)this.tableFieldService).save(arg_0));
        try {
            dataSource.getConnection().close();
        }
        catch (SQLException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sync(Long id) {
        TableEntity table = (TableEntity)this.getById(id);
        GenDataSource datasource = this.dataSourceService.get(table.getDatasourceId());
        List<TableFieldEntity> dbTableFieldList = GenUtils.getTableFieldList(datasource, table.getId(), table.getTableName());
        if (dbTableFieldList.size() == 0) {
            throw new ServerException("\u540c\u6b65\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u8868\uff1a" + table.getTableName());
        }
        List dbTableFieldNameList = dbTableFieldList.stream().map(TableFieldEntity::getFieldName).collect(Collectors.toList());
        List<TableFieldEntity> tableFieldList = this.tableFieldService.getByTableId(id);
        Map tableFieldMap = tableFieldList.stream().collect(Collectors.toMap(TableFieldEntity::getFieldName, Function.identity()));
        this.tableFieldService.initFieldList(dbTableFieldList);
        dbTableFieldList.forEach(field -> {
            if (!tableFieldMap.containsKey(field.getFieldName())) {
                this.tableFieldService.save(field);
                return;
            }
            TableFieldEntity updateField = (TableFieldEntity)tableFieldMap.get(field.getFieldName());
            updateField.setPrimaryPk(field.isPrimaryPk());
            updateField.setFieldComment(field.getFieldComment());
            updateField.setFieldType(field.getFieldType());
            updateField.setAttrType(field.getAttrType());
            this.tableFieldService.updateById(updateField);
        });
        List delFieldList = tableFieldList.stream().filter(field -> !dbTableFieldNameList.contains(field.getFieldName())).collect(Collectors.toList());
        if (delFieldList.size() > 0) {
            List fieldIds = delFieldList.stream().map(TableFieldEntity::getId).collect(Collectors.toList());
            this.tableFieldService.removeBatchByIds(fieldIds);
        }
    }

    @Generated
    public TableServiceImpl(TableFieldService tableFieldService, DataSourceService dataSourceService, GeneratorConfig generatorConfig) {
        this.tableFieldService = tableFieldService;
        this.dataSourceService = dataSourceService;
        this.generatorConfig = generatorConfig;
    }
}

