/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.controller;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import net.maku.generator.common.page.PageResult;
import net.maku.generator.common.query.Query;
import net.maku.generator.common.utils.Result;
import net.maku.generator.entity.BaseClassEntity;
import net.maku.generator.service.BaseClassService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"maku-generator/gen/baseclass"})
public class BaseClassController {
    private final BaseClassService baseClassService;

    @GetMapping(value={"page"})
    public Result<PageResult<BaseClassEntity>> page(Query query) {
        PageResult<BaseClassEntity> page = this.baseClassService.page(query);
        return Result.ok(page);
    }

    @GetMapping(value={"list"})
    public Result<List<BaseClassEntity>> list() {
        List<BaseClassEntity> list = this.baseClassService.getList();
        return Result.ok(list);
    }

    @GetMapping(value={"{id}"})
    public Result<BaseClassEntity> get(@PathVariable(value="id") Long id) {
        BaseClassEntity data = (BaseClassEntity)this.baseClassService.getById(id);
        return Result.ok(data);
    }

    @PostMapping
    public Result<String> save(@RequestBody BaseClassEntity entity) {
        this.baseClassService.save(entity);
        return Result.ok();
    }

    @PutMapping
    public Result<String> update(@RequestBody BaseClassEntity entity) {
        this.baseClassService.updateById(entity);
        return Result.ok();
    }

    @DeleteMapping
    public Result<String> delete(@RequestBody Long[] ids) {
        this.baseClassService.removeBatchByIds(Arrays.asList(ids));
        return Result.ok();
    }

    @Generated
    public BaseClassController(BaseClassService baseClassService) {
        this.baseClassService = baseClassService;
    }
}

