/*
 * Decompiled with CFR 0.152.
 */
package net.maku.generator.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectUtils {
    public static final String MODIFY_SUFFIX = "java,xml,yml,factories,md,txt";
    public static final String EXCLUSIONS = ".git,.idea,target,logs";
    public static final String SPLIT = ",";

    public static void copyDirectory(File srcRoot, File destRoot, List<String> exclusions, Map<String, String> replaceMap) throws IOException {
        File[] srcFiles;
        String destPath = destRoot.getPath().replaceAll("\\\\", "/");
        destRoot = new File(ProjectUtils.replaceData(destPath, replaceMap));
        File[] fileArray = srcFiles = CollectionUtil.isEmpty(exclusions) ? srcRoot.listFiles() : srcRoot.listFiles(file -> !exclusions.contains(file.getName()));
        if (srcFiles == null) {
            throw new IOException("\u6ca1\u6709\u9700\u8981\u62f7\u8d1d\u7684\u6587\u4ef6 " + srcRoot);
        }
        for (File srcFile : srcFiles) {
            String fileName = srcFile.getName();
            if (srcFile.isFile()) {
                fileName = ProjectUtils.replaceData(fileName, replaceMap);
            }
            File destFile = new File(destRoot, fileName);
            if (srcFile.isDirectory()) {
                ProjectUtils.copyDirectory(srcFile, destFile, exclusions, replaceMap);
                continue;
            }
            FileUtil.copyFile((File)srcFile, (File)destFile, (StandardCopyOption[])new StandardCopyOption[0]);
        }
    }

    public static void contentFormat(File rootFile, List<String> suffixList, Map<String, String> replaceMap) {
        List destList = FileUtil.loopFiles((File)rootFile, file -> suffixList.contains(FileNameUtil.getSuffix((File)file)));
        for (File dest : destList) {
            List lines = FileUtil.readUtf8Lines((File)dest);
            ArrayList<String> newList = new ArrayList<String>();
            for (String line : lines) {
                newList.add(ProjectUtils.replaceData(line, replaceMap));
            }
            FileUtil.writeUtf8Lines(newList, (File)dest);
        }
    }

    public static String getTmpDirPath(String ... names) {
        StringBuilder tmpPath = new StringBuilder(FileUtil.getTmpDirPath());
        tmpPath.append("generator");
        tmpPath.append(File.separator);
        tmpPath.append(System.currentTimeMillis());
        for (String name : names) {
            tmpPath.append(File.separator).append(name);
        }
        return tmpPath.toString();
    }

    private static String replaceData(String str, Map<String, String> map) {
        for (String key : map.keySet()) {
            str = str.replaceAll(key, map.get(key));
        }
        return str;
    }
}

