/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatcher;
import net.sf.jmimemagic.MagicParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class MagicParser
extends DefaultHandler
implements ContentHandler,
ErrorHandler {
    private static String magicFile = "/magic.xml";
    private static Log log = LogFactory.getLog(MagicParser.class);
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    private boolean initialized = false;
    private XMLReader parser = null;
    private List<MagicMatcher> stack = new ArrayList<MagicMatcher>();
    private Collection<MagicMatcher> matchers = new ArrayList<MagicMatcher>();
    private MagicMatcher matcher = null;
    private MagicMatch match = null;
    private Map<String, String> properties = null;
    private String finalValue = "";
    private boolean isMimeType = false;
    private boolean isExtension = false;
    private boolean isDescription = false;
    private boolean isTest = false;

    public MagicParser() {
        log.debug((Object)"instantiated");
    }

    public synchronized void initialize() throws MagicParseException {
        boolean namespaces = true;
        boolean validation = false;
        boolean schemaValidation = false;
        boolean schemaFullChecking = false;
        if (!this.initialized) {
            try {
                this.parser = XMLReaderFactory.createXMLReader();
            }
            catch (Exception e) {
                try {
                    log.debug((Object)"falling back to default parser: org.apache.xerces.parsers.SAXParser");
                    this.parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
                }
                catch (Exception ee) {
                    throw new MagicParseException("unable to instantiate parser");
                }
            }
            try {
                this.parser.setFeature(NAMESPACES_FEATURE_ID, namespaces);
            }
            catch (SAXException e) {
                log.debug((Object)"initialize(): warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
            }
            try {
                this.parser.setFeature(VALIDATION_FEATURE_ID, validation);
            }
            catch (SAXException e) {
                log.debug((Object)"initialize(): warning: Parser does not support feature (http://xml.org/sax/features/validation)");
            }
            try {
                this.parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, schemaValidation);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                log.debug((Object)"initialize(): warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
            }
            try {
                this.parser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                log.debug((Object)"initialize(): warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
            }
            this.parser.setErrorHandler(this);
            this.parser.setContentHandler(this);
            try {
                URL resource = MagicParser.class.getResource(magicFile);
                String magicURL = resource.toString();
                if (magicURL == null) {
                    log.error((Object)("initialize(): couldn't load '" + magicURL + "'"));
                    throw new MagicParseException("couldn't load '" + magicURL + "'");
                }
                this.parser.parse(magicURL);
            }
            catch (SAXParseException resource) {
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MagicParseException("parse error occurred - " + e.getMessage());
            }
            this.initialized = true;
        }
    }

    public Collection<MagicMatcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public void startDocument() throws SAXException {
        log.debug((Object)"startDocument()");
    }

    @Override
    public void endDocument() throws SAXException {
        log.debug((Object)"endDocument()");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void characters(char[] ch, int offset, int length) throws SAXException {
        String value = new String(ch, offset, length);
        log.debug((Object)("characters(): value is '" + value + "'"));
        this.finalValue = this.finalValue + value;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int offset, int length) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        log.debug((Object)"startElement()");
        log.debug((Object)("startElement(): localName is '" + localName + "'"));
        if (localName.equals("match")) {
            log.debug((Object)"startElement(): creating new matcher");
            this.match = new MagicMatch();
            this.matcher = new MagicMatcher();
            this.matcher.setMatch(this.match);
        }
        if (this.matcher != null) {
            if (localName.equals("mimetype")) {
                this.isMimeType = true;
            } else if (localName.equals("extension")) {
                this.isExtension = true;
            } else if (localName.equals("description")) {
                this.isDescription = true;
            } else if (localName.equals("test")) {
                this.isTest = true;
                int length = attributes.getLength();
                for (int i = 0; i < length; ++i) {
                    String attrLocalName = attributes.getLocalName(i);
                    String attrValue = attributes.getValue(i);
                    if (attrLocalName.equals("offset")) {
                        if (attrValue.equals("")) continue;
                        this.match.setOffset(new Integer(attrValue));
                        log.debug((Object)("startElement():   setting offset to '" + attrValue + "'"));
                        continue;
                    }
                    if (attrLocalName.equals("length")) {
                        if (attrValue.equals("")) continue;
                        this.match.setLength(new Integer(attrValue));
                        log.debug((Object)("startElement():   setting length to '" + attrValue + "'"));
                        continue;
                    }
                    if (attrLocalName.equals("type")) {
                        this.match.setType(attrValue);
                        log.debug((Object)("startElement():   setting type to '" + attrValue + "'"));
                        continue;
                    }
                    if (attrLocalName.equals("bitmask")) {
                        if (attrValue.equals("")) continue;
                        this.match.setBitmask(attrValue);
                        log.debug((Object)("startElement():   setting bitmask to '" + attrValue + "'"));
                        continue;
                    }
                    if (!attrLocalName.equals("comparator")) continue;
                    this.match.setComparator(attrValue);
                    log.debug((Object)("startElement():   setting comparator to '" + attrValue + "'"));
                }
            } else if (localName.equals("property")) {
                int length = attributes.getLength();
                String name = null;
                String value = null;
                for (int i = 0; i < length; ++i) {
                    String attrLocalName = attributes.getLocalName(i);
                    String attrValue = attributes.getValue(i);
                    if (attrLocalName.equals("name")) {
                        if (attrValue.equals("")) continue;
                        name = attrValue;
                        continue;
                    }
                    if (!attrLocalName.equals("value") || attrValue.equals("")) continue;
                    value = attrValue;
                }
                if (name != null && value != null) {
                    if (this.properties == null) {
                        this.properties = new HashMap<String, String>();
                    }
                    if (!this.properties.containsKey(name)) {
                        this.properties.put(name, value);
                        log.debug((Object)("startElement():   setting property '" + name + "'='" + value + "'"));
                    } else {
                        log.debug((Object)("startElement():   not setting property '" + name + "', duplicate key"));
                    }
                }
            } else if (localName.equals("match-list")) {
                log.debug((Object)"startElement(): found submatcher list");
                log.debug((Object)"startElement(): pushing current matcher to stack");
                this.stack.add(this.matcher);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) throws SAXException {
        log.debug((Object)"endElement()");
        log.debug((Object)("endElement(): localName is '" + localName + "'"));
        if (this.isMimeType) {
            this.isMimeType = false;
            this.match.setMimeType(this.finalValue);
            log.debug((Object)("characters(): setting mimetype to '" + this.finalValue + "'"));
        } else if (this.isExtension) {
            this.isExtension = false;
            this.match.setExtension(this.finalValue);
            log.debug((Object)("characters(): setting extension to '" + this.finalValue + "'"));
        } else if (this.isDescription) {
            this.isDescription = false;
            this.match.setDescription(this.finalValue);
            log.debug((Object)("characters(): setting description to '" + this.finalValue + "'"));
        } else if (this.isTest) {
            this.isTest = false;
            this.match.setTest(this.convertOctals(this.finalValue));
            log.debug((Object)("characters(): setting test to '" + this.convertOctals(this.finalValue) + "'"));
        }
        this.finalValue = "";
        if (localName.equals("match")) {
            if (this.matcher.isValid()) {
                this.match.setProperties(this.properties);
                if (this.stack.size() == 0) {
                    log.debug((Object)"endElement(): adding root matcher");
                    this.matchers.add(this.matcher);
                } else {
                    log.debug((Object)"endElement(): adding sub matcher");
                    MagicMatcher m = this.stack.get(this.stack.size() - 1);
                    m.addSubMatcher(this.matcher);
                }
            } else {
                log.info((Object)("endElement(): not adding invalid matcher '" + this.match.getDescription() + "'"));
            }
            this.matcher = null;
            this.properties = null;
        } else if (localName.equals("match-list")) {
            if (this.stack.size() > 0) {
                log.debug((Object)"endElement(): popping from the stack");
                this.matcher = this.stack.get(this.stack.size() - 1);
                this.stack.remove(this.matcher);
            }
        } else if (localName.equals("mimetype")) {
            this.isMimeType = false;
        } else if (localName.equals("extension")) {
            this.isExtension = false;
        } else if (localName.equals("description")) {
            this.isDescription = false;
        } else if (localName.equals("test")) {
            this.isTest = false;
        }
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    private ByteBuffer convertOctals(String s) {
        int beg = 0;
        int end = 0;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        while ((end = s.indexOf(92, beg)) != -1) {
            if (s.charAt(end + 1) != '\\') {
                for (int z = beg; z < end; ++z) {
                    buf.write(s.charAt(z));
                }
                if (end + 4 <= s.length()) {
                    try {
                        int chr = Integer.parseInt(s.substring(end + 1, end + 4), 8);
                        buf.write(chr);
                        end = beg = end + 4;
                    }
                    catch (NumberFormatException nfe) {
                        buf.write(92);
                        end = beg = end + 1;
                    }
                    continue;
                }
                buf.write(92);
                end = beg = end + 1;
                continue;
            }
            buf.write(92);
            end = beg = end + 1;
        }
        if (end < s.length()) {
            for (int z = beg; z < s.length(); ++z) {
                buf.write(s.charAt(z));
            }
        }
        try {
            log.debug((Object)("convertOctals(): returning buffer size '" + buf.size() + "'"));
            ByteBuffer b = ByteBuffer.allocate(buf.size());
            return b.put(buf.toByteArray());
        }
        catch (Exception e) {
            log.error((Object)("convertOctals(): error parsing string: " + e));
            return ByteBuffer.allocate(0);
        }
    }
}

