/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.activiti.application.AppliationLoadException;
import org.activiti.application.ApplicationContent;
import org.activiti.application.ApplicationEntry;
import org.activiti.application.ApplicationEntryDiscovery;
import org.activiti.application.FileContent;
import org.apache.commons.io.IOUtils;

public class ApplicationReader {
    private List<ApplicationEntryDiscovery> applicationEntryDiscoveries;

    public ApplicationReader(List<ApplicationEntryDiscovery> applicationEntryDiscoveries) {
        this.applicationEntryDiscoveries = applicationEntryDiscoveries;
    }

    public ApplicationContent read(InputStream inputStream) {
        ApplicationContent application = new ApplicationContent();
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                ZipEntry currentEntry = zipEntry;
                this.applicationEntryDiscoveries.stream().filter(applicationEntryDiscovery -> applicationEntryDiscovery.filter(currentEntry).test(currentEntry)).findFirst().ifPresent(applicationEntryDiscovery -> application.add(new ApplicationEntry(applicationEntryDiscovery.getEntryType(), new FileContent(currentEntry.getName(), this.readBytes(zipInputStream)))));
            }
        }
        catch (IOException e) {
            throw new AppliationLoadException("Unable to read zip file", e);
        }
        return application;
    }

    private byte[] readBytes(ZipInputStream zipInputStream) {
        try {
            return IOUtils.toByteArray((InputStream)zipInputStream);
        }
        catch (IOException e) {
            throw new AppliationLoadException("Unable to read zip file", e);
        }
    }
}

