/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.activiti.application.AppliationLoadException;
import org.activiti.application.ApplicationContent;
import org.activiti.application.ApplicationDiscovery;
import org.activiti.application.ApplicationReader;
import org.springframework.core.io.Resource;

public class ApplicationService {
    private ApplicationDiscovery applicationDiscovery;
    private ApplicationReader applicationReader;

    public ApplicationService(ApplicationDiscovery applicationDiscovery, ApplicationReader applicationReader) {
        this.applicationDiscovery = applicationDiscovery;
        this.applicationReader = applicationReader;
    }

    public List<ApplicationContent> loadApplications() {
        ArrayList<ApplicationContent> applications = new ArrayList<ApplicationContent>();
        List<Resource> applicationResources = this.applicationDiscovery.discoverApplications();
        try {
            for (Resource applicationResource : applicationResources) {
                InputStream inputStream = applicationResource.getInputStream();
                Throwable throwable = null;
                try {
                    applications.add(this.applicationReader.read(inputStream));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new AppliationLoadException("Unable to load application resource", e);
        }
        return applications;
    }
}

