/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl;

import java.io.Serializable;
import java.util.List;
import org.activiti5.engine.ActivitiIllegalArgumentException;
import org.activiti5.engine.impl.AbstractQuery;
import org.activiti5.engine.impl.DeploymentQueryProperty;
import org.activiti5.engine.impl.Page;
import org.activiti5.engine.impl.interceptor.CommandContext;
import org.activiti5.engine.impl.interceptor.CommandExecutor;
import org.activiti5.engine.repository.Deployment;
import org.activiti5.engine.repository.DeploymentQuery;

public class DeploymentQueryImpl
extends AbstractQuery<DeploymentQuery, Deployment>
implements DeploymentQuery,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String deploymentId;
    protected String name;
    protected String nameLike;
    protected String category;
    protected String categoryNotEquals;
    protected String tenantId;
    protected String tenantIdLike;
    protected boolean withoutTenantId;
    protected String processDefinitionKey;
    protected String processDefinitionKeyLike;

    public DeploymentQueryImpl() {
    }

    public DeploymentQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public DeploymentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public DeploymentQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new ActivitiIllegalArgumentException("Deployment id is null");
        }
        this.deploymentId = deploymentId;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentName(String deploymentName) {
        if (deploymentName == null) {
            throw new ActivitiIllegalArgumentException("deploymentName is null");
        }
        this.name = deploymentName;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentNameLike(String nameLike) {
        if (nameLike == null) {
            throw new ActivitiIllegalArgumentException("deploymentNameLike is null");
        }
        this.nameLike = nameLike;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentCategory(String deploymentCategory) {
        if (deploymentCategory == null) {
            throw new ActivitiIllegalArgumentException("deploymentCategory is null");
        }
        this.category = deploymentCategory;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentCategoryNotEquals(String deploymentCategoryNotEquals) {
        if (deploymentCategoryNotEquals == null) {
            throw new ActivitiIllegalArgumentException("deploymentCategoryExclude is null");
        }
        this.categoryNotEquals = deploymentCategoryNotEquals;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentTenantId(String tenantId) {
        if (tenantId == null) {
            throw new ActivitiIllegalArgumentException("deploymentTenantId is null");
        }
        this.tenantId = tenantId;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentTenantIdLike(String tenantIdLike) {
        if (tenantIdLike == null) {
            throw new ActivitiIllegalArgumentException("deploymentTenantIdLike is null");
        }
        this.tenantIdLike = tenantIdLike;
        return this;
    }

    @Override
    public DeploymentQueryImpl deploymentWithoutTenantId() {
        this.withoutTenantId = true;
        return this;
    }

    @Override
    public DeploymentQueryImpl processDefinitionKey(String key) {
        if (key == null) {
            throw new ActivitiIllegalArgumentException("key is null");
        }
        this.processDefinitionKey = key;
        return this;
    }

    @Override
    public DeploymentQueryImpl processDefinitionKeyLike(String keyLike) {
        if (keyLike == null) {
            throw new ActivitiIllegalArgumentException("keyLike is null");
        }
        this.processDefinitionKeyLike = keyLike;
        return this;
    }

    @Override
    public DeploymentQuery orderByDeploymentId() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_ID);
    }

    @Override
    public DeploymentQuery orderByDeploymenTime() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOY_TIME);
    }

    @Override
    public DeploymentQuery orderByDeploymentName() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_NAME);
    }

    @Override
    public DeploymentQuery orderByTenantId() {
        return (DeploymentQuery)this.orderBy(DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getDeploymentEntityManager().findDeploymentCountByQueryCriteria(this);
    }

    @Override
    public List<Deployment> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getDeploymentEntityManager().findDeploymentsByQueryCriteria(this, page);
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLike() {
        return this.nameLike;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryNotEquals() {
        return this.categoryNotEquals;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getTenantIdLike() {
        return this.tenantIdLike;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionKeyLike() {
        return this.processDefinitionKeyLike;
    }
}

