/*
 * Decompiled with CFR 0.152.
 */
package org.activiti5.engine.impl.bpmn.helper;

import java.util.List;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti5.engine.ActivitiActivityExecutionException;
import org.activiti5.engine.ActivitiException;
import org.activiti5.engine.delegate.BpmnError;
import org.activiti5.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti5.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.activiti5.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.activiti5.engine.impl.context.Context;
import org.activiti5.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti5.engine.impl.pvm.PvmActivity;
import org.activiti5.engine.impl.pvm.PvmProcessDefinition;
import org.activiti5.engine.impl.pvm.PvmScope;
import org.activiti5.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti5.engine.impl.pvm.process.ActivityImpl;
import org.activiti5.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti5.engine.impl.pvm.process.ScopeImpl;
import org.activiti5.engine.impl.pvm.runtime.AtomicOperation;
import org.activiti5.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti5.engine.impl.util.ReflectUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorPropagation {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorPropagation.class);

    public static void propagateError(BpmnError error, ActivityExecution execution) {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    public static void propagateError(String errorCode, ActivityExecution execution) {
        while (execution != null) {
            String eventHandlerId = ErrorPropagation.findLocalErrorEventHandler(execution, errorCode);
            if (eventHandlerId != null) {
                ErrorPropagation.executeCatch(eventHandlerId, execution, errorCode);
                break;
            }
            if (execution.isProcessInstanceType() && Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
                Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, execution));
            }
            execution = ErrorPropagation.getSuperExecution(execution);
        }
        if (execution == null) {
            throw new BpmnError(errorCode, "No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
        }
    }

    private static String findLocalErrorEventHandler(ActivityExecution execution, String errorCode) {
        PvmScope scope = execution.getActivity();
        while (scope != null) {
            List definitions = (List)scope.getProperty("errorEventDefinitions");
            if (definitions != null) {
                for (ErrorEventDefinition errorEventDefinition : definitions) {
                    if (!errorEventDefinition.catches(errorCode)) continue;
                    return scope.findActivity(errorEventDefinition.getHandlerActivityId()).getId();
                }
            }
            if (scope instanceof PvmActivity) {
                scope = scope.getParent();
                continue;
            }
            scope = null;
        }
        return null;
    }

    private static ActivityExecution getSuperExecution(ActivityExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ExecutionEntity superExecution = executionEntity.getProcessInstance().getSuperExecution();
        if (superExecution != null && !superExecution.isScope()) {
            return superExecution.getParent();
        }
        return superExecution;
    }

    private static void executeCatch(String errorHandlerId, ActivityExecution execution, String errorCode) {
        ActivityImpl catchingScopeActivity;
        ProcessDefinitionImpl processDefinition = ((ExecutionEntity)execution).getProcessDefinition();
        ActivityImpl errorHandler = processDefinition.findActivity(errorHandlerId);
        if (errorHandler == null) {
            throw new ActivitiException(errorHandlerId + " not found in process definition");
        }
        boolean matchingParentFound = false;
        ActivityExecution leavingExecution = execution;
        ActivityImpl currentActivity = (ActivityImpl)execution.getActivity();
        ScopeImpl catchingScope = errorHandler.getParent();
        if (catchingScope instanceof ActivityImpl && !(catchingScopeActivity = (ActivityImpl)catchingScope).isScope()) {
            catchingScope = catchingScopeActivity.getParent();
        }
        if (catchingScope instanceof PvmProcessDefinition) {
            ErrorPropagation.executeEventHandler(errorHandler, ((ExecutionEntity)execution).getProcessInstance(), errorCode);
        } else {
            if (currentActivity.getId().equals(catchingScope.getId())) {
                matchingParentFound = true;
            } else {
                currentActivity = (ActivityImpl)currentActivity.getParent();
                while (!matchingParentFound && leavingExecution != null && currentActivity != null) {
                    if (!leavingExecution.isConcurrent() && currentActivity.getId().equals(catchingScope.getId())) {
                        matchingParentFound = true;
                        continue;
                    }
                    if (leavingExecution.isConcurrent()) {
                        leavingExecution = leavingExecution.getParent();
                        continue;
                    }
                    currentActivity = currentActivity.getParentActivity();
                    leavingExecution = leavingExecution.getParent();
                }
                while (leavingExecution != null && leavingExecution.getParent() != null && leavingExecution.getParent().getActivity() != null && leavingExecution.getParent().getActivity().getId().equals(catchingScope.getId())) {
                    leavingExecution = leavingExecution.getParent();
                }
            }
            if (matchingParentFound && leavingExecution != null) {
                ErrorPropagation.executeEventHandler(errorHandler, leavingExecution, errorCode);
            } else {
                throw new ActivitiException("No matching parent execution for activity " + errorHandlerId + " found");
            }
        }
    }

    private static void executeEventHandler(ActivityImpl borderEventActivity, ActivityExecution leavingExecution, String errorCode) {
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createErrorEvent(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, borderEventActivity.getId(), errorCode, leavingExecution.getId(), leavingExecution.getProcessInstanceId(), leavingExecution.getProcessDefinitionId()));
        }
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)leavingExecution);
        if (borderEventActivity.getActivityBehavior() instanceof EventSubProcessStartEventActivityBehavior) {
            InterpretableExecution execution = (InterpretableExecution)leavingExecution;
            execution.setActivity(borderEventActivity.getParentActivity());
            execution.performOperation(AtomicOperation.ACTIVITY_START);
        } else {
            leavingExecution.executeActivity(borderEventActivity);
        }
    }

    public static boolean mapException(Exception e, ActivityExecution execution, List<MapExceptionEntry> exceptionMap) {
        return ErrorPropagation.mapException(e, execution, exceptionMap, false);
    }

    public static boolean mapException(Exception e, ActivityExecution execution, List<MapExceptionEntry> exceptionMap, boolean wrapped) {
        if (exceptionMap == null) {
            return false;
        }
        if (wrapped && e instanceof ActivitiActivityExecutionException) {
            e = (Exception)e.getCause();
        }
        String defaultMap = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class<?> exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultMap == null) {
                defaultMap = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                ErrorPropagation.propagateError(errorCode, execution);
                return true;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass(exceptionClass)).isAssignableFrom(e.getClass())) continue;
            ErrorPropagation.propagateError(errorCode, execution);
            return true;
        }
        if (defaultMap != null) {
            ErrorPropagation.propagateError(defaultMap, execution);
            return true;
        }
        return false;
    }
}

